// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class ListAssetsRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the asset model by which to filter the list of assets. This parameter is
     * required if you choose ALL for filter.
     */
    val assetModelId: String? = builder.assetModelId
    /**
     * The filter for the requested list of assets. Choose one of the following options:
     * ALL – The list includes all assets for a given asset model ID. The
     * assetModelId parameter is required if you filter by
     * ALL.
     * TOP_LEVEL – The list includes only top-level assets in the asset
     * hierarchy tree.
     * Default: ALL
     */
    val filter: ListAssetsFilter? = builder.filter
    /**
     * The maximum number of results to return for each paginated request.
     * Default: 50
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListAssetsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListAssetsRequest(")
        append("assetModelId=$assetModelId,")
        append("filter=$filter,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetModelId?.hashCode() ?: 0
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListAssetsRequest

        if (assetModelId != other.assetModelId) return false
        if (filter != other.filter) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListAssetsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListAssetsRequest
        /**
         * The ID of the asset model by which to filter the list of assets. This parameter is
         * required if you choose ALL for filter.
         */
        fun assetModelId(assetModelId: String): FluentBuilder
        /**
         * The filter for the requested list of assets. Choose one of the following options:
         * ALL – The list includes all assets for a given asset model ID. The
         * assetModelId parameter is required if you filter by
         * ALL.
         * TOP_LEVEL – The list includes only top-level assets in the asset
         * hierarchy tree.
         * Default: ALL
         */
        fun filter(filter: ListAssetsFilter): FluentBuilder
        /**
         * The maximum number of results to return for each paginated request.
         * Default: 50
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to be used for the next set of paginated results.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the asset model by which to filter the list of assets. This parameter is
         * required if you choose ALL for filter.
         */
        var assetModelId: String?
        /**
         * The filter for the requested list of assets. Choose one of the following options:
         * ALL – The list includes all assets for a given asset model ID. The
         * assetModelId parameter is required if you filter by
         * ALL.
         * TOP_LEVEL – The list includes only top-level assets in the asset
         * hierarchy tree.
         * Default: ALL
         */
        var filter: ListAssetsFilter?
        /**
         * The maximum number of results to return for each paginated request.
         * Default: 50
         */
        var maxResults: Int?
        /**
         * The token to be used for the next set of paginated results.
         */
        var nextToken: String?

        fun build(): ListAssetsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assetModelId: String? = null
        override var filter: ListAssetsFilter? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: ListAssetsRequest) : this() {
            this.assetModelId = x.assetModelId
            this.filter = x.filter
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): ListAssetsRequest = ListAssetsRequest(this)
        override fun assetModelId(assetModelId: String): FluentBuilder = apply { this.assetModelId = assetModelId }
        override fun filter(filter: ListAssetsFilter): FluentBuilder = apply { this.filter = filter }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
