// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class ListAssetRelationshipsRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the asset.
     */
    val assetId: String? = builder.assetId
    /**
     * The maximum number of results to return for each paginated request.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The type of traversal to use to identify asset relationships. Choose the following
     * option:
     * PATH_TO_ROOT – Identify the asset's parent assets up to the root
     * asset. The asset that you specify in assetId is the first result in the list
     * of assetRelationshipSummaries, and the root asset is the last result.
     */
    val traversalType: TraversalType? = builder.traversalType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListAssetRelationshipsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListAssetRelationshipsRequest(")
        append("assetId=$assetId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("traversalType=$traversalType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (traversalType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListAssetRelationshipsRequest

        if (assetId != other.assetId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (traversalType != other.traversalType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListAssetRelationshipsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListAssetRelationshipsRequest
        /**
         * The ID of the asset.
         */
        fun assetId(assetId: String): FluentBuilder
        /**
         * The maximum number of results to return for each paginated request.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to be used for the next set of paginated results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The type of traversal to use to identify asset relationships. Choose the following
         * option:
         * PATH_TO_ROOT – Identify the asset's parent assets up to the root
         * asset. The asset that you specify in assetId is the first result in the list
         * of assetRelationshipSummaries, and the root asset is the last result.
         */
        fun traversalType(traversalType: TraversalType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the asset.
         */
        var assetId: String?
        /**
         * The maximum number of results to return for each paginated request.
         */
        var maxResults: Int?
        /**
         * The token to be used for the next set of paginated results.
         */
        var nextToken: String?
        /**
         * The type of traversal to use to identify asset relationships. Choose the following
         * option:
         * PATH_TO_ROOT – Identify the asset's parent assets up to the root
         * asset. The asset that you specify in assetId is the first result in the list
         * of assetRelationshipSummaries, and the root asset is the last result.
         */
        var traversalType: TraversalType?

        fun build(): ListAssetRelationshipsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assetId: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var traversalType: TraversalType? = null

        constructor(x: ListAssetRelationshipsRequest) : this() {
            this.assetId = x.assetId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.traversalType = x.traversalType
        }

        override fun build(): ListAssetRelationshipsRequest = ListAssetRelationshipsRequest(this)
        override fun assetId(assetId: String): FluentBuilder = apply { this.assetId = assetId }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun traversalType(traversalType: TraversalType): FluentBuilder = apply { this.traversalType = traversalType }
    }
}
