// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class ListAccessPoliciesRequest private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs in the
     * IAM User Guide. This parameter is required if you specify
     * IAM for identityType.
     */
    val iamArn: String? = builder.iamArn
    /**
     * The ID of the identity. This parameter is required if you specify USER or
     * GROUP for identityType.
     */
    val identityId: String? = builder.identityId
    /**
     * The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This parameter is required
     * if you specify identityId.
     */
    val identityType: IdentityType? = builder.identityType
    /**
     * The maximum number of results to return for each paginated request.
     * Default: 50
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The ID of the resource. This parameter is required if you specify
     * resourceType.
     */
    val resourceId: String? = builder.resourceId
    /**
     * The type of resource (portal or project). This parameter is required if you specify
     * resourceId.
     */
    val resourceType: ResourceType? = builder.resourceType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListAccessPoliciesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListAccessPoliciesRequest(")
        append("iamArn=$iamArn,")
        append("identityId=$identityId,")
        append("identityType=$identityType,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = iamArn?.hashCode() ?: 0
        result = 31 * result + (identityId?.hashCode() ?: 0)
        result = 31 * result + (identityType?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListAccessPoliciesRequest

        if (iamArn != other.iamArn) return false
        if (identityId != other.identityId) return false
        if (identityType != other.identityType) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListAccessPoliciesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListAccessPoliciesRequest
        /**
         * The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs in the
         * IAM User Guide. This parameter is required if you specify
         * IAM for identityType.
         */
        fun iamArn(iamArn: String): FluentBuilder
        /**
         * The ID of the identity. This parameter is required if you specify USER or
         * GROUP for identityType.
         */
        fun identityId(identityId: String): FluentBuilder
        /**
         * The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This parameter is required
         * if you specify identityId.
         */
        fun identityType(identityType: IdentityType): FluentBuilder
        /**
         * The maximum number of results to return for each paginated request.
         * Default: 50
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to be used for the next set of paginated results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The ID of the resource. This parameter is required if you specify
         * resourceType.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * The type of resource (portal or project). This parameter is required if you specify
         * resourceId.
         */
        fun resourceType(resourceType: ResourceType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs in the
         * IAM User Guide. This parameter is required if you specify
         * IAM for identityType.
         */
        var iamArn: String?
        /**
         * The ID of the identity. This parameter is required if you specify USER or
         * GROUP for identityType.
         */
        var identityId: String?
        /**
         * The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This parameter is required
         * if you specify identityId.
         */
        var identityType: IdentityType?
        /**
         * The maximum number of results to return for each paginated request.
         * Default: 50
         */
        var maxResults: Int?
        /**
         * The token to be used for the next set of paginated results.
         */
        var nextToken: String?
        /**
         * The ID of the resource. This parameter is required if you specify
         * resourceType.
         */
        var resourceId: String?
        /**
         * The type of resource (portal or project). This parameter is required if you specify
         * resourceId.
         */
        var resourceType: ResourceType?

        fun build(): ListAccessPoliciesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var iamArn: String? = null
        override var identityId: String? = null
        override var identityType: IdentityType? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var resourceId: String? = null
        override var resourceType: ResourceType? = null

        constructor(x: ListAccessPoliciesRequest) : this() {
            this.iamArn = x.iamArn
            this.identityId = x.identityId
            this.identityType = x.identityType
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
        }

        override fun build(): ListAccessPoliciesRequest = ListAccessPoliciesRequest(this)
        override fun iamArn(iamArn: String): FluentBuilder = apply { this.iamArn = iamArn }
        override fun identityId(identityId: String): FluentBuilder = apply { this.identityId = identityId }
        override fun identityType(identityType: IdentityType): FluentBuilder = apply { this.identityType = identityType }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun resourceType(resourceType: ResourceType): FluentBuilder = apply { this.resourceType = resourceType }
    }
}
