// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains an identity that can access an IoT SiteWise Monitor resource.
 * Currently, you can't use Amazon Web Services APIs to retrieve Amazon Web Services SSO identity IDs. You can find the
 * Amazon Web Services SSO identity IDs in the URL of user and group pages in the <a href="https://console.aws.amazon.com/singlesignon">Amazon Web Services SSO console.
 */
class Identity private constructor(builder: BuilderImpl) {
    /**
     * An Amazon Web Services SSO group identity.
     */
    val group: GroupIdentity? = builder.group
    /**
     * An IAM role identity.
     */
    val iamRole: IamRoleIdentity? = builder.iamRole
    /**
     * An IAM user identity.
     */
    val iamUser: IamUserIdentity? = builder.iamUser
    /**
     * An Amazon Web Services SSO user identity.
     */
    val user: UserIdentity? = builder.user

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Identity = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Identity(")
        append("group=$group,")
        append("iamRole=$iamRole,")
        append("iamUser=$iamUser,")
        append("user=$user)")
    }

    override fun hashCode(): kotlin.Int {
        var result = group?.hashCode() ?: 0
        result = 31 * result + (iamRole?.hashCode() ?: 0)
        result = 31 * result + (iamUser?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Identity

        if (group != other.group) return false
        if (iamRole != other.iamRole) return false
        if (iamUser != other.iamUser) return false
        if (user != other.user) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Identity = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Identity
        /**
         * An Amazon Web Services SSO group identity.
         */
        fun group(group: GroupIdentity): FluentBuilder
        /**
         * An IAM role identity.
         */
        fun iamRole(iamRole: IamRoleIdentity): FluentBuilder
        /**
         * An IAM user identity.
         */
        fun iamUser(iamUser: IamUserIdentity): FluentBuilder
        /**
         * An Amazon Web Services SSO user identity.
         */
        fun user(user: UserIdentity): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An Amazon Web Services SSO group identity.
         */
        var group: GroupIdentity?
        /**
         * An IAM role identity.
         */
        var iamRole: IamRoleIdentity?
        /**
         * An IAM user identity.
         */
        var iamUser: IamUserIdentity?
        /**
         * An Amazon Web Services SSO user identity.
         */
        var user: UserIdentity?

        fun build(): Identity
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.GroupIdentity] inside the given [block]
         */
        fun group(block: GroupIdentity.DslBuilder.() -> kotlin.Unit) {
            this.group = GroupIdentity.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.IamRoleIdentity] inside the given [block]
         */
        fun iamRole(block: IamRoleIdentity.DslBuilder.() -> kotlin.Unit) {
            this.iamRole = IamRoleIdentity.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.IamUserIdentity] inside the given [block]
         */
        fun iamUser(block: IamUserIdentity.DslBuilder.() -> kotlin.Unit) {
            this.iamUser = IamUserIdentity.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.UserIdentity] inside the given [block]
         */
        fun user(block: UserIdentity.DslBuilder.() -> kotlin.Unit) {
            this.user = UserIdentity.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var group: GroupIdentity? = null
        override var iamRole: IamRoleIdentity? = null
        override var iamUser: IamUserIdentity? = null
        override var user: UserIdentity? = null

        constructor(x: Identity) : this() {
            this.group = x.group
            this.iamRole = x.iamRole
            this.iamUser = x.iamUser
            this.user = x.user
        }

        override fun build(): Identity = Identity(this)
        override fun group(group: GroupIdentity): FluentBuilder = apply { this.group = group }
        override fun iamRole(iamRole: IamRoleIdentity): FluentBuilder = apply { this.iamRole = iamRole }
        override fun iamUser(iamUser: IamUserIdentity): FluentBuilder = apply { this.iamUser = iamUser }
        override fun user(user: UserIdentity): FluentBuilder = apply { this.user = user }
    }
}
