// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains details for a gateway that runs on IoT Greengrass V2. To create a gateway that runs on IoT Greengrass V2,
 * you must deploy the IoT SiteWise Edge component to your gateway device.
 * Your <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/device-service-role.html">Greengrass device role
 * must use the AWSIoTSiteWiseEdgeAccess policy. For more information,
 * see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/sw-gateways.html">Using IoT SiteWise at the edge
 * in the IoT SiteWise User Guide.
 */
class GreengrassV2 private constructor(builder: BuilderImpl) {
    /**
     * The name of the IoT thing for your IoT Greengrass V2 core device.
     */
    val coreDeviceThingName: String? = builder.coreDeviceThingName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GreengrassV2 = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GreengrassV2(")
        append("coreDeviceThingName=$coreDeviceThingName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = coreDeviceThingName?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GreengrassV2

        if (coreDeviceThingName != other.coreDeviceThingName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GreengrassV2 = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GreengrassV2
        /**
         * The name of the IoT thing for your IoT Greengrass V2 core device.
         */
        fun coreDeviceThingName(coreDeviceThingName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the IoT thing for your IoT Greengrass V2 core device.
         */
        var coreDeviceThingName: String?

        fun build(): GreengrassV2
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var coreDeviceThingName: String? = null

        constructor(x: GreengrassV2) : this() {
            this.coreDeviceThingName = x.coreDeviceThingName
        }

        override fun build(): GreengrassV2 = GreengrassV2(this)
        override fun coreDeviceThingName(coreDeviceThingName: String): FluentBuilder = apply { this.coreDeviceThingName = coreDeviceThingName }
    }
}
