// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains details for a gateway that runs on IoT Greengrass. To create a gateway that runs on IoT Greengrass,
 * you must add the IoT SiteWise connector to a Greengrass group and deploy it. Your Greengrass
 * group must also have permissions to upload data to IoT SiteWise. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a
 * gateway in the IoT SiteWise User Guide.
 */
class Greengrass private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Greengrass group. For more information about how to find a group's
     * ARN, see <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html">ListGroups and <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html">GetGroup in the
     * IoT Greengrass API Reference.
     */
    val groupArn: String? = builder.groupArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Greengrass = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Greengrass(")
        append("groupArn=$groupArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupArn?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Greengrass

        if (groupArn != other.groupArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Greengrass = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Greengrass
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Greengrass group. For more information about how to find a group's
         * ARN, see <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html">ListGroups and <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html">GetGroup in the
         * IoT Greengrass API Reference.
         */
        fun groupArn(groupArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Greengrass group. For more information about how to find a group's
         * ARN, see <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html">ListGroups and <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html">GetGroup in the
         * IoT Greengrass API Reference.
         */
        var groupArn: String?

        fun build(): Greengrass
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var groupArn: String? = null

        constructor(x: Greengrass) : this() {
            this.groupArn = x.groupArn
        }

        override fun build(): Greengrass = Greengrass(this)
        override fun groupArn(groupArn: String): FluentBuilder = apply { this.groupArn = groupArn }
    }
}
