// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class GetInterpolatedAssetPropertyValuesRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the asset.
     */
    val assetId: String? = builder.assetId
    /**
     * The inclusive end of the range from which to interpolate data, expressed in seconds in
     * Unix epoch time.
     */
    val endTimeInSeconds: Long? = builder.endTimeInSeconds
    /**
     * The nanosecond offset converted from endTimeInSeconds.
     */
    val endTimeOffsetInNanos: Int? = builder.endTimeOffsetInNanos
    /**
     * The time interval in seconds over which to interpolate data. Each interval starts when the
     * previous one ends.
     */
    val intervalInSeconds: Long? = builder.intervalInSeconds
    /**
     * The query interval for the window in seconds. IoT SiteWise computes each interpolated value by using data points
     * from the timestamp of each interval minus the window to the timestamp of each interval plus the window.
     * If not specified, the window is between the start time minus the interval and the end time plus the interval.
     * If you specify a value for the intervalWindowInSeconds parameter,
     * the type parameter must be LINEAR_INTERPOLATION.
     * If no data point is found during the specified query window,
     * IoT SiteWise won't return an interpolated value for the interval.
     * This indicates that there's a gap in the ingested data points.
     * For example, you can get the interpolated temperature values for a wind turbine
     * every 24 hours over a duration of 7 days. If the interpolation starts on July 1, 2021,
     * at 9 AM with a window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM - 2 hours)
     * to 11 AM (9 AM + 2 hours) on July 2, 2021 to compute the first interpolated value,
     * uses the data points from 7 AM (9 AM - 2 hours) to 11 AM (9 AM + 2 hours) on July 3, 2021
     * to compute the second interpolated value, and so on.
     */
    val intervalWindowInSeconds: Long? = builder.intervalWindowInSeconds
    /**
     * The maximum number of results to return for each paginated request. If not specified, the default value is 10.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The alias that identifies the property, such as an OPC-UA server data stream path
     * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
     * IoT SiteWise User Guide.
     */
    val propertyAlias: String? = builder.propertyAlias
    /**
     * The ID of the asset property.
     */
    val propertyId: String? = builder.propertyId
    /**
     * The quality of the asset property value. You can use this parameter as a filter to choose
     * only the asset property values that have a specific quality.
     */
    val quality: Quality? = builder.quality
    /**
     * The exclusive start of the range from which to interpolate data, expressed in seconds in
     * Unix epoch time.
     */
    val startTimeInSeconds: Long? = builder.startTimeInSeconds
    /**
     * The nanosecond offset converted from startTimeInSeconds.
     */
    val startTimeOffsetInNanos: Int? = builder.startTimeOffsetInNanos
    /**
     * The interpolation type.
     * Valid values: LINEAR_INTERPOLATION | LOCF_INTERPOLATION
     * LINEAR_INTERPOLATION – Estimates missing data using <a href="https://en.wikipedia.org/wiki/Linear_interpolation">linear interpolation.
     * For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days.
     * If the interpolation starts on July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM, the second interpolated value
     * on July 3, 2021, at 9 AM, and so on.
     * LOCF_INTERPOLATION – Estimates missing data using last observation carried forward interpolation
     * If no data point is found for an interval,
     * IoT SiteWise returns the last observed data point for the previous interval
     * and carries forward this interpolated value until a new data point is found.
     * For example, you can get the state of an on-off valve every 24 hours over a duration of 7 days.
     * If the interpolation starts on July 1, 2021, at 9 AM, IoT SiteWise returns the last observed data point between July 1, 2021,
     * at 9 AM and July 2, 2021, at 9 AM as the first interpolated value.
     * If no data point is found after 9 AM on July 2, 2021, IoT SiteWise uses the same interpolated value for the rest of the days.
     */
    val type: String? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetInterpolatedAssetPropertyValuesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetInterpolatedAssetPropertyValuesRequest(")
        append("assetId=$assetId,")
        append("endTimeInSeconds=$endTimeInSeconds,")
        append("endTimeOffsetInNanos=$endTimeOffsetInNanos,")
        append("intervalInSeconds=$intervalInSeconds,")
        append("intervalWindowInSeconds=$intervalWindowInSeconds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("propertyAlias=$propertyAlias,")
        append("propertyId=$propertyId,")
        append("quality=$quality,")
        append("startTimeInSeconds=$startTimeInSeconds,")
        append("startTimeOffsetInNanos=$startTimeOffsetInNanos,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (endTimeInSeconds?.hashCode() ?: 0)
        result = 31 * result + (endTimeOffsetInNanos ?: 0)
        result = 31 * result + (intervalInSeconds?.hashCode() ?: 0)
        result = 31 * result + (intervalWindowInSeconds?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (propertyAlias?.hashCode() ?: 0)
        result = 31 * result + (propertyId?.hashCode() ?: 0)
        result = 31 * result + (quality?.hashCode() ?: 0)
        result = 31 * result + (startTimeInSeconds?.hashCode() ?: 0)
        result = 31 * result + (startTimeOffsetInNanos ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetInterpolatedAssetPropertyValuesRequest

        if (assetId != other.assetId) return false
        if (endTimeInSeconds != other.endTimeInSeconds) return false
        if (endTimeOffsetInNanos != other.endTimeOffsetInNanos) return false
        if (intervalInSeconds != other.intervalInSeconds) return false
        if (intervalWindowInSeconds != other.intervalWindowInSeconds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (propertyAlias != other.propertyAlias) return false
        if (propertyId != other.propertyId) return false
        if (quality != other.quality) return false
        if (startTimeInSeconds != other.startTimeInSeconds) return false
        if (startTimeOffsetInNanos != other.startTimeOffsetInNanos) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetInterpolatedAssetPropertyValuesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetInterpolatedAssetPropertyValuesRequest
        /**
         * The ID of the asset.
         */
        fun assetId(assetId: String): FluentBuilder
        /**
         * The inclusive end of the range from which to interpolate data, expressed in seconds in
         * Unix epoch time.
         */
        fun endTimeInSeconds(endTimeInSeconds: Long): FluentBuilder
        /**
         * The nanosecond offset converted from endTimeInSeconds.
         */
        fun endTimeOffsetInNanos(endTimeOffsetInNanos: Int): FluentBuilder
        /**
         * The time interval in seconds over which to interpolate data. Each interval starts when the
         * previous one ends.
         */
        fun intervalInSeconds(intervalInSeconds: Long): FluentBuilder
        /**
         * The query interval for the window in seconds. IoT SiteWise computes each interpolated value by using data points
         * from the timestamp of each interval minus the window to the timestamp of each interval plus the window.
         * If not specified, the window is between the start time minus the interval and the end time plus the interval.
         * If you specify a value for the intervalWindowInSeconds parameter,
         * the type parameter must be LINEAR_INTERPOLATION.
         * If no data point is found during the specified query window,
         * IoT SiteWise won't return an interpolated value for the interval.
         * This indicates that there's a gap in the ingested data points.
         * For example, you can get the interpolated temperature values for a wind turbine
         * every 24 hours over a duration of 7 days. If the interpolation starts on July 1, 2021,
         * at 9 AM with a window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM - 2 hours)
         * to 11 AM (9 AM + 2 hours) on July 2, 2021 to compute the first interpolated value,
         * uses the data points from 7 AM (9 AM - 2 hours) to 11 AM (9 AM + 2 hours) on July 3, 2021
         * to compute the second interpolated value, and so on.
         */
        fun intervalWindowInSeconds(intervalWindowInSeconds: Long): FluentBuilder
        /**
         * The maximum number of results to return for each paginated request. If not specified, the default value is 10.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to be used for the next set of paginated results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path
         * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
         * IoT SiteWise User Guide.
         */
        fun propertyAlias(propertyAlias: String): FluentBuilder
        /**
         * The ID of the asset property.
         */
        fun propertyId(propertyId: String): FluentBuilder
        /**
         * The quality of the asset property value. You can use this parameter as a filter to choose
         * only the asset property values that have a specific quality.
         */
        fun quality(quality: Quality): FluentBuilder
        /**
         * The exclusive start of the range from which to interpolate data, expressed in seconds in
         * Unix epoch time.
         */
        fun startTimeInSeconds(startTimeInSeconds: Long): FluentBuilder
        /**
         * The nanosecond offset converted from startTimeInSeconds.
         */
        fun startTimeOffsetInNanos(startTimeOffsetInNanos: Int): FluentBuilder
        /**
         * The interpolation type.
         * Valid values: LINEAR_INTERPOLATION | LOCF_INTERPOLATION
         * LINEAR_INTERPOLATION – Estimates missing data using <a href="https://en.wikipedia.org/wiki/Linear_interpolation">linear interpolation.
         * For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days.
         * If the interpolation starts on July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM, the second interpolated value
         * on July 3, 2021, at 9 AM, and so on.
         * LOCF_INTERPOLATION – Estimates missing data using last observation carried forward interpolation
         * If no data point is found for an interval,
         * IoT SiteWise returns the last observed data point for the previous interval
         * and carries forward this interpolated value until a new data point is found.
         * For example, you can get the state of an on-off valve every 24 hours over a duration of 7 days.
         * If the interpolation starts on July 1, 2021, at 9 AM, IoT SiteWise returns the last observed data point between July 1, 2021,
         * at 9 AM and July 2, 2021, at 9 AM as the first interpolated value.
         * If no data point is found after 9 AM on July 2, 2021, IoT SiteWise uses the same interpolated value for the rest of the days.
         */
        fun type(type: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the asset.
         */
        var assetId: String?
        /**
         * The inclusive end of the range from which to interpolate data, expressed in seconds in
         * Unix epoch time.
         */
        var endTimeInSeconds: Long?
        /**
         * The nanosecond offset converted from endTimeInSeconds.
         */
        var endTimeOffsetInNanos: Int?
        /**
         * The time interval in seconds over which to interpolate data. Each interval starts when the
         * previous one ends.
         */
        var intervalInSeconds: Long?
        /**
         * The query interval for the window in seconds. IoT SiteWise computes each interpolated value by using data points
         * from the timestamp of each interval minus the window to the timestamp of each interval plus the window.
         * If not specified, the window is between the start time minus the interval and the end time plus the interval.
         * If you specify a value for the intervalWindowInSeconds parameter,
         * the type parameter must be LINEAR_INTERPOLATION.
         * If no data point is found during the specified query window,
         * IoT SiteWise won't return an interpolated value for the interval.
         * This indicates that there's a gap in the ingested data points.
         * For example, you can get the interpolated temperature values for a wind turbine
         * every 24 hours over a duration of 7 days. If the interpolation starts on July 1, 2021,
         * at 9 AM with a window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM - 2 hours)
         * to 11 AM (9 AM + 2 hours) on July 2, 2021 to compute the first interpolated value,
         * uses the data points from 7 AM (9 AM - 2 hours) to 11 AM (9 AM + 2 hours) on July 3, 2021
         * to compute the second interpolated value, and so on.
         */
        var intervalWindowInSeconds: Long?
        /**
         * The maximum number of results to return for each paginated request. If not specified, the default value is 10.
         */
        var maxResults: Int?
        /**
         * The token to be used for the next set of paginated results.
         */
        var nextToken: String?
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path
         * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
         * IoT SiteWise User Guide.
         */
        var propertyAlias: String?
        /**
         * The ID of the asset property.
         */
        var propertyId: String?
        /**
         * The quality of the asset property value. You can use this parameter as a filter to choose
         * only the asset property values that have a specific quality.
         */
        var quality: Quality?
        /**
         * The exclusive start of the range from which to interpolate data, expressed in seconds in
         * Unix epoch time.
         */
        var startTimeInSeconds: Long?
        /**
         * The nanosecond offset converted from startTimeInSeconds.
         */
        var startTimeOffsetInNanos: Int?
        /**
         * The interpolation type.
         * Valid values: LINEAR_INTERPOLATION | LOCF_INTERPOLATION
         * LINEAR_INTERPOLATION – Estimates missing data using <a href="https://en.wikipedia.org/wiki/Linear_interpolation">linear interpolation.
         * For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days.
         * If the interpolation starts on July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM, the second interpolated value
         * on July 3, 2021, at 9 AM, and so on.
         * LOCF_INTERPOLATION – Estimates missing data using last observation carried forward interpolation
         * If no data point is found for an interval,
         * IoT SiteWise returns the last observed data point for the previous interval
         * and carries forward this interpolated value until a new data point is found.
         * For example, you can get the state of an on-off valve every 24 hours over a duration of 7 days.
         * If the interpolation starts on July 1, 2021, at 9 AM, IoT SiteWise returns the last observed data point between July 1, 2021,
         * at 9 AM and July 2, 2021, at 9 AM as the first interpolated value.
         * If no data point is found after 9 AM on July 2, 2021, IoT SiteWise uses the same interpolated value for the rest of the days.
         */
        var type: String?

        fun build(): GetInterpolatedAssetPropertyValuesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assetId: String? = null
        override var endTimeInSeconds: Long? = null
        override var endTimeOffsetInNanos: Int? = null
        override var intervalInSeconds: Long? = null
        override var intervalWindowInSeconds: Long? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var propertyAlias: String? = null
        override var propertyId: String? = null
        override var quality: Quality? = null
        override var startTimeInSeconds: Long? = null
        override var startTimeOffsetInNanos: Int? = null
        override var type: String? = null

        constructor(x: GetInterpolatedAssetPropertyValuesRequest) : this() {
            this.assetId = x.assetId
            this.endTimeInSeconds = x.endTimeInSeconds
            this.endTimeOffsetInNanos = x.endTimeOffsetInNanos
            this.intervalInSeconds = x.intervalInSeconds
            this.intervalWindowInSeconds = x.intervalWindowInSeconds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.propertyAlias = x.propertyAlias
            this.propertyId = x.propertyId
            this.quality = x.quality
            this.startTimeInSeconds = x.startTimeInSeconds
            this.startTimeOffsetInNanos = x.startTimeOffsetInNanos
            this.type = x.type
        }

        override fun build(): GetInterpolatedAssetPropertyValuesRequest = GetInterpolatedAssetPropertyValuesRequest(this)
        override fun assetId(assetId: String): FluentBuilder = apply { this.assetId = assetId }
        override fun endTimeInSeconds(endTimeInSeconds: Long): FluentBuilder = apply { this.endTimeInSeconds = endTimeInSeconds }
        override fun endTimeOffsetInNanos(endTimeOffsetInNanos: Int): FluentBuilder = apply { this.endTimeOffsetInNanos = endTimeOffsetInNanos }
        override fun intervalInSeconds(intervalInSeconds: Long): FluentBuilder = apply { this.intervalInSeconds = intervalInSeconds }
        override fun intervalWindowInSeconds(intervalWindowInSeconds: Long): FluentBuilder = apply { this.intervalWindowInSeconds = intervalWindowInSeconds }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun propertyAlias(propertyAlias: String): FluentBuilder = apply { this.propertyAlias = propertyAlias }
        override fun propertyId(propertyId: String): FluentBuilder = apply { this.propertyId = propertyId }
        override fun quality(quality: Quality): FluentBuilder = apply { this.quality = quality }
        override fun startTimeInSeconds(startTimeInSeconds: Long): FluentBuilder = apply { this.startTimeInSeconds = startTimeInSeconds }
        override fun startTimeOffsetInNanos(startTimeOffsetInNanos: Int): FluentBuilder = apply { this.startTimeOffsetInNanos = startTimeOffsetInNanos }
        override fun type(type: String): FluentBuilder = apply { this.type = type }
    }
}
