// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class GetAssetPropertyValueRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the asset.
     */
    val assetId: String? = builder.assetId
    /**
     * The alias that identifies the property, such as an OPC-UA server data stream path
     * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
     * IoT SiteWise User Guide.
     */
    val propertyAlias: String? = builder.propertyAlias
    /**
     * The ID of the asset property.
     */
    val propertyId: String? = builder.propertyId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetAssetPropertyValueRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetAssetPropertyValueRequest(")
        append("assetId=$assetId,")
        append("propertyAlias=$propertyAlias,")
        append("propertyId=$propertyId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (propertyAlias?.hashCode() ?: 0)
        result = 31 * result + (propertyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetAssetPropertyValueRequest

        if (assetId != other.assetId) return false
        if (propertyAlias != other.propertyAlias) return false
        if (propertyId != other.propertyId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetAssetPropertyValueRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetAssetPropertyValueRequest
        /**
         * The ID of the asset.
         */
        fun assetId(assetId: String): FluentBuilder
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path
         * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
         * IoT SiteWise User Guide.
         */
        fun propertyAlias(propertyAlias: String): FluentBuilder
        /**
         * The ID of the asset property.
         */
        fun propertyId(propertyId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the asset.
         */
        var assetId: String?
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path
         * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
         * IoT SiteWise User Guide.
         */
        var propertyAlias: String?
        /**
         * The ID of the asset property.
         */
        var propertyId: String?

        fun build(): GetAssetPropertyValueRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assetId: String? = null
        override var propertyAlias: String? = null
        override var propertyId: String? = null

        constructor(x: GetAssetPropertyValueRequest) : this() {
            this.assetId = x.assetId
            this.propertyAlias = x.propertyAlias
            this.propertyId = x.propertyId
        }

        override fun build(): GetAssetPropertyValueRequest = GetAssetPropertyValueRequest(this)
        override fun assetId(assetId: String): FluentBuilder = apply { this.assetId = assetId }
        override fun propertyAlias(propertyAlias: String): FluentBuilder = apply { this.propertyAlias = propertyAlias }
        override fun propertyId(propertyId: String): FluentBuilder = apply { this.propertyId = propertyId }
    }
}
