// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.time.Instant

class GetAssetPropertyAggregatesRequest private constructor(builder: BuilderImpl) {
    /**
     * The data aggregating function.
     */
    val aggregateTypes: List<AggregateType>? = builder.aggregateTypes
    /**
     * The ID of the asset.
     */
    val assetId: String? = builder.assetId
    /**
     * The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.
     */
    val endDate: Instant? = builder.endDate
    /**
     * The maximum number of results to return for each paginated request.
     * Default: 100
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The alias that identifies the property, such as an OPC-UA server data stream path
     * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
     * IoT SiteWise User Guide.
     */
    val propertyAlias: String? = builder.propertyAlias
    /**
     * The ID of the asset property.
     */
    val propertyId: String? = builder.propertyId
    /**
     * The quality by which to filter asset data.
     */
    val qualities: List<Quality>? = builder.qualities
    /**
     * The time interval over which to aggregate data.
     */
    val resolution: String? = builder.resolution
    /**
     * The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.
     */
    val startDate: Instant? = builder.startDate
    /**
     * The chronological sorting order of the requested information.
     * Default: ASCENDING
     */
    val timeOrdering: TimeOrdering? = builder.timeOrdering

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetAssetPropertyAggregatesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetAssetPropertyAggregatesRequest(")
        append("aggregateTypes=$aggregateTypes,")
        append("assetId=$assetId,")
        append("endDate=$endDate,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("propertyAlias=$propertyAlias,")
        append("propertyId=$propertyId,")
        append("qualities=$qualities,")
        append("resolution=$resolution,")
        append("startDate=$startDate,")
        append("timeOrdering=$timeOrdering)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregateTypes?.hashCode() ?: 0
        result = 31 * result + (assetId?.hashCode() ?: 0)
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (propertyAlias?.hashCode() ?: 0)
        result = 31 * result + (propertyId?.hashCode() ?: 0)
        result = 31 * result + (qualities?.hashCode() ?: 0)
        result = 31 * result + (resolution?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (timeOrdering?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetAssetPropertyAggregatesRequest

        if (aggregateTypes != other.aggregateTypes) return false
        if (assetId != other.assetId) return false
        if (endDate != other.endDate) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (propertyAlias != other.propertyAlias) return false
        if (propertyId != other.propertyId) return false
        if (qualities != other.qualities) return false
        if (resolution != other.resolution) return false
        if (startDate != other.startDate) return false
        if (timeOrdering != other.timeOrdering) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetAssetPropertyAggregatesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetAssetPropertyAggregatesRequest
        /**
         * The data aggregating function.
         */
        fun aggregateTypes(aggregateTypes: List<AggregateType>): FluentBuilder
        /**
         * The ID of the asset.
         */
        fun assetId(assetId: String): FluentBuilder
        /**
         * The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.
         */
        fun endDate(endDate: Instant): FluentBuilder
        /**
         * The maximum number of results to return for each paginated request.
         * Default: 100
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to be used for the next set of paginated results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path
         * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
         * IoT SiteWise User Guide.
         */
        fun propertyAlias(propertyAlias: String): FluentBuilder
        /**
         * The ID of the asset property.
         */
        fun propertyId(propertyId: String): FluentBuilder
        /**
         * The quality by which to filter asset data.
         */
        fun qualities(qualities: List<Quality>): FluentBuilder
        /**
         * The time interval over which to aggregate data.
         */
        fun resolution(resolution: String): FluentBuilder
        /**
         * The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.
         */
        fun startDate(startDate: Instant): FluentBuilder
        /**
         * The chronological sorting order of the requested information.
         * Default: ASCENDING
         */
        fun timeOrdering(timeOrdering: TimeOrdering): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The data aggregating function.
         */
        var aggregateTypes: List<AggregateType>?
        /**
         * The ID of the asset.
         */
        var assetId: String?
        /**
         * The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.
         */
        var endDate: Instant?
        /**
         * The maximum number of results to return for each paginated request.
         * Default: 100
         */
        var maxResults: Int?
        /**
         * The token to be used for the next set of paginated results.
         */
        var nextToken: String?
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path
         * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
         * IoT SiteWise User Guide.
         */
        var propertyAlias: String?
        /**
         * The ID of the asset property.
         */
        var propertyId: String?
        /**
         * The quality by which to filter asset data.
         */
        var qualities: List<Quality>?
        /**
         * The time interval over which to aggregate data.
         */
        var resolution: String?
        /**
         * The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.
         */
        var startDate: Instant?
        /**
         * The chronological sorting order of the requested information.
         * Default: ASCENDING
         */
        var timeOrdering: TimeOrdering?

        fun build(): GetAssetPropertyAggregatesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var aggregateTypes: List<AggregateType>? = null
        override var assetId: String? = null
        override var endDate: Instant? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var propertyAlias: String? = null
        override var propertyId: String? = null
        override var qualities: List<Quality>? = null
        override var resolution: String? = null
        override var startDate: Instant? = null
        override var timeOrdering: TimeOrdering? = null

        constructor(x: GetAssetPropertyAggregatesRequest) : this() {
            this.aggregateTypes = x.aggregateTypes
            this.assetId = x.assetId
            this.endDate = x.endDate
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.propertyAlias = x.propertyAlias
            this.propertyId = x.propertyId
            this.qualities = x.qualities
            this.resolution = x.resolution
            this.startDate = x.startDate
            this.timeOrdering = x.timeOrdering
        }

        override fun build(): GetAssetPropertyAggregatesRequest = GetAssetPropertyAggregatesRequest(this)
        override fun aggregateTypes(aggregateTypes: List<AggregateType>): FluentBuilder = apply { this.aggregateTypes = aggregateTypes }
        override fun assetId(assetId: String): FluentBuilder = apply { this.assetId = assetId }
        override fun endDate(endDate: Instant): FluentBuilder = apply { this.endDate = endDate }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun propertyAlias(propertyAlias: String): FluentBuilder = apply { this.propertyAlias = propertyAlias }
        override fun propertyId(propertyId: String): FluentBuilder = apply { this.propertyId = propertyId }
        override fun qualities(qualities: List<Quality>): FluentBuilder = apply { this.qualities = qualities }
        override fun resolution(resolution: String): FluentBuilder = apply { this.resolution = resolution }
        override fun startDate(startDate: Instant): FluentBuilder = apply { this.startDate = startDate }
        override fun timeOrdering(timeOrdering: TimeOrdering): FluentBuilder = apply { this.timeOrdering = timeOrdering }
    }
}
