// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a summary of a gateway.
 */
class GatewaySummary private constructor(builder: BuilderImpl) {
    /**
     * The date the gateway was created, in Unix epoch time.
     */
    val creationDate: Instant? = builder.creationDate
    /**
     * A list of gateway capability summaries that each contain a namespace and status. Each
     * gateway capability defines data sources for the gateway. To retrieve a capability
     * configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration.
     */
    val gatewayCapabilitySummaries: List<GatewayCapabilitySummary>? = builder.gatewayCapabilitySummaries
    /**
     * The ID of the gateway device.
     */
    val gatewayId: String? = builder.gatewayId
    /**
     * The name of the asset.
     */
    val gatewayName: String? = builder.gatewayName
    /**
     * Contains a gateway's platform information.
     */
    val gatewayPlatform: GatewayPlatform? = builder.gatewayPlatform
    /**
     * The date the gateway was last updated, in Unix epoch time.
     */
    val lastUpdateDate: Instant? = builder.lastUpdateDate

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GatewaySummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GatewaySummary(")
        append("creationDate=$creationDate,")
        append("gatewayCapabilitySummaries=$gatewayCapabilitySummaries,")
        append("gatewayId=$gatewayId,")
        append("gatewayName=$gatewayName,")
        append("gatewayPlatform=$gatewayPlatform,")
        append("lastUpdateDate=$lastUpdateDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate?.hashCode() ?: 0
        result = 31 * result + (gatewayCapabilitySummaries?.hashCode() ?: 0)
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        result = 31 * result + (gatewayName?.hashCode() ?: 0)
        result = 31 * result + (gatewayPlatform?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GatewaySummary

        if (creationDate != other.creationDate) return false
        if (gatewayCapabilitySummaries != other.gatewayCapabilitySummaries) return false
        if (gatewayId != other.gatewayId) return false
        if (gatewayName != other.gatewayName) return false
        if (gatewayPlatform != other.gatewayPlatform) return false
        if (lastUpdateDate != other.lastUpdateDate) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GatewaySummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GatewaySummary
        /**
         * The date the gateway was created, in Unix epoch time.
         */
        fun creationDate(creationDate: Instant): FluentBuilder
        /**
         * A list of gateway capability summaries that each contain a namespace and status. Each
         * gateway capability defines data sources for the gateway. To retrieve a capability
         * configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration.
         */
        fun gatewayCapabilitySummaries(gatewayCapabilitySummaries: List<GatewayCapabilitySummary>): FluentBuilder
        /**
         * The ID of the gateway device.
         */
        fun gatewayId(gatewayId: String): FluentBuilder
        /**
         * The name of the asset.
         */
        fun gatewayName(gatewayName: String): FluentBuilder
        /**
         * Contains a gateway's platform information.
         */
        fun gatewayPlatform(gatewayPlatform: GatewayPlatform): FluentBuilder
        /**
         * The date the gateway was last updated, in Unix epoch time.
         */
        fun lastUpdateDate(lastUpdateDate: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date the gateway was created, in Unix epoch time.
         */
        var creationDate: Instant?
        /**
         * A list of gateway capability summaries that each contain a namespace and status. Each
         * gateway capability defines data sources for the gateway. To retrieve a capability
         * configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration.
         */
        var gatewayCapabilitySummaries: List<GatewayCapabilitySummary>?
        /**
         * The ID of the gateway device.
         */
        var gatewayId: String?
        /**
         * The name of the asset.
         */
        var gatewayName: String?
        /**
         * Contains a gateway's platform information.
         */
        var gatewayPlatform: GatewayPlatform?
        /**
         * The date the gateway was last updated, in Unix epoch time.
         */
        var lastUpdateDate: Instant?

        fun build(): GatewaySummary
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.GatewayPlatform] inside the given [block]
         */
        fun gatewayPlatform(block: GatewayPlatform.DslBuilder.() -> kotlin.Unit) {
            this.gatewayPlatform = GatewayPlatform.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationDate: Instant? = null
        override var gatewayCapabilitySummaries: List<GatewayCapabilitySummary>? = null
        override var gatewayId: String? = null
        override var gatewayName: String? = null
        override var gatewayPlatform: GatewayPlatform? = null
        override var lastUpdateDate: Instant? = null

        constructor(x: GatewaySummary) : this() {
            this.creationDate = x.creationDate
            this.gatewayCapabilitySummaries = x.gatewayCapabilitySummaries
            this.gatewayId = x.gatewayId
            this.gatewayName = x.gatewayName
            this.gatewayPlatform = x.gatewayPlatform
            this.lastUpdateDate = x.lastUpdateDate
        }

        override fun build(): GatewaySummary = GatewaySummary(this)
        override fun creationDate(creationDate: Instant): FluentBuilder = apply { this.creationDate = creationDate }
        override fun gatewayCapabilitySummaries(gatewayCapabilitySummaries: List<GatewayCapabilitySummary>): FluentBuilder = apply { this.gatewayCapabilitySummaries = gatewayCapabilitySummaries }
        override fun gatewayId(gatewayId: String): FluentBuilder = apply { this.gatewayId = gatewayId }
        override fun gatewayName(gatewayName: String): FluentBuilder = apply { this.gatewayName = gatewayName }
        override fun gatewayPlatform(gatewayPlatform: GatewayPlatform): FluentBuilder = apply { this.gatewayPlatform = gatewayPlatform }
        override fun lastUpdateDate(lastUpdateDate: Instant): FluentBuilder = apply { this.lastUpdateDate = lastUpdateDate }
    }
}
