// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains a summary of a gateway capability configuration.
 */
class GatewayCapabilitySummary private constructor(builder: BuilderImpl) {
    /**
     * The namespace of the capability configuration.
     * For example, if you configure OPC-UA
     * sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
     * iotsitewise:opcuacollector:version, where version is a number such as
     * 1.
     */
    val capabilityNamespace: String? = builder.capabilityNamespace
    /**
     * The synchronization status of the capability configuration. The sync status can be one of the following:
     * IN_SYNC – The gateway is running the capability configuration.
     * OUT_OF_SYNC – The gateway hasn't received the capability configuration.
     * SYNC_FAILED – The gateway rejected the capability configuration.
     */
    val capabilitySyncStatus: CapabilitySyncStatus? = builder.capabilitySyncStatus

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GatewayCapabilitySummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GatewayCapabilitySummary(")
        append("capabilityNamespace=$capabilityNamespace,")
        append("capabilitySyncStatus=$capabilitySyncStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilityNamespace?.hashCode() ?: 0
        result = 31 * result + (capabilitySyncStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GatewayCapabilitySummary

        if (capabilityNamespace != other.capabilityNamespace) return false
        if (capabilitySyncStatus != other.capabilitySyncStatus) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GatewayCapabilitySummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GatewayCapabilitySummary
        /**
         * The namespace of the capability configuration.
         * For example, if you configure OPC-UA
         * sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
         * iotsitewise:opcuacollector:version, where version is a number such as
         * 1.
         */
        fun capabilityNamespace(capabilityNamespace: String): FluentBuilder
        /**
         * The synchronization status of the capability configuration. The sync status can be one of the following:
         * IN_SYNC – The gateway is running the capability configuration.
         * OUT_OF_SYNC – The gateway hasn't received the capability configuration.
         * SYNC_FAILED – The gateway rejected the capability configuration.
         */
        fun capabilitySyncStatus(capabilitySyncStatus: CapabilitySyncStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The namespace of the capability configuration.
         * For example, if you configure OPC-UA
         * sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
         * iotsitewise:opcuacollector:version, where version is a number such as
         * 1.
         */
        var capabilityNamespace: String?
        /**
         * The synchronization status of the capability configuration. The sync status can be one of the following:
         * IN_SYNC – The gateway is running the capability configuration.
         * OUT_OF_SYNC – The gateway hasn't received the capability configuration.
         * SYNC_FAILED – The gateway rejected the capability configuration.
         */
        var capabilitySyncStatus: CapabilitySyncStatus?

        fun build(): GatewayCapabilitySummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var capabilityNamespace: String? = null
        override var capabilitySyncStatus: CapabilitySyncStatus? = null

        constructor(x: GatewayCapabilitySummary) : this() {
            this.capabilityNamespace = x.capabilityNamespace
            this.capabilitySyncStatus = x.capabilitySyncStatus
        }

        override fun build(): GatewayCapabilitySummary = GatewayCapabilitySummary(this)
        override fun capabilityNamespace(capabilityNamespace: String): FluentBuilder = apply { this.capabilityNamespace = capabilityNamespace }
        override fun capabilitySyncStatus(capabilitySyncStatus: CapabilitySyncStatus): FluentBuilder = apply { this.capabilitySyncStatus = capabilitySyncStatus }
    }
}
