// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeProjectResponse private constructor(builder: BuilderImpl) {
    /**
     * The ID of the portal that the project is in.
     */
    val portalId: String? = builder.portalId
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the project, which has the following format.
     * arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}
     */
    val projectArn: String? = builder.projectArn
    /**
     * The date the project was created, in Unix epoch time.
     */
    val projectCreationDate: Instant? = builder.projectCreationDate
    /**
     * The project's description.
     */
    val projectDescription: String? = builder.projectDescription
    /**
     * The ID of the project.
     */
    val projectId: String? = builder.projectId
    /**
     * The date the project was last updated, in Unix epoch time.
     */
    val projectLastUpdateDate: Instant? = builder.projectLastUpdateDate
    /**
     * The name of the project.
     */
    val projectName: String? = builder.projectName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeProjectResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeProjectResponse(")
        append("portalId=$portalId,")
        append("projectArn=$projectArn,")
        append("projectCreationDate=$projectCreationDate,")
        append("projectDescription=$projectDescription,")
        append("projectId=$projectId,")
        append("projectLastUpdateDate=$projectLastUpdateDate,")
        append("projectName=$projectName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = portalId?.hashCode() ?: 0
        result = 31 * result + (projectArn?.hashCode() ?: 0)
        result = 31 * result + (projectCreationDate?.hashCode() ?: 0)
        result = 31 * result + (projectDescription?.hashCode() ?: 0)
        result = 31 * result + (projectId?.hashCode() ?: 0)
        result = 31 * result + (projectLastUpdateDate?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeProjectResponse

        if (portalId != other.portalId) return false
        if (projectArn != other.projectArn) return false
        if (projectCreationDate != other.projectCreationDate) return false
        if (projectDescription != other.projectDescription) return false
        if (projectId != other.projectId) return false
        if (projectLastUpdateDate != other.projectLastUpdateDate) return false
        if (projectName != other.projectName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeProjectResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeProjectResponse
        /**
         * The ID of the portal that the project is in.
         */
        fun portalId(portalId: String): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the project, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}
         */
        fun projectArn(projectArn: String): FluentBuilder
        /**
         * The date the project was created, in Unix epoch time.
         */
        fun projectCreationDate(projectCreationDate: Instant): FluentBuilder
        /**
         * The project's description.
         */
        fun projectDescription(projectDescription: String): FluentBuilder
        /**
         * The ID of the project.
         */
        fun projectId(projectId: String): FluentBuilder
        /**
         * The date the project was last updated, in Unix epoch time.
         */
        fun projectLastUpdateDate(projectLastUpdateDate: Instant): FluentBuilder
        /**
         * The name of the project.
         */
        fun projectName(projectName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the portal that the project is in.
         */
        var portalId: String?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the project, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}
         */
        var projectArn: String?
        /**
         * The date the project was created, in Unix epoch time.
         */
        var projectCreationDate: Instant?
        /**
         * The project's description.
         */
        var projectDescription: String?
        /**
         * The ID of the project.
         */
        var projectId: String?
        /**
         * The date the project was last updated, in Unix epoch time.
         */
        var projectLastUpdateDate: Instant?
        /**
         * The name of the project.
         */
        var projectName: String?

        fun build(): DescribeProjectResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var portalId: String? = null
        override var projectArn: String? = null
        override var projectCreationDate: Instant? = null
        override var projectDescription: String? = null
        override var projectId: String? = null
        override var projectLastUpdateDate: Instant? = null
        override var projectName: String? = null

        constructor(x: DescribeProjectResponse) : this() {
            this.portalId = x.portalId
            this.projectArn = x.projectArn
            this.projectCreationDate = x.projectCreationDate
            this.projectDescription = x.projectDescription
            this.projectId = x.projectId
            this.projectLastUpdateDate = x.projectLastUpdateDate
            this.projectName = x.projectName
        }

        override fun build(): DescribeProjectResponse = DescribeProjectResponse(this)
        override fun portalId(portalId: String): FluentBuilder = apply { this.portalId = portalId }
        override fun projectArn(projectArn: String): FluentBuilder = apply { this.projectArn = projectArn }
        override fun projectCreationDate(projectCreationDate: Instant): FluentBuilder = apply { this.projectCreationDate = projectCreationDate }
        override fun projectDescription(projectDescription: String): FluentBuilder = apply { this.projectDescription = projectDescription }
        override fun projectId(projectId: String): FluentBuilder = apply { this.projectId = projectId }
        override fun projectLastUpdateDate(projectLastUpdateDate: Instant): FluentBuilder = apply { this.projectLastUpdateDate = projectLastUpdateDate }
        override fun projectName(projectName: String): FluentBuilder = apply { this.projectName = projectName }
    }
}
