// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribePortalResponse private constructor(builder: BuilderImpl) {
    /**
     * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
     */
    val alarms: Alarms? = builder.alarms
    /**
     * The email address that sends alarm notifications.
     */
    val notificationSenderEmail: String? = builder.notificationSenderEmail
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the portal, which has the following format.
     * arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}
     */
    val portalArn: String? = builder.portalArn
    /**
     * The service to use to authenticate users to the portal.
     */
    val portalAuthMode: AuthMode? = builder.portalAuthMode
    /**
     * The Amazon Web Services SSO application generated client ID (used with Amazon Web Services SSO APIs). IoT SiteWise includes
     * portalClientId for only portals that use Amazon Web Services SSO to authenticate users.
     */
    val portalClientId: String? = builder.portalClientId
    /**
     * The Amazon Web Services administrator's contact email address.
     */
    val portalContactEmail: String? = builder.portalContactEmail
    /**
     * The date the portal was created, in Unix epoch time.
     */
    val portalCreationDate: Instant? = builder.portalCreationDate
    /**
     * The portal's description.
     */
    val portalDescription: String? = builder.portalDescription
    /**
     * The ID of the portal.
     */
    val portalId: String? = builder.portalId
    /**
     * The date the portal was last updated, in Unix epoch time.
     */
    val portalLastUpdateDate: Instant? = builder.portalLastUpdateDate
    /**
     * The portal's logo image, which is available at a URL.
     */
    val portalLogoImageLocation: ImageLocation? = builder.portalLogoImageLocation
    /**
     * The name of the portal.
     */
    val portalName: String? = builder.portalName
    /**
     * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that
     * use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the
     * IoT SiteWise console to get a URL that you can use to access the portal.
     */
    val portalStartUrl: String? = builder.portalStartUrl
    /**
     * The current status of the portal, which contains a state and any error message.
     */
    val portalStatus: PortalStatus? = builder.portalStatus
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the service role that allows the portal's users to access your IoT SiteWise
     * resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor in the
     * IoT SiteWise User Guide.
     */
    val roleArn: String? = builder.roleArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribePortalResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribePortalResponse(")
        append("alarms=$alarms,")
        append("notificationSenderEmail=$notificationSenderEmail,")
        append("portalArn=$portalArn,")
        append("portalAuthMode=$portalAuthMode,")
        append("portalClientId=$portalClientId,")
        append("portalContactEmail=$portalContactEmail,")
        append("portalCreationDate=$portalCreationDate,")
        append("portalDescription=$portalDescription,")
        append("portalId=$portalId,")
        append("portalLastUpdateDate=$portalLastUpdateDate,")
        append("portalLogoImageLocation=$portalLogoImageLocation,")
        append("portalName=$portalName,")
        append("portalStartUrl=$portalStartUrl,")
        append("portalStatus=$portalStatus,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarms?.hashCode() ?: 0
        result = 31 * result + (notificationSenderEmail?.hashCode() ?: 0)
        result = 31 * result + (portalArn?.hashCode() ?: 0)
        result = 31 * result + (portalAuthMode?.hashCode() ?: 0)
        result = 31 * result + (portalClientId?.hashCode() ?: 0)
        result = 31 * result + (portalContactEmail?.hashCode() ?: 0)
        result = 31 * result + (portalCreationDate?.hashCode() ?: 0)
        result = 31 * result + (portalDescription?.hashCode() ?: 0)
        result = 31 * result + (portalId?.hashCode() ?: 0)
        result = 31 * result + (portalLastUpdateDate?.hashCode() ?: 0)
        result = 31 * result + (portalLogoImageLocation?.hashCode() ?: 0)
        result = 31 * result + (portalName?.hashCode() ?: 0)
        result = 31 * result + (portalStartUrl?.hashCode() ?: 0)
        result = 31 * result + (portalStatus?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribePortalResponse

        if (alarms != other.alarms) return false
        if (notificationSenderEmail != other.notificationSenderEmail) return false
        if (portalArn != other.portalArn) return false
        if (portalAuthMode != other.portalAuthMode) return false
        if (portalClientId != other.portalClientId) return false
        if (portalContactEmail != other.portalContactEmail) return false
        if (portalCreationDate != other.portalCreationDate) return false
        if (portalDescription != other.portalDescription) return false
        if (portalId != other.portalId) return false
        if (portalLastUpdateDate != other.portalLastUpdateDate) return false
        if (portalLogoImageLocation != other.portalLogoImageLocation) return false
        if (portalName != other.portalName) return false
        if (portalStartUrl != other.portalStartUrl) return false
        if (portalStatus != other.portalStatus) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribePortalResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribePortalResponse
        /**
         * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
         */
        fun alarms(alarms: Alarms): FluentBuilder
        /**
         * The email address that sends alarm notifications.
         */
        fun notificationSenderEmail(notificationSenderEmail: String): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the portal, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}
         */
        fun portalArn(portalArn: String): FluentBuilder
        /**
         * The service to use to authenticate users to the portal.
         */
        fun portalAuthMode(portalAuthMode: AuthMode): FluentBuilder
        /**
         * The Amazon Web Services SSO application generated client ID (used with Amazon Web Services SSO APIs). IoT SiteWise includes
         * portalClientId for only portals that use Amazon Web Services SSO to authenticate users.
         */
        fun portalClientId(portalClientId: String): FluentBuilder
        /**
         * The Amazon Web Services administrator's contact email address.
         */
        fun portalContactEmail(portalContactEmail: String): FluentBuilder
        /**
         * The date the portal was created, in Unix epoch time.
         */
        fun portalCreationDate(portalCreationDate: Instant): FluentBuilder
        /**
         * The portal's description.
         */
        fun portalDescription(portalDescription: String): FluentBuilder
        /**
         * The ID of the portal.
         */
        fun portalId(portalId: String): FluentBuilder
        /**
         * The date the portal was last updated, in Unix epoch time.
         */
        fun portalLastUpdateDate(portalLastUpdateDate: Instant): FluentBuilder
        /**
         * The portal's logo image, which is available at a URL.
         */
        fun portalLogoImageLocation(portalLogoImageLocation: ImageLocation): FluentBuilder
        /**
         * The name of the portal.
         */
        fun portalName(portalName: String): FluentBuilder
        /**
         * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that
         * use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the
         * IoT SiteWise console to get a URL that you can use to access the portal.
         */
        fun portalStartUrl(portalStartUrl: String): FluentBuilder
        /**
         * The current status of the portal, which contains a state and any error message.
         */
        fun portalStatus(portalStatus: PortalStatus): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the service role that allows the portal's users to access your IoT SiteWise
         * resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor in the
         * IoT SiteWise User Guide.
         */
        fun roleArn(roleArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
         */
        var alarms: Alarms?
        /**
         * The email address that sends alarm notifications.
         */
        var notificationSenderEmail: String?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the portal, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}
         */
        var portalArn: String?
        /**
         * The service to use to authenticate users to the portal.
         */
        var portalAuthMode: AuthMode?
        /**
         * The Amazon Web Services SSO application generated client ID (used with Amazon Web Services SSO APIs). IoT SiteWise includes
         * portalClientId for only portals that use Amazon Web Services SSO to authenticate users.
         */
        var portalClientId: String?
        /**
         * The Amazon Web Services administrator's contact email address.
         */
        var portalContactEmail: String?
        /**
         * The date the portal was created, in Unix epoch time.
         */
        var portalCreationDate: Instant?
        /**
         * The portal's description.
         */
        var portalDescription: String?
        /**
         * The ID of the portal.
         */
        var portalId: String?
        /**
         * The date the portal was last updated, in Unix epoch time.
         */
        var portalLastUpdateDate: Instant?
        /**
         * The portal's logo image, which is available at a URL.
         */
        var portalLogoImageLocation: ImageLocation?
        /**
         * The name of the portal.
         */
        var portalName: String?
        /**
         * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that
         * use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the
         * IoT SiteWise console to get a URL that you can use to access the portal.
         */
        var portalStartUrl: String?
        /**
         * The current status of the portal, which contains a state and any error message.
         */
        var portalStatus: PortalStatus?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the service role that allows the portal's users to access your IoT SiteWise
         * resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor in the
         * IoT SiteWise User Guide.
         */
        var roleArn: String?

        fun build(): DescribePortalResponse
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Alarms] inside the given [block]
         */
        fun alarms(block: Alarms.DslBuilder.() -> kotlin.Unit) {
            this.alarms = Alarms.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.ImageLocation] inside the given [block]
         */
        fun portalLogoImageLocation(block: ImageLocation.DslBuilder.() -> kotlin.Unit) {
            this.portalLogoImageLocation = ImageLocation.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.PortalStatus] inside the given [block]
         */
        fun portalStatus(block: PortalStatus.DslBuilder.() -> kotlin.Unit) {
            this.portalStatus = PortalStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var alarms: Alarms? = null
        override var notificationSenderEmail: String? = null
        override var portalArn: String? = null
        override var portalAuthMode: AuthMode? = null
        override var portalClientId: String? = null
        override var portalContactEmail: String? = null
        override var portalCreationDate: Instant? = null
        override var portalDescription: String? = null
        override var portalId: String? = null
        override var portalLastUpdateDate: Instant? = null
        override var portalLogoImageLocation: ImageLocation? = null
        override var portalName: String? = null
        override var portalStartUrl: String? = null
        override var portalStatus: PortalStatus? = null
        override var roleArn: String? = null

        constructor(x: DescribePortalResponse) : this() {
            this.alarms = x.alarms
            this.notificationSenderEmail = x.notificationSenderEmail
            this.portalArn = x.portalArn
            this.portalAuthMode = x.portalAuthMode
            this.portalClientId = x.portalClientId
            this.portalContactEmail = x.portalContactEmail
            this.portalCreationDate = x.portalCreationDate
            this.portalDescription = x.portalDescription
            this.portalId = x.portalId
            this.portalLastUpdateDate = x.portalLastUpdateDate
            this.portalLogoImageLocation = x.portalLogoImageLocation
            this.portalName = x.portalName
            this.portalStartUrl = x.portalStartUrl
            this.portalStatus = x.portalStatus
            this.roleArn = x.roleArn
        }

        override fun build(): DescribePortalResponse = DescribePortalResponse(this)
        override fun alarms(alarms: Alarms): FluentBuilder = apply { this.alarms = alarms }
        override fun notificationSenderEmail(notificationSenderEmail: String): FluentBuilder = apply { this.notificationSenderEmail = notificationSenderEmail }
        override fun portalArn(portalArn: String): FluentBuilder = apply { this.portalArn = portalArn }
        override fun portalAuthMode(portalAuthMode: AuthMode): FluentBuilder = apply { this.portalAuthMode = portalAuthMode }
        override fun portalClientId(portalClientId: String): FluentBuilder = apply { this.portalClientId = portalClientId }
        override fun portalContactEmail(portalContactEmail: String): FluentBuilder = apply { this.portalContactEmail = portalContactEmail }
        override fun portalCreationDate(portalCreationDate: Instant): FluentBuilder = apply { this.portalCreationDate = portalCreationDate }
        override fun portalDescription(portalDescription: String): FluentBuilder = apply { this.portalDescription = portalDescription }
        override fun portalId(portalId: String): FluentBuilder = apply { this.portalId = portalId }
        override fun portalLastUpdateDate(portalLastUpdateDate: Instant): FluentBuilder = apply { this.portalLastUpdateDate = portalLastUpdateDate }
        override fun portalLogoImageLocation(portalLogoImageLocation: ImageLocation): FluentBuilder = apply { this.portalLogoImageLocation = portalLogoImageLocation }
        override fun portalName(portalName: String): FluentBuilder = apply { this.portalName = portalName }
        override fun portalStartUrl(portalStartUrl: String): FluentBuilder = apply { this.portalStartUrl = portalStartUrl }
        override fun portalStatus(portalStatus: PortalStatus): FluentBuilder = apply { this.portalStatus = portalStatus }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
    }
}
