// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeGatewayResponse private constructor(builder: BuilderImpl) {
    /**
     * The date the gateway was created, in Unix epoch time.
     */
    val creationDate: Instant? = builder.creationDate
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the gateway, which has the following format.
     * arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * A list of gateway capability summaries that each contain a namespace and status. Each
     * gateway capability defines data sources for the gateway. To retrieve a capability
     * configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration.
     */
    val gatewayCapabilitySummaries: List<GatewayCapabilitySummary>? = builder.gatewayCapabilitySummaries
    /**
     * The ID of the gateway device.
     */
    val gatewayId: String? = builder.gatewayId
    /**
     * The name of the gateway.
     */
    val gatewayName: String? = builder.gatewayName
    /**
     * The gateway's platform.
     */
    val gatewayPlatform: GatewayPlatform? = builder.gatewayPlatform
    /**
     * The date the gateway was last updated, in Unix epoch time.
     */
    val lastUpdateDate: Instant? = builder.lastUpdateDate

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeGatewayResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeGatewayResponse(")
        append("creationDate=$creationDate,")
        append("gatewayArn=$gatewayArn,")
        append("gatewayCapabilitySummaries=$gatewayCapabilitySummaries,")
        append("gatewayId=$gatewayId,")
        append("gatewayName=$gatewayName,")
        append("gatewayPlatform=$gatewayPlatform,")
        append("lastUpdateDate=$lastUpdateDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate?.hashCode() ?: 0
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (gatewayCapabilitySummaries?.hashCode() ?: 0)
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        result = 31 * result + (gatewayName?.hashCode() ?: 0)
        result = 31 * result + (gatewayPlatform?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeGatewayResponse

        if (creationDate != other.creationDate) return false
        if (gatewayArn != other.gatewayArn) return false
        if (gatewayCapabilitySummaries != other.gatewayCapabilitySummaries) return false
        if (gatewayId != other.gatewayId) return false
        if (gatewayName != other.gatewayName) return false
        if (gatewayPlatform != other.gatewayPlatform) return false
        if (lastUpdateDate != other.lastUpdateDate) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeGatewayResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeGatewayResponse
        /**
         * The date the gateway was created, in Unix epoch time.
         */
        fun creationDate(creationDate: Instant): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the gateway, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * A list of gateway capability summaries that each contain a namespace and status. Each
         * gateway capability defines data sources for the gateway. To retrieve a capability
         * configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration.
         */
        fun gatewayCapabilitySummaries(gatewayCapabilitySummaries: List<GatewayCapabilitySummary>): FluentBuilder
        /**
         * The ID of the gateway device.
         */
        fun gatewayId(gatewayId: String): FluentBuilder
        /**
         * The name of the gateway.
         */
        fun gatewayName(gatewayName: String): FluentBuilder
        /**
         * The gateway's platform.
         */
        fun gatewayPlatform(gatewayPlatform: GatewayPlatform): FluentBuilder
        /**
         * The date the gateway was last updated, in Unix epoch time.
         */
        fun lastUpdateDate(lastUpdateDate: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date the gateway was created, in Unix epoch time.
         */
        var creationDate: Instant?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the gateway, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}
         */
        var gatewayArn: String?
        /**
         * A list of gateway capability summaries that each contain a namespace and status. Each
         * gateway capability defines data sources for the gateway. To retrieve a capability
         * configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration.
         */
        var gatewayCapabilitySummaries: List<GatewayCapabilitySummary>?
        /**
         * The ID of the gateway device.
         */
        var gatewayId: String?
        /**
         * The name of the gateway.
         */
        var gatewayName: String?
        /**
         * The gateway's platform.
         */
        var gatewayPlatform: GatewayPlatform?
        /**
         * The date the gateway was last updated, in Unix epoch time.
         */
        var lastUpdateDate: Instant?

        fun build(): DescribeGatewayResponse
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.GatewayPlatform] inside the given [block]
         */
        fun gatewayPlatform(block: GatewayPlatform.DslBuilder.() -> kotlin.Unit) {
            this.gatewayPlatform = GatewayPlatform.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationDate: Instant? = null
        override var gatewayArn: String? = null
        override var gatewayCapabilitySummaries: List<GatewayCapabilitySummary>? = null
        override var gatewayId: String? = null
        override var gatewayName: String? = null
        override var gatewayPlatform: GatewayPlatform? = null
        override var lastUpdateDate: Instant? = null

        constructor(x: DescribeGatewayResponse) : this() {
            this.creationDate = x.creationDate
            this.gatewayArn = x.gatewayArn
            this.gatewayCapabilitySummaries = x.gatewayCapabilitySummaries
            this.gatewayId = x.gatewayId
            this.gatewayName = x.gatewayName
            this.gatewayPlatform = x.gatewayPlatform
            this.lastUpdateDate = x.lastUpdateDate
        }

        override fun build(): DescribeGatewayResponse = DescribeGatewayResponse(this)
        override fun creationDate(creationDate: Instant): FluentBuilder = apply { this.creationDate = creationDate }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun gatewayCapabilitySummaries(gatewayCapabilitySummaries: List<GatewayCapabilitySummary>): FluentBuilder = apply { this.gatewayCapabilitySummaries = gatewayCapabilitySummaries }
        override fun gatewayId(gatewayId: String): FluentBuilder = apply { this.gatewayId = gatewayId }
        override fun gatewayName(gatewayName: String): FluentBuilder = apply { this.gatewayName = gatewayName }
        override fun gatewayPlatform(gatewayPlatform: GatewayPlatform): FluentBuilder = apply { this.gatewayPlatform = gatewayPlatform }
        override fun lastUpdateDate(lastUpdateDate: Instant): FluentBuilder = apply { this.lastUpdateDate = lastUpdateDate }
    }
}
