// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class DescribeGatewayCapabilityConfigurationResponse private constructor(builder: BuilderImpl) {
    /**
     * The JSON document that defines the gateway capability's configuration. For more
     * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI) in the IoT SiteWise User Guide.
     */
    val capabilityConfiguration: String? = builder.capabilityConfiguration
    /**
     * The namespace of the gateway capability.
     */
    val capabilityNamespace: String? = builder.capabilityNamespace
    /**
     * The synchronization status of the capability configuration. The sync status can be one of the following:
     * IN_SYNC – The gateway is running the capability configuration.
     * OUT_OF_SYNC – The gateway hasn't received the capability configuration.
     * SYNC_FAILED – The gateway rejected the capability configuration.
     */
    val capabilitySyncStatus: CapabilitySyncStatus? = builder.capabilitySyncStatus
    /**
     * The ID of the gateway that defines the capability configuration.
     */
    val gatewayId: String? = builder.gatewayId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeGatewayCapabilityConfigurationResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeGatewayCapabilityConfigurationResponse(")
        append("capabilityConfiguration=$capabilityConfiguration,")
        append("capabilityNamespace=$capabilityNamespace,")
        append("capabilitySyncStatus=$capabilitySyncStatus,")
        append("gatewayId=$gatewayId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilityConfiguration?.hashCode() ?: 0
        result = 31 * result + (capabilityNamespace?.hashCode() ?: 0)
        result = 31 * result + (capabilitySyncStatus?.hashCode() ?: 0)
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeGatewayCapabilityConfigurationResponse

        if (capabilityConfiguration != other.capabilityConfiguration) return false
        if (capabilityNamespace != other.capabilityNamespace) return false
        if (capabilitySyncStatus != other.capabilitySyncStatus) return false
        if (gatewayId != other.gatewayId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeGatewayCapabilityConfigurationResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeGatewayCapabilityConfigurationResponse
        /**
         * The JSON document that defines the gateway capability's configuration. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI) in the IoT SiteWise User Guide.
         */
        fun capabilityConfiguration(capabilityConfiguration: String): FluentBuilder
        /**
         * The namespace of the gateway capability.
         */
        fun capabilityNamespace(capabilityNamespace: String): FluentBuilder
        /**
         * The synchronization status of the capability configuration. The sync status can be one of the following:
         * IN_SYNC – The gateway is running the capability configuration.
         * OUT_OF_SYNC – The gateway hasn't received the capability configuration.
         * SYNC_FAILED – The gateway rejected the capability configuration.
         */
        fun capabilitySyncStatus(capabilitySyncStatus: CapabilitySyncStatus): FluentBuilder
        /**
         * The ID of the gateway that defines the capability configuration.
         */
        fun gatewayId(gatewayId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The JSON document that defines the gateway capability's configuration. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI) in the IoT SiteWise User Guide.
         */
        var capabilityConfiguration: String?
        /**
         * The namespace of the gateway capability.
         */
        var capabilityNamespace: String?
        /**
         * The synchronization status of the capability configuration. The sync status can be one of the following:
         * IN_SYNC – The gateway is running the capability configuration.
         * OUT_OF_SYNC – The gateway hasn't received the capability configuration.
         * SYNC_FAILED – The gateway rejected the capability configuration.
         */
        var capabilitySyncStatus: CapabilitySyncStatus?
        /**
         * The ID of the gateway that defines the capability configuration.
         */
        var gatewayId: String?

        fun build(): DescribeGatewayCapabilityConfigurationResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var capabilityConfiguration: String? = null
        override var capabilityNamespace: String? = null
        override var capabilitySyncStatus: CapabilitySyncStatus? = null
        override var gatewayId: String? = null

        constructor(x: DescribeGatewayCapabilityConfigurationResponse) : this() {
            this.capabilityConfiguration = x.capabilityConfiguration
            this.capabilityNamespace = x.capabilityNamespace
            this.capabilitySyncStatus = x.capabilitySyncStatus
            this.gatewayId = x.gatewayId
        }

        override fun build(): DescribeGatewayCapabilityConfigurationResponse = DescribeGatewayCapabilityConfigurationResponse(this)
        override fun capabilityConfiguration(capabilityConfiguration: String): FluentBuilder = apply { this.capabilityConfiguration = capabilityConfiguration }
        override fun capabilityNamespace(capabilityNamespace: String): FluentBuilder = apply { this.capabilityNamespace = capabilityNamespace }
        override fun capabilitySyncStatus(capabilitySyncStatus: CapabilitySyncStatus): FluentBuilder = apply { this.capabilitySyncStatus = capabilitySyncStatus }
        override fun gatewayId(gatewayId: String): FluentBuilder = apply { this.gatewayId = gatewayId }
    }
}
