// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeDashboardResponse private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the dashboard, which has the following format.
     * arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}
     */
    val dashboardArn: String? = builder.dashboardArn
    /**
     * The date the dashboard was created, in Unix epoch time.
     */
    val dashboardCreationDate: Instant? = builder.dashboardCreationDate
    /**
     * The dashboard's definition JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating
     * dashboards (CLI) in the IoT SiteWise User Guide.
     */
    val dashboardDefinition: String? = builder.dashboardDefinition
    /**
     * The dashboard's description.
     */
    val dashboardDescription: String? = builder.dashboardDescription
    /**
     * The ID of the dashboard.
     */
    val dashboardId: String? = builder.dashboardId
    /**
     * The date the dashboard was last updated, in Unix epoch time.
     */
    val dashboardLastUpdateDate: Instant? = builder.dashboardLastUpdateDate
    /**
     * The name of the dashboard.
     */
    val dashboardName: String? = builder.dashboardName
    /**
     * The ID of the project that the dashboard is in.
     */
    val projectId: String? = builder.projectId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeDashboardResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDashboardResponse(")
        append("dashboardArn=$dashboardArn,")
        append("dashboardCreationDate=$dashboardCreationDate,")
        append("dashboardDefinition=$dashboardDefinition,")
        append("dashboardDescription=$dashboardDescription,")
        append("dashboardId=$dashboardId,")
        append("dashboardLastUpdateDate=$dashboardLastUpdateDate,")
        append("dashboardName=$dashboardName,")
        append("projectId=$projectId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dashboardArn?.hashCode() ?: 0
        result = 31 * result + (dashboardCreationDate?.hashCode() ?: 0)
        result = 31 * result + (dashboardDefinition?.hashCode() ?: 0)
        result = 31 * result + (dashboardDescription?.hashCode() ?: 0)
        result = 31 * result + (dashboardId?.hashCode() ?: 0)
        result = 31 * result + (dashboardLastUpdateDate?.hashCode() ?: 0)
        result = 31 * result + (dashboardName?.hashCode() ?: 0)
        result = 31 * result + (projectId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeDashboardResponse

        if (dashboardArn != other.dashboardArn) return false
        if (dashboardCreationDate != other.dashboardCreationDate) return false
        if (dashboardDefinition != other.dashboardDefinition) return false
        if (dashboardDescription != other.dashboardDescription) return false
        if (dashboardId != other.dashboardId) return false
        if (dashboardLastUpdateDate != other.dashboardLastUpdateDate) return false
        if (dashboardName != other.dashboardName) return false
        if (projectId != other.projectId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeDashboardResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeDashboardResponse
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the dashboard, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}
         */
        fun dashboardArn(dashboardArn: String): FluentBuilder
        /**
         * The date the dashboard was created, in Unix epoch time.
         */
        fun dashboardCreationDate(dashboardCreationDate: Instant): FluentBuilder
        /**
         * The dashboard's definition JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating
         * dashboards (CLI) in the IoT SiteWise User Guide.
         */
        fun dashboardDefinition(dashboardDefinition: String): FluentBuilder
        /**
         * The dashboard's description.
         */
        fun dashboardDescription(dashboardDescription: String): FluentBuilder
        /**
         * The ID of the dashboard.
         */
        fun dashboardId(dashboardId: String): FluentBuilder
        /**
         * The date the dashboard was last updated, in Unix epoch time.
         */
        fun dashboardLastUpdateDate(dashboardLastUpdateDate: Instant): FluentBuilder
        /**
         * The name of the dashboard.
         */
        fun dashboardName(dashboardName: String): FluentBuilder
        /**
         * The ID of the project that the dashboard is in.
         */
        fun projectId(projectId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the dashboard, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}
         */
        var dashboardArn: String?
        /**
         * The date the dashboard was created, in Unix epoch time.
         */
        var dashboardCreationDate: Instant?
        /**
         * The dashboard's definition JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating
         * dashboards (CLI) in the IoT SiteWise User Guide.
         */
        var dashboardDefinition: String?
        /**
         * The dashboard's description.
         */
        var dashboardDescription: String?
        /**
         * The ID of the dashboard.
         */
        var dashboardId: String?
        /**
         * The date the dashboard was last updated, in Unix epoch time.
         */
        var dashboardLastUpdateDate: Instant?
        /**
         * The name of the dashboard.
         */
        var dashboardName: String?
        /**
         * The ID of the project that the dashboard is in.
         */
        var projectId: String?

        fun build(): DescribeDashboardResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dashboardArn: String? = null
        override var dashboardCreationDate: Instant? = null
        override var dashboardDefinition: String? = null
        override var dashboardDescription: String? = null
        override var dashboardId: String? = null
        override var dashboardLastUpdateDate: Instant? = null
        override var dashboardName: String? = null
        override var projectId: String? = null

        constructor(x: DescribeDashboardResponse) : this() {
            this.dashboardArn = x.dashboardArn
            this.dashboardCreationDate = x.dashboardCreationDate
            this.dashboardDefinition = x.dashboardDefinition
            this.dashboardDescription = x.dashboardDescription
            this.dashboardId = x.dashboardId
            this.dashboardLastUpdateDate = x.dashboardLastUpdateDate
            this.dashboardName = x.dashboardName
            this.projectId = x.projectId
        }

        override fun build(): DescribeDashboardResponse = DescribeDashboardResponse(this)
        override fun dashboardArn(dashboardArn: String): FluentBuilder = apply { this.dashboardArn = dashboardArn }
        override fun dashboardCreationDate(dashboardCreationDate: Instant): FluentBuilder = apply { this.dashboardCreationDate = dashboardCreationDate }
        override fun dashboardDefinition(dashboardDefinition: String): FluentBuilder = apply { this.dashboardDefinition = dashboardDefinition }
        override fun dashboardDescription(dashboardDescription: String): FluentBuilder = apply { this.dashboardDescription = dashboardDescription }
        override fun dashboardId(dashboardId: String): FluentBuilder = apply { this.dashboardId = dashboardId }
        override fun dashboardLastUpdateDate(dashboardLastUpdateDate: Instant): FluentBuilder = apply { this.dashboardLastUpdateDate = dashboardLastUpdateDate }
        override fun dashboardName(dashboardName: String): FluentBuilder = apply { this.dashboardName = dashboardName }
        override fun projectId(projectId: String): FluentBuilder = apply { this.projectId = projectId }
    }
}
