// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeAssetResponse private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the asset, which has the following format.
     * arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
     */
    val assetArn: String? = builder.assetArn
    /**
     * The composite models for the asset.
     */
    val assetCompositeModels: List<AssetCompositeModel>? = builder.assetCompositeModels
    /**
     * The date the asset was created, in Unix epoch time.
     */
    val assetCreationDate: Instant? = builder.assetCreationDate
    /**
     * A list of asset hierarchies that each contain a hierarchyId. A hierarchy specifies allowed parent/child asset relationships.
     */
    val assetHierarchies: List<AssetHierarchy>? = builder.assetHierarchies
    /**
     * The ID of the asset.
     */
    val assetId: String? = builder.assetId
    /**
     * The date the asset was last updated, in Unix epoch time.
     */
    val assetLastUpdateDate: Instant? = builder.assetLastUpdateDate
    /**
     * The ID of the asset model that was used to create the asset.
     */
    val assetModelId: String? = builder.assetModelId
    /**
     * The name of the asset.
     */
    val assetName: String? = builder.assetName
    /**
     * The list of asset properties for the asset.
     * This object doesn't include properties that you define in composite models. You can find
     * composite model properties in the assetCompositeModels object.
     */
    val assetProperties: List<AssetProperty>? = builder.assetProperties
    /**
     * The current status of the asset, which contains a state and any error message.
     */
    val assetStatus: AssetStatus? = builder.assetStatus

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeAssetResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeAssetResponse(")
        append("assetArn=$assetArn,")
        append("assetCompositeModels=$assetCompositeModels,")
        append("assetCreationDate=$assetCreationDate,")
        append("assetHierarchies=$assetHierarchies,")
        append("assetId=$assetId,")
        append("assetLastUpdateDate=$assetLastUpdateDate,")
        append("assetModelId=$assetModelId,")
        append("assetName=$assetName,")
        append("assetProperties=$assetProperties,")
        append("assetStatus=$assetStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetArn?.hashCode() ?: 0
        result = 31 * result + (assetCompositeModels?.hashCode() ?: 0)
        result = 31 * result + (assetCreationDate?.hashCode() ?: 0)
        result = 31 * result + (assetHierarchies?.hashCode() ?: 0)
        result = 31 * result + (assetId?.hashCode() ?: 0)
        result = 31 * result + (assetLastUpdateDate?.hashCode() ?: 0)
        result = 31 * result + (assetModelId?.hashCode() ?: 0)
        result = 31 * result + (assetName?.hashCode() ?: 0)
        result = 31 * result + (assetProperties?.hashCode() ?: 0)
        result = 31 * result + (assetStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeAssetResponse

        if (assetArn != other.assetArn) return false
        if (assetCompositeModels != other.assetCompositeModels) return false
        if (assetCreationDate != other.assetCreationDate) return false
        if (assetHierarchies != other.assetHierarchies) return false
        if (assetId != other.assetId) return false
        if (assetLastUpdateDate != other.assetLastUpdateDate) return false
        if (assetModelId != other.assetModelId) return false
        if (assetName != other.assetName) return false
        if (assetProperties != other.assetProperties) return false
        if (assetStatus != other.assetStatus) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeAssetResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeAssetResponse
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the asset, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
         */
        fun assetArn(assetArn: String): FluentBuilder
        /**
         * The composite models for the asset.
         */
        fun assetCompositeModels(assetCompositeModels: List<AssetCompositeModel>): FluentBuilder
        /**
         * The date the asset was created, in Unix epoch time.
         */
        fun assetCreationDate(assetCreationDate: Instant): FluentBuilder
        /**
         * A list of asset hierarchies that each contain a hierarchyId. A hierarchy specifies allowed parent/child asset relationships.
         */
        fun assetHierarchies(assetHierarchies: List<AssetHierarchy>): FluentBuilder
        /**
         * The ID of the asset.
         */
        fun assetId(assetId: String): FluentBuilder
        /**
         * The date the asset was last updated, in Unix epoch time.
         */
        fun assetLastUpdateDate(assetLastUpdateDate: Instant): FluentBuilder
        /**
         * The ID of the asset model that was used to create the asset.
         */
        fun assetModelId(assetModelId: String): FluentBuilder
        /**
         * The name of the asset.
         */
        fun assetName(assetName: String): FluentBuilder
        /**
         * The list of asset properties for the asset.
         * This object doesn't include properties that you define in composite models. You can find
         * composite model properties in the assetCompositeModels object.
         */
        fun assetProperties(assetProperties: List<AssetProperty>): FluentBuilder
        /**
         * The current status of the asset, which contains a state and any error message.
         */
        fun assetStatus(assetStatus: AssetStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the asset, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
         */
        var assetArn: String?
        /**
         * The composite models for the asset.
         */
        var assetCompositeModels: List<AssetCompositeModel>?
        /**
         * The date the asset was created, in Unix epoch time.
         */
        var assetCreationDate: Instant?
        /**
         * A list of asset hierarchies that each contain a hierarchyId. A hierarchy specifies allowed parent/child asset relationships.
         */
        var assetHierarchies: List<AssetHierarchy>?
        /**
         * The ID of the asset.
         */
        var assetId: String?
        /**
         * The date the asset was last updated, in Unix epoch time.
         */
        var assetLastUpdateDate: Instant?
        /**
         * The ID of the asset model that was used to create the asset.
         */
        var assetModelId: String?
        /**
         * The name of the asset.
         */
        var assetName: String?
        /**
         * The list of asset properties for the asset.
         * This object doesn't include properties that you define in composite models. You can find
         * composite model properties in the assetCompositeModels object.
         */
        var assetProperties: List<AssetProperty>?
        /**
         * The current status of the asset, which contains a state and any error message.
         */
        var assetStatus: AssetStatus?

        fun build(): DescribeAssetResponse
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.AssetStatus] inside the given [block]
         */
        fun assetStatus(block: AssetStatus.DslBuilder.() -> kotlin.Unit) {
            this.assetStatus = AssetStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assetArn: String? = null
        override var assetCompositeModels: List<AssetCompositeModel>? = null
        override var assetCreationDate: Instant? = null
        override var assetHierarchies: List<AssetHierarchy>? = null
        override var assetId: String? = null
        override var assetLastUpdateDate: Instant? = null
        override var assetModelId: String? = null
        override var assetName: String? = null
        override var assetProperties: List<AssetProperty>? = null
        override var assetStatus: AssetStatus? = null

        constructor(x: DescribeAssetResponse) : this() {
            this.assetArn = x.assetArn
            this.assetCompositeModels = x.assetCompositeModels
            this.assetCreationDate = x.assetCreationDate
            this.assetHierarchies = x.assetHierarchies
            this.assetId = x.assetId
            this.assetLastUpdateDate = x.assetLastUpdateDate
            this.assetModelId = x.assetModelId
            this.assetName = x.assetName
            this.assetProperties = x.assetProperties
            this.assetStatus = x.assetStatus
        }

        override fun build(): DescribeAssetResponse = DescribeAssetResponse(this)
        override fun assetArn(assetArn: String): FluentBuilder = apply { this.assetArn = assetArn }
        override fun assetCompositeModels(assetCompositeModels: List<AssetCompositeModel>): FluentBuilder = apply { this.assetCompositeModels = assetCompositeModels }
        override fun assetCreationDate(assetCreationDate: Instant): FluentBuilder = apply { this.assetCreationDate = assetCreationDate }
        override fun assetHierarchies(assetHierarchies: List<AssetHierarchy>): FluentBuilder = apply { this.assetHierarchies = assetHierarchies }
        override fun assetId(assetId: String): FluentBuilder = apply { this.assetId = assetId }
        override fun assetLastUpdateDate(assetLastUpdateDate: Instant): FluentBuilder = apply { this.assetLastUpdateDate = assetLastUpdateDate }
        override fun assetModelId(assetModelId: String): FluentBuilder = apply { this.assetModelId = assetModelId }
        override fun assetName(assetName: String): FluentBuilder = apply { this.assetName = assetName }
        override fun assetProperties(assetProperties: List<AssetProperty>): FluentBuilder = apply { this.assetProperties = assetProperties }
        override fun assetStatus(assetStatus: AssetStatus): FluentBuilder = apply { this.assetStatus = assetStatus }
    }
}
