// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeAssetModelResponse private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the asset model, which has the following format.
     * arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
     */
    val assetModelArn: String? = builder.assetModelArn
    /**
     * The list of composite asset models for the asset model.
     */
    val assetModelCompositeModels: List<AssetModelCompositeModel>? = builder.assetModelCompositeModels
    /**
     * The date the asset model was created, in Unix epoch time.
     */
    val assetModelCreationDate: Instant? = builder.assetModelCreationDate
    /**
     * The asset model's description.
     */
    val assetModelDescription: String? = builder.assetModelDescription
    /**
     * A list of asset model hierarchies that each contain a childAssetModelId and a
     * hierarchyId (named id). A hierarchy specifies allowed parent/child
     * asset relationships for an asset model.
     */
    val assetModelHierarchies: List<AssetModelHierarchy>? = builder.assetModelHierarchies
    /**
     * The ID of the asset model.
     */
    val assetModelId: String? = builder.assetModelId
    /**
     * The date the asset model was last updated, in Unix epoch time.
     */
    val assetModelLastUpdateDate: Instant? = builder.assetModelLastUpdateDate
    /**
     * The name of the asset model.
     */
    val assetModelName: String? = builder.assetModelName
    /**
     * The list of asset properties for the asset model.
     * This object doesn't include properties that you define in composite models. You can find
     * composite model properties in the assetModelCompositeModels object.
     */
    val assetModelProperties: List<AssetModelProperty>? = builder.assetModelProperties
    /**
     * The current status of the asset model, which contains a state and any error
     * message.
     */
    val assetModelStatus: AssetModelStatus? = builder.assetModelStatus

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeAssetModelResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeAssetModelResponse(")
        append("assetModelArn=$assetModelArn,")
        append("assetModelCompositeModels=$assetModelCompositeModels,")
        append("assetModelCreationDate=$assetModelCreationDate,")
        append("assetModelDescription=$assetModelDescription,")
        append("assetModelHierarchies=$assetModelHierarchies,")
        append("assetModelId=$assetModelId,")
        append("assetModelLastUpdateDate=$assetModelLastUpdateDate,")
        append("assetModelName=$assetModelName,")
        append("assetModelProperties=$assetModelProperties,")
        append("assetModelStatus=$assetModelStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetModelArn?.hashCode() ?: 0
        result = 31 * result + (assetModelCompositeModels?.hashCode() ?: 0)
        result = 31 * result + (assetModelCreationDate?.hashCode() ?: 0)
        result = 31 * result + (assetModelDescription?.hashCode() ?: 0)
        result = 31 * result + (assetModelHierarchies?.hashCode() ?: 0)
        result = 31 * result + (assetModelId?.hashCode() ?: 0)
        result = 31 * result + (assetModelLastUpdateDate?.hashCode() ?: 0)
        result = 31 * result + (assetModelName?.hashCode() ?: 0)
        result = 31 * result + (assetModelProperties?.hashCode() ?: 0)
        result = 31 * result + (assetModelStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeAssetModelResponse

        if (assetModelArn != other.assetModelArn) return false
        if (assetModelCompositeModels != other.assetModelCompositeModels) return false
        if (assetModelCreationDate != other.assetModelCreationDate) return false
        if (assetModelDescription != other.assetModelDescription) return false
        if (assetModelHierarchies != other.assetModelHierarchies) return false
        if (assetModelId != other.assetModelId) return false
        if (assetModelLastUpdateDate != other.assetModelLastUpdateDate) return false
        if (assetModelName != other.assetModelName) return false
        if (assetModelProperties != other.assetModelProperties) return false
        if (assetModelStatus != other.assetModelStatus) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeAssetModelResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeAssetModelResponse
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the asset model, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
         */
        fun assetModelArn(assetModelArn: String): FluentBuilder
        /**
         * The list of composite asset models for the asset model.
         */
        fun assetModelCompositeModels(assetModelCompositeModels: List<AssetModelCompositeModel>): FluentBuilder
        /**
         * The date the asset model was created, in Unix epoch time.
         */
        fun assetModelCreationDate(assetModelCreationDate: Instant): FluentBuilder
        /**
         * The asset model's description.
         */
        fun assetModelDescription(assetModelDescription: String): FluentBuilder
        /**
         * A list of asset model hierarchies that each contain a childAssetModelId and a
         * hierarchyId (named id). A hierarchy specifies allowed parent/child
         * asset relationships for an asset model.
         */
        fun assetModelHierarchies(assetModelHierarchies: List<AssetModelHierarchy>): FluentBuilder
        /**
         * The ID of the asset model.
         */
        fun assetModelId(assetModelId: String): FluentBuilder
        /**
         * The date the asset model was last updated, in Unix epoch time.
         */
        fun assetModelLastUpdateDate(assetModelLastUpdateDate: Instant): FluentBuilder
        /**
         * The name of the asset model.
         */
        fun assetModelName(assetModelName: String): FluentBuilder
        /**
         * The list of asset properties for the asset model.
         * This object doesn't include properties that you define in composite models. You can find
         * composite model properties in the assetModelCompositeModels object.
         */
        fun assetModelProperties(assetModelProperties: List<AssetModelProperty>): FluentBuilder
        /**
         * The current status of the asset model, which contains a state and any error
         * message.
         */
        fun assetModelStatus(assetModelStatus: AssetModelStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the asset model, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
         */
        var assetModelArn: String?
        /**
         * The list of composite asset models for the asset model.
         */
        var assetModelCompositeModels: List<AssetModelCompositeModel>?
        /**
         * The date the asset model was created, in Unix epoch time.
         */
        var assetModelCreationDate: Instant?
        /**
         * The asset model's description.
         */
        var assetModelDescription: String?
        /**
         * A list of asset model hierarchies that each contain a childAssetModelId and a
         * hierarchyId (named id). A hierarchy specifies allowed parent/child
         * asset relationships for an asset model.
         */
        var assetModelHierarchies: List<AssetModelHierarchy>?
        /**
         * The ID of the asset model.
         */
        var assetModelId: String?
        /**
         * The date the asset model was last updated, in Unix epoch time.
         */
        var assetModelLastUpdateDate: Instant?
        /**
         * The name of the asset model.
         */
        var assetModelName: String?
        /**
         * The list of asset properties for the asset model.
         * This object doesn't include properties that you define in composite models. You can find
         * composite model properties in the assetModelCompositeModels object.
         */
        var assetModelProperties: List<AssetModelProperty>?
        /**
         * The current status of the asset model, which contains a state and any error
         * message.
         */
        var assetModelStatus: AssetModelStatus?

        fun build(): DescribeAssetModelResponse
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus] inside the given [block]
         */
        fun assetModelStatus(block: AssetModelStatus.DslBuilder.() -> kotlin.Unit) {
            this.assetModelStatus = AssetModelStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assetModelArn: String? = null
        override var assetModelCompositeModels: List<AssetModelCompositeModel>? = null
        override var assetModelCreationDate: Instant? = null
        override var assetModelDescription: String? = null
        override var assetModelHierarchies: List<AssetModelHierarchy>? = null
        override var assetModelId: String? = null
        override var assetModelLastUpdateDate: Instant? = null
        override var assetModelName: String? = null
        override var assetModelProperties: List<AssetModelProperty>? = null
        override var assetModelStatus: AssetModelStatus? = null

        constructor(x: DescribeAssetModelResponse) : this() {
            this.assetModelArn = x.assetModelArn
            this.assetModelCompositeModels = x.assetModelCompositeModels
            this.assetModelCreationDate = x.assetModelCreationDate
            this.assetModelDescription = x.assetModelDescription
            this.assetModelHierarchies = x.assetModelHierarchies
            this.assetModelId = x.assetModelId
            this.assetModelLastUpdateDate = x.assetModelLastUpdateDate
            this.assetModelName = x.assetModelName
            this.assetModelProperties = x.assetModelProperties
            this.assetModelStatus = x.assetModelStatus
        }

        override fun build(): DescribeAssetModelResponse = DescribeAssetModelResponse(this)
        override fun assetModelArn(assetModelArn: String): FluentBuilder = apply { this.assetModelArn = assetModelArn }
        override fun assetModelCompositeModels(assetModelCompositeModels: List<AssetModelCompositeModel>): FluentBuilder = apply { this.assetModelCompositeModels = assetModelCompositeModels }
        override fun assetModelCreationDate(assetModelCreationDate: Instant): FluentBuilder = apply { this.assetModelCreationDate = assetModelCreationDate }
        override fun assetModelDescription(assetModelDescription: String): FluentBuilder = apply { this.assetModelDescription = assetModelDescription }
        override fun assetModelHierarchies(assetModelHierarchies: List<AssetModelHierarchy>): FluentBuilder = apply { this.assetModelHierarchies = assetModelHierarchies }
        override fun assetModelId(assetModelId: String): FluentBuilder = apply { this.assetModelId = assetModelId }
        override fun assetModelLastUpdateDate(assetModelLastUpdateDate: Instant): FluentBuilder = apply { this.assetModelLastUpdateDate = assetModelLastUpdateDate }
        override fun assetModelName(assetModelName: String): FluentBuilder = apply { this.assetModelName = assetModelName }
        override fun assetModelProperties(assetModelProperties: List<AssetModelProperty>): FluentBuilder = apply { this.assetModelProperties = assetModelProperties }
        override fun assetModelStatus(assetModelStatus: AssetModelStatus): FluentBuilder = apply { this.assetModelStatus = assetModelStatus }
    }
}
