// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeAccessPolicyResponse private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the access policy, which has the following format.
     * arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}
     */
    val accessPolicyArn: String? = builder.accessPolicyArn
    /**
     * The date the access policy was created, in Unix epoch time.
     */
    val accessPolicyCreationDate: Instant? = builder.accessPolicyCreationDate
    /**
     * The ID of the access policy.
     */
    val accessPolicyId: String? = builder.accessPolicyId
    /**
     * The identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user) to which this access policy
     * applies.
     */
    val accessPolicyIdentity: Identity? = builder.accessPolicyIdentity
    /**
     * The date the access policy was last updated, in Unix epoch time.
     */
    val accessPolicyLastUpdateDate: Instant? = builder.accessPolicyLastUpdateDate
    /**
     * The access policy permission. Note that a project ADMINISTRATOR is also known
     * as a project owner.
     */
    val accessPolicyPermission: Permission? = builder.accessPolicyPermission
    /**
     * The IoT SiteWise Monitor resource (portal or project) to which this access policy provides
     * access.
     */
    val accessPolicyResource: Resource? = builder.accessPolicyResource

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeAccessPolicyResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeAccessPolicyResponse(")
        append("accessPolicyArn=$accessPolicyArn,")
        append("accessPolicyCreationDate=$accessPolicyCreationDate,")
        append("accessPolicyId=$accessPolicyId,")
        append("accessPolicyIdentity=$accessPolicyIdentity,")
        append("accessPolicyLastUpdateDate=$accessPolicyLastUpdateDate,")
        append("accessPolicyPermission=$accessPolicyPermission,")
        append("accessPolicyResource=$accessPolicyResource)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPolicyArn?.hashCode() ?: 0
        result = 31 * result + (accessPolicyCreationDate?.hashCode() ?: 0)
        result = 31 * result + (accessPolicyId?.hashCode() ?: 0)
        result = 31 * result + (accessPolicyIdentity?.hashCode() ?: 0)
        result = 31 * result + (accessPolicyLastUpdateDate?.hashCode() ?: 0)
        result = 31 * result + (accessPolicyPermission?.hashCode() ?: 0)
        result = 31 * result + (accessPolicyResource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeAccessPolicyResponse

        if (accessPolicyArn != other.accessPolicyArn) return false
        if (accessPolicyCreationDate != other.accessPolicyCreationDate) return false
        if (accessPolicyId != other.accessPolicyId) return false
        if (accessPolicyIdentity != other.accessPolicyIdentity) return false
        if (accessPolicyLastUpdateDate != other.accessPolicyLastUpdateDate) return false
        if (accessPolicyPermission != other.accessPolicyPermission) return false
        if (accessPolicyResource != other.accessPolicyResource) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeAccessPolicyResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeAccessPolicyResponse
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the access policy, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}
         */
        fun accessPolicyArn(accessPolicyArn: String): FluentBuilder
        /**
         * The date the access policy was created, in Unix epoch time.
         */
        fun accessPolicyCreationDate(accessPolicyCreationDate: Instant): FluentBuilder
        /**
         * The ID of the access policy.
         */
        fun accessPolicyId(accessPolicyId: String): FluentBuilder
        /**
         * The identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user) to which this access policy
         * applies.
         */
        fun accessPolicyIdentity(accessPolicyIdentity: Identity): FluentBuilder
        /**
         * The date the access policy was last updated, in Unix epoch time.
         */
        fun accessPolicyLastUpdateDate(accessPolicyLastUpdateDate: Instant): FluentBuilder
        /**
         * The access policy permission. Note that a project ADMINISTRATOR is also known
         * as a project owner.
         */
        fun accessPolicyPermission(accessPolicyPermission: Permission): FluentBuilder
        /**
         * The IoT SiteWise Monitor resource (portal or project) to which this access policy provides
         * access.
         */
        fun accessPolicyResource(accessPolicyResource: Resource): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the access policy, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}
         */
        var accessPolicyArn: String?
        /**
         * The date the access policy was created, in Unix epoch time.
         */
        var accessPolicyCreationDate: Instant?
        /**
         * The ID of the access policy.
         */
        var accessPolicyId: String?
        /**
         * The identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user) to which this access policy
         * applies.
         */
        var accessPolicyIdentity: Identity?
        /**
         * The date the access policy was last updated, in Unix epoch time.
         */
        var accessPolicyLastUpdateDate: Instant?
        /**
         * The access policy permission. Note that a project ADMINISTRATOR is also known
         * as a project owner.
         */
        var accessPolicyPermission: Permission?
        /**
         * The IoT SiteWise Monitor resource (portal or project) to which this access policy provides
         * access.
         */
        var accessPolicyResource: Resource?

        fun build(): DescribeAccessPolicyResponse
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Identity] inside the given [block]
         */
        fun accessPolicyIdentity(block: Identity.DslBuilder.() -> kotlin.Unit) {
            this.accessPolicyIdentity = Identity.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Resource] inside the given [block]
         */
        fun accessPolicyResource(block: Resource.DslBuilder.() -> kotlin.Unit) {
            this.accessPolicyResource = Resource.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accessPolicyArn: String? = null
        override var accessPolicyCreationDate: Instant? = null
        override var accessPolicyId: String? = null
        override var accessPolicyIdentity: Identity? = null
        override var accessPolicyLastUpdateDate: Instant? = null
        override var accessPolicyPermission: Permission? = null
        override var accessPolicyResource: Resource? = null

        constructor(x: DescribeAccessPolicyResponse) : this() {
            this.accessPolicyArn = x.accessPolicyArn
            this.accessPolicyCreationDate = x.accessPolicyCreationDate
            this.accessPolicyId = x.accessPolicyId
            this.accessPolicyIdentity = x.accessPolicyIdentity
            this.accessPolicyLastUpdateDate = x.accessPolicyLastUpdateDate
            this.accessPolicyPermission = x.accessPolicyPermission
            this.accessPolicyResource = x.accessPolicyResource
        }

        override fun build(): DescribeAccessPolicyResponse = DescribeAccessPolicyResponse(this)
        override fun accessPolicyArn(accessPolicyArn: String): FluentBuilder = apply { this.accessPolicyArn = accessPolicyArn }
        override fun accessPolicyCreationDate(accessPolicyCreationDate: Instant): FluentBuilder = apply { this.accessPolicyCreationDate = accessPolicyCreationDate }
        override fun accessPolicyId(accessPolicyId: String): FluentBuilder = apply { this.accessPolicyId = accessPolicyId }
        override fun accessPolicyIdentity(accessPolicyIdentity: Identity): FluentBuilder = apply { this.accessPolicyIdentity = accessPolicyIdentity }
        override fun accessPolicyLastUpdateDate(accessPolicyLastUpdateDate: Instant): FluentBuilder = apply { this.accessPolicyLastUpdateDate = accessPolicyLastUpdateDate }
        override fun accessPolicyPermission(accessPolicyPermission: Permission): FluentBuilder = apply { this.accessPolicyPermission = accessPolicyPermission }
        override fun accessPolicyResource(accessPolicyResource: Resource): FluentBuilder = apply { this.accessPolicyResource = accessPolicyResource }
    }
}
