// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains information about a customer managed Amazon S3 bucket.
 */
class CustomerManagedS3Storage private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Identity and Access Management role that allows IoT SiteWise to send data to Amazon S3.
     */
    val roleArn: String? = builder.roleArn
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Amazon S3 object. For more information about how to find the ARN for an
     * Amazon S3 object, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html">Amazon S3 resources in the
     * Amazon Simple Storage Service User Guide.
     */
    val s3ResourceArn: String? = builder.s3ResourceArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CustomerManagedS3Storage = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CustomerManagedS3Storage(")
        append("roleArn=$roleArn,")
        append("s3ResourceArn=$s3ResourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn?.hashCode() ?: 0
        result = 31 * result + (s3ResourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CustomerManagedS3Storage

        if (roleArn != other.roleArn) return false
        if (s3ResourceArn != other.s3ResourceArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CustomerManagedS3Storage = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CustomerManagedS3Storage
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Identity and Access Management role that allows IoT SiteWise to send data to Amazon S3.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Amazon S3 object. For more information about how to find the ARN for an
         * Amazon S3 object, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html">Amazon S3 resources in the
         * Amazon Simple Storage Service User Guide.
         */
        fun s3ResourceArn(s3ResourceArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Identity and Access Management role that allows IoT SiteWise to send data to Amazon S3.
         */
        var roleArn: String?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Amazon S3 object. For more information about how to find the ARN for an
         * Amazon S3 object, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html">Amazon S3 resources in the
         * Amazon Simple Storage Service User Guide.
         */
        var s3ResourceArn: String?

        fun build(): CustomerManagedS3Storage
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var roleArn: String? = null
        override var s3ResourceArn: String? = null

        constructor(x: CustomerManagedS3Storage) : this() {
            this.roleArn = x.roleArn
            this.s3ResourceArn = x.s3ResourceArn
        }

        override fun build(): CustomerManagedS3Storage = CustomerManagedS3Storage(this)
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun s3ResourceArn(s3ResourceArn: String): FluentBuilder = apply { this.s3ResourceArn = s3ResourceArn }
    }
}
