// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class CreateProjectRequest private constructor(builder: BuilderImpl) {
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The ID of the portal in which to create the project.
     */
    val portalId: String? = builder.portalId
    /**
     * A description for the project.
     */
    val projectDescription: String? = builder.projectDescription
    /**
     * A friendly name for the project.
     */
    val projectName: String? = builder.projectName
    /**
     * A list of key-value pairs that contain metadata for the project. For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
     * resources in the IoT SiteWise User Guide.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateProjectRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProjectRequest(")
        append("clientToken=$clientToken,")
        append("portalId=$portalId,")
        append("projectDescription=$projectDescription,")
        append("projectName=$projectName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (portalId?.hashCode() ?: 0)
        result = 31 * result + (projectDescription?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateProjectRequest

        if (clientToken != other.clientToken) return false
        if (portalId != other.portalId) return false
        if (projectDescription != other.projectDescription) return false
        if (projectName != other.projectName) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateProjectRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateProjectRequest
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The ID of the portal in which to create the project.
         */
        fun portalId(portalId: String): FluentBuilder
        /**
         * A description for the project.
         */
        fun projectDescription(projectDescription: String): FluentBuilder
        /**
         * A friendly name for the project.
         */
        fun projectName(projectName: String): FluentBuilder
        /**
         * A list of key-value pairs that contain metadata for the project. For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources in the IoT SiteWise User Guide.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        var clientToken: String?
        /**
         * The ID of the portal in which to create the project.
         */
        var portalId: String?
        /**
         * A description for the project.
         */
        var projectDescription: String?
        /**
         * A friendly name for the project.
         */
        var projectName: String?
        /**
         * A list of key-value pairs that contain metadata for the project. For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources in the IoT SiteWise User Guide.
         */
        var tags: Map<String, String>?

        fun build(): CreateProjectRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var portalId: String? = null
        override var projectDescription: String? = null
        override var projectName: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateProjectRequest) : this() {
            this.clientToken = x.clientToken
            this.portalId = x.portalId
            this.projectDescription = x.projectDescription
            this.projectName = x.projectName
            this.tags = x.tags
        }

        override fun build(): CreateProjectRequest = CreateProjectRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun portalId(portalId: String): FluentBuilder = apply { this.portalId = portalId }
        override fun projectDescription(projectDescription: String): FluentBuilder = apply { this.projectDescription = projectDescription }
        override fun projectName(projectName: String): FluentBuilder = apply { this.projectName = projectName }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
