// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class CreatePortalResponse private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the portal, which has the following format.
     * arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}
     */
    val portalArn: String? = builder.portalArn
    /**
     * The ID of the created portal.
     */
    val portalId: String? = builder.portalId
    /**
     * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that
     * use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the
     * IoT SiteWise console to get a URL that you can use to access the portal.
     */
    val portalStartUrl: String? = builder.portalStartUrl
    /**
     * The status of the portal, which contains a state (CREATING after successfully
     * calling this operation) and any error message.
     */
    val portalStatus: PortalStatus? = builder.portalStatus
    /**
     * The associated Amazon Web Services SSO application ID, if the portal uses Amazon Web Services SSO.
     */
    val ssoApplicationId: String? = builder.ssoApplicationId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreatePortalResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePortalResponse(")
        append("portalArn=$portalArn,")
        append("portalId=$portalId,")
        append("portalStartUrl=$portalStartUrl,")
        append("portalStatus=$portalStatus,")
        append("ssoApplicationId=$ssoApplicationId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = portalArn?.hashCode() ?: 0
        result = 31 * result + (portalId?.hashCode() ?: 0)
        result = 31 * result + (portalStartUrl?.hashCode() ?: 0)
        result = 31 * result + (portalStatus?.hashCode() ?: 0)
        result = 31 * result + (ssoApplicationId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreatePortalResponse

        if (portalArn != other.portalArn) return false
        if (portalId != other.portalId) return false
        if (portalStartUrl != other.portalStartUrl) return false
        if (portalStatus != other.portalStatus) return false
        if (ssoApplicationId != other.ssoApplicationId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreatePortalResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreatePortalResponse
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the portal, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}
         */
        fun portalArn(portalArn: String): FluentBuilder
        /**
         * The ID of the created portal.
         */
        fun portalId(portalId: String): FluentBuilder
        /**
         * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that
         * use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the
         * IoT SiteWise console to get a URL that you can use to access the portal.
         */
        fun portalStartUrl(portalStartUrl: String): FluentBuilder
        /**
         * The status of the portal, which contains a state (CREATING after successfully
         * calling this operation) and any error message.
         */
        fun portalStatus(portalStatus: PortalStatus): FluentBuilder
        /**
         * The associated Amazon Web Services SSO application ID, if the portal uses Amazon Web Services SSO.
         */
        fun ssoApplicationId(ssoApplicationId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the portal, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}
         */
        var portalArn: String?
        /**
         * The ID of the created portal.
         */
        var portalId: String?
        /**
         * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that
         * use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the
         * IoT SiteWise console to get a URL that you can use to access the portal.
         */
        var portalStartUrl: String?
        /**
         * The status of the portal, which contains a state (CREATING after successfully
         * calling this operation) and any error message.
         */
        var portalStatus: PortalStatus?
        /**
         * The associated Amazon Web Services SSO application ID, if the portal uses Amazon Web Services SSO.
         */
        var ssoApplicationId: String?

        fun build(): CreatePortalResponse
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.PortalStatus] inside the given [block]
         */
        fun portalStatus(block: PortalStatus.DslBuilder.() -> kotlin.Unit) {
            this.portalStatus = PortalStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var portalArn: String? = null
        override var portalId: String? = null
        override var portalStartUrl: String? = null
        override var portalStatus: PortalStatus? = null
        override var ssoApplicationId: String? = null

        constructor(x: CreatePortalResponse) : this() {
            this.portalArn = x.portalArn
            this.portalId = x.portalId
            this.portalStartUrl = x.portalStartUrl
            this.portalStatus = x.portalStatus
            this.ssoApplicationId = x.ssoApplicationId
        }

        override fun build(): CreatePortalResponse = CreatePortalResponse(this)
        override fun portalArn(portalArn: String): FluentBuilder = apply { this.portalArn = portalArn }
        override fun portalId(portalId: String): FluentBuilder = apply { this.portalId = portalId }
        override fun portalStartUrl(portalStartUrl: String): FluentBuilder = apply { this.portalStartUrl = portalStartUrl }
        override fun portalStatus(portalStatus: PortalStatus): FluentBuilder = apply { this.portalStatus = portalStatus }
        override fun ssoApplicationId(ssoApplicationId: String): FluentBuilder = apply { this.ssoApplicationId = ssoApplicationId }
    }
}
