// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class CreatePortalRequest private constructor(builder: BuilderImpl) {
    /**
     * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
     * You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms in the IoT SiteWise Application Guide.
     */
    val alarms: Alarms? = builder.alarms
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The email address that sends alarm notifications.
     * If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events managed Lambda
     * function to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email
     * address in Amazon SES.
     */
    val notificationSenderEmail: String? = builder.notificationSenderEmail
    /**
     * The service to use to authenticate users to the portal. Choose from the following
     * options:
     * SSO – The portal uses Amazon Web Services Single Sign On to authenticate users and manage
     * user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web Services SSO.
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling Amazon Web Services SSO in the
     * IoT SiteWise User Guide. This option is only available in Amazon Web Services Regions other than
     * the China Regions.
     * IAM – The portal uses Identity and Access Management to authenticate users and manage
     * user permissions. This option is only available in the China Regions.
     * You can't change this value after you create a portal.
     * Default: SSO
     */
    val portalAuthMode: AuthMode? = builder.portalAuthMode
    /**
     * The Amazon Web Services administrator's contact email address.
     */
    val portalContactEmail: String? = builder.portalContactEmail
    /**
     * A description for the portal.
     */
    val portalDescription: String? = builder.portalDescription
    /**
     * A logo image to display in the portal. Upload a square, high-resolution image. The
     * image is displayed on a dark background.
     */
    val portalLogoImageFile: ImageFile? = builder.portalLogoImageFile
    /**
     * A friendly name for the portal.
     */
    val portalName: String? = builder.portalName
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of a service role that allows the portal's users to access your IoT SiteWise
     * resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor in the
     * IoT SiteWise User Guide.
     */
    val roleArn: String? = builder.roleArn
    /**
     * A list of key-value pairs that contain metadata for the portal. For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
     * resources in the IoT SiteWise User Guide.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreatePortalRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePortalRequest(")
        append("alarms=$alarms,")
        append("clientToken=$clientToken,")
        append("notificationSenderEmail=$notificationSenderEmail,")
        append("portalAuthMode=$portalAuthMode,")
        append("portalContactEmail=$portalContactEmail,")
        append("portalDescription=$portalDescription,")
        append("portalLogoImageFile=$portalLogoImageFile,")
        append("portalName=$portalName,")
        append("roleArn=$roleArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarms?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (notificationSenderEmail?.hashCode() ?: 0)
        result = 31 * result + (portalAuthMode?.hashCode() ?: 0)
        result = 31 * result + (portalContactEmail?.hashCode() ?: 0)
        result = 31 * result + (portalDescription?.hashCode() ?: 0)
        result = 31 * result + (portalLogoImageFile?.hashCode() ?: 0)
        result = 31 * result + (portalName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreatePortalRequest

        if (alarms != other.alarms) return false
        if (clientToken != other.clientToken) return false
        if (notificationSenderEmail != other.notificationSenderEmail) return false
        if (portalAuthMode != other.portalAuthMode) return false
        if (portalContactEmail != other.portalContactEmail) return false
        if (portalDescription != other.portalDescription) return false
        if (portalLogoImageFile != other.portalLogoImageFile) return false
        if (portalName != other.portalName) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreatePortalRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreatePortalRequest
        /**
         * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
         * You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms in the IoT SiteWise Application Guide.
         */
        fun alarms(alarms: Alarms): FluentBuilder
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The email address that sends alarm notifications.
         * If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events managed Lambda
         * function to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email
         * address in Amazon SES.
         */
        fun notificationSenderEmail(notificationSenderEmail: String): FluentBuilder
        /**
         * The service to use to authenticate users to the portal. Choose from the following
         * options:
         * SSO – The portal uses Amazon Web Services Single Sign On to authenticate users and manage
         * user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web Services SSO.
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling Amazon Web Services SSO in the
         * IoT SiteWise User Guide. This option is only available in Amazon Web Services Regions other than
         * the China Regions.
         * IAM – The portal uses Identity and Access Management to authenticate users and manage
         * user permissions. This option is only available in the China Regions.
         * You can't change this value after you create a portal.
         * Default: SSO
         */
        fun portalAuthMode(portalAuthMode: AuthMode): FluentBuilder
        /**
         * The Amazon Web Services administrator's contact email address.
         */
        fun portalContactEmail(portalContactEmail: String): FluentBuilder
        /**
         * A description for the portal.
         */
        fun portalDescription(portalDescription: String): FluentBuilder
        /**
         * A logo image to display in the portal. Upload a square, high-resolution image. The
         * image is displayed on a dark background.
         */
        fun portalLogoImageFile(portalLogoImageFile: ImageFile): FluentBuilder
        /**
         * A friendly name for the portal.
         */
        fun portalName(portalName: String): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of a service role that allows the portal's users to access your IoT SiteWise
         * resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor in the
         * IoT SiteWise User Guide.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * A list of key-value pairs that contain metadata for the portal. For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources in the IoT SiteWise User Guide.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
         * You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms in the IoT SiteWise Application Guide.
         */
        var alarms: Alarms?
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        var clientToken: String?
        /**
         * The email address that sends alarm notifications.
         * If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events managed Lambda
         * function to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email
         * address in Amazon SES.
         */
        var notificationSenderEmail: String?
        /**
         * The service to use to authenticate users to the portal. Choose from the following
         * options:
         * SSO – The portal uses Amazon Web Services Single Sign On to authenticate users and manage
         * user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web Services SSO.
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling Amazon Web Services SSO in the
         * IoT SiteWise User Guide. This option is only available in Amazon Web Services Regions other than
         * the China Regions.
         * IAM – The portal uses Identity and Access Management to authenticate users and manage
         * user permissions. This option is only available in the China Regions.
         * You can't change this value after you create a portal.
         * Default: SSO
         */
        var portalAuthMode: AuthMode?
        /**
         * The Amazon Web Services administrator's contact email address.
         */
        var portalContactEmail: String?
        /**
         * A description for the portal.
         */
        var portalDescription: String?
        /**
         * A logo image to display in the portal. Upload a square, high-resolution image. The
         * image is displayed on a dark background.
         */
        var portalLogoImageFile: ImageFile?
        /**
         * A friendly name for the portal.
         */
        var portalName: String?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of a service role that allows the portal's users to access your IoT SiteWise
         * resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor in the
         * IoT SiteWise User Guide.
         */
        var roleArn: String?
        /**
         * A list of key-value pairs that contain metadata for the portal. For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources in the IoT SiteWise User Guide.
         */
        var tags: Map<String, String>?

        fun build(): CreatePortalRequest
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Alarms] inside the given [block]
         */
        fun alarms(block: Alarms.DslBuilder.() -> kotlin.Unit) {
            this.alarms = Alarms.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.ImageFile] inside the given [block]
         */
        fun portalLogoImageFile(block: ImageFile.DslBuilder.() -> kotlin.Unit) {
            this.portalLogoImageFile = ImageFile.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var alarms: Alarms? = null
        override var clientToken: String? = null
        override var notificationSenderEmail: String? = null
        override var portalAuthMode: AuthMode? = null
        override var portalContactEmail: String? = null
        override var portalDescription: String? = null
        override var portalLogoImageFile: ImageFile? = null
        override var portalName: String? = null
        override var roleArn: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreatePortalRequest) : this() {
            this.alarms = x.alarms
            this.clientToken = x.clientToken
            this.notificationSenderEmail = x.notificationSenderEmail
            this.portalAuthMode = x.portalAuthMode
            this.portalContactEmail = x.portalContactEmail
            this.portalDescription = x.portalDescription
            this.portalLogoImageFile = x.portalLogoImageFile
            this.portalName = x.portalName
            this.roleArn = x.roleArn
            this.tags = x.tags
        }

        override fun build(): CreatePortalRequest = CreatePortalRequest(this)
        override fun alarms(alarms: Alarms): FluentBuilder = apply { this.alarms = alarms }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun notificationSenderEmail(notificationSenderEmail: String): FluentBuilder = apply { this.notificationSenderEmail = notificationSenderEmail }
        override fun portalAuthMode(portalAuthMode: AuthMode): FluentBuilder = apply { this.portalAuthMode = portalAuthMode }
        override fun portalContactEmail(portalContactEmail: String): FluentBuilder = apply { this.portalContactEmail = portalContactEmail }
        override fun portalDescription(portalDescription: String): FluentBuilder = apply { this.portalDescription = portalDescription }
        override fun portalLogoImageFile(portalLogoImageFile: ImageFile): FluentBuilder = apply { this.portalLogoImageFile = portalLogoImageFile }
        override fun portalName(portalName: String): FluentBuilder = apply { this.portalName = portalName }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
