// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class CreateGatewayRequest private constructor(builder: BuilderImpl) {
    /**
     * A unique, friendly name for the gateway.
     */
    val gatewayName: String? = builder.gatewayName
    /**
     * The gateway's platform. You can only specify one platform in a gateway.
     */
    val gatewayPlatform: GatewayPlatform? = builder.gatewayPlatform
    /**
     * A list of key-value pairs that contain metadata for the gateway. For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
     * resources in the IoT SiteWise User Guide.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateGatewayRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGatewayRequest(")
        append("gatewayName=$gatewayName,")
        append("gatewayPlatform=$gatewayPlatform,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayName?.hashCode() ?: 0
        result = 31 * result + (gatewayPlatform?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateGatewayRequest

        if (gatewayName != other.gatewayName) return false
        if (gatewayPlatform != other.gatewayPlatform) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateGatewayRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateGatewayRequest
        /**
         * A unique, friendly name for the gateway.
         */
        fun gatewayName(gatewayName: String): FluentBuilder
        /**
         * The gateway's platform. You can only specify one platform in a gateway.
         */
        fun gatewayPlatform(gatewayPlatform: GatewayPlatform): FluentBuilder
        /**
         * A list of key-value pairs that contain metadata for the gateway. For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources in the IoT SiteWise User Guide.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique, friendly name for the gateway.
         */
        var gatewayName: String?
        /**
         * The gateway's platform. You can only specify one platform in a gateway.
         */
        var gatewayPlatform: GatewayPlatform?
        /**
         * A list of key-value pairs that contain metadata for the gateway. For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources in the IoT SiteWise User Guide.
         */
        var tags: Map<String, String>?

        fun build(): CreateGatewayRequest
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.GatewayPlatform] inside the given [block]
         */
        fun gatewayPlatform(block: GatewayPlatform.DslBuilder.() -> kotlin.Unit) {
            this.gatewayPlatform = GatewayPlatform.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var gatewayName: String? = null
        override var gatewayPlatform: GatewayPlatform? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateGatewayRequest) : this() {
            this.gatewayName = x.gatewayName
            this.gatewayPlatform = x.gatewayPlatform
            this.tags = x.tags
        }

        override fun build(): CreateGatewayRequest = CreateGatewayRequest(this)
        override fun gatewayName(gatewayName: String): FluentBuilder = apply { this.gatewayName = gatewayName }
        override fun gatewayPlatform(gatewayPlatform: GatewayPlatform): FluentBuilder = apply { this.gatewayPlatform = gatewayPlatform }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
