// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class CreateAssetRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the asset model from which to create the asset.
     */
    val assetModelId: String? = builder.assetModelId
    /**
     * A unique, friendly name for the asset.
     */
    val assetName: String? = builder.assetName
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    val clientToken: String? = builder.clientToken
    /**
     * A list of key-value pairs that contain metadata for the asset. For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
     * resources in the IoT SiteWise User Guide.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateAssetRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAssetRequest(")
        append("assetModelId=$assetModelId,")
        append("assetName=$assetName,")
        append("clientToken=$clientToken,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetModelId?.hashCode() ?: 0
        result = 31 * result + (assetName?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateAssetRequest

        if (assetModelId != other.assetModelId) return false
        if (assetName != other.assetName) return false
        if (clientToken != other.clientToken) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateAssetRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateAssetRequest
        /**
         * The ID of the asset model from which to create the asset.
         */
        fun assetModelId(assetModelId: String): FluentBuilder
        /**
         * A unique, friendly name for the asset.
         */
        fun assetName(assetName: String): FluentBuilder
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * A list of key-value pairs that contain metadata for the asset. For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources in the IoT SiteWise User Guide.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the asset model from which to create the asset.
         */
        var assetModelId: String?
        /**
         * A unique, friendly name for the asset.
         */
        var assetName: String?
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        var clientToken: String?
        /**
         * A list of key-value pairs that contain metadata for the asset. For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources in the IoT SiteWise User Guide.
         */
        var tags: Map<String, String>?

        fun build(): CreateAssetRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assetModelId: String? = null
        override var assetName: String? = null
        override var clientToken: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateAssetRequest) : this() {
            this.assetModelId = x.assetModelId
            this.assetName = x.assetName
            this.clientToken = x.clientToken
            this.tags = x.tags
        }

        override fun build(): CreateAssetRequest = CreateAssetRequest(this)
        override fun assetModelId(assetModelId: String): FluentBuilder = apply { this.assetModelId = assetModelId }
        override fun assetName(assetName: String): FluentBuilder = apply { this.assetName = assetName }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
