// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class CreateAssetModelRequest private constructor(builder: BuilderImpl) {
    /**
     * The composite asset models that are part of this asset model.
     * Composite asset models are asset models that contain specific properties. Each composite model
     * has a type that defines the properties that the composite model supports. Use composite asset
     * models to define alarms on this asset model.
     */
    val assetModelCompositeModels: List<AssetModelCompositeModelDefinition>? = builder.assetModelCompositeModels
    /**
     * A description for the asset model.
     */
    val assetModelDescription: String? = builder.assetModelDescription
    /**
     * The hierarchy definitions of the asset model. Each hierarchy specifies an asset model
     * whose assets can be children of any other assets created from this asset model. For more
     * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies in the IoT SiteWise User Guide.
     * You can specify up to 10 hierarchies per asset model. For more
     * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
     */
    val assetModelHierarchies: List<AssetModelHierarchyDefinition>? = builder.assetModelHierarchies
    /**
     * A unique, friendly name for the asset model.
     */
    val assetModelName: String? = builder.assetModelName
    /**
     * The property definitions of the asset model. For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties in the IoT SiteWise User Guide.
     * You can specify up to 200 properties per asset model. For more
     * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
     */
    val assetModelProperties: List<AssetModelPropertyDefinition>? = builder.assetModelProperties
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    val clientToken: String? = builder.clientToken
    /**
     * A list of key-value pairs that contain metadata for the asset model. For more information,
     * see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
     * resources in the IoT SiteWise User Guide.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateAssetModelRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAssetModelRequest(")
        append("assetModelCompositeModels=$assetModelCompositeModels,")
        append("assetModelDescription=$assetModelDescription,")
        append("assetModelHierarchies=$assetModelHierarchies,")
        append("assetModelName=$assetModelName,")
        append("assetModelProperties=$assetModelProperties,")
        append("clientToken=$clientToken,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetModelCompositeModels?.hashCode() ?: 0
        result = 31 * result + (assetModelDescription?.hashCode() ?: 0)
        result = 31 * result + (assetModelHierarchies?.hashCode() ?: 0)
        result = 31 * result + (assetModelName?.hashCode() ?: 0)
        result = 31 * result + (assetModelProperties?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateAssetModelRequest

        if (assetModelCompositeModels != other.assetModelCompositeModels) return false
        if (assetModelDescription != other.assetModelDescription) return false
        if (assetModelHierarchies != other.assetModelHierarchies) return false
        if (assetModelName != other.assetModelName) return false
        if (assetModelProperties != other.assetModelProperties) return false
        if (clientToken != other.clientToken) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateAssetModelRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateAssetModelRequest
        /**
         * The composite asset models that are part of this asset model.
         * Composite asset models are asset models that contain specific properties. Each composite model
         * has a type that defines the properties that the composite model supports. Use composite asset
         * models to define alarms on this asset model.
         */
        fun assetModelCompositeModels(assetModelCompositeModels: List<AssetModelCompositeModelDefinition>): FluentBuilder
        /**
         * A description for the asset model.
         */
        fun assetModelDescription(assetModelDescription: String): FluentBuilder
        /**
         * The hierarchy definitions of the asset model. Each hierarchy specifies an asset model
         * whose assets can be children of any other assets created from this asset model. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies in the IoT SiteWise User Guide.
         * You can specify up to 10 hierarchies per asset model. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
         */
        fun assetModelHierarchies(assetModelHierarchies: List<AssetModelHierarchyDefinition>): FluentBuilder
        /**
         * A unique, friendly name for the asset model.
         */
        fun assetModelName(assetModelName: String): FluentBuilder
        /**
         * The property definitions of the asset model. For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties in the IoT SiteWise User Guide.
         * You can specify up to 200 properties per asset model. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
         */
        fun assetModelProperties(assetModelProperties: List<AssetModelPropertyDefinition>): FluentBuilder
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * A list of key-value pairs that contain metadata for the asset model. For more information,
         * see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources in the IoT SiteWise User Guide.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The composite asset models that are part of this asset model.
         * Composite asset models are asset models that contain specific properties. Each composite model
         * has a type that defines the properties that the composite model supports. Use composite asset
         * models to define alarms on this asset model.
         */
        var assetModelCompositeModels: List<AssetModelCompositeModelDefinition>?
        /**
         * A description for the asset model.
         */
        var assetModelDescription: String?
        /**
         * The hierarchy definitions of the asset model. Each hierarchy specifies an asset model
         * whose assets can be children of any other assets created from this asset model. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies in the IoT SiteWise User Guide.
         * You can specify up to 10 hierarchies per asset model. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
         */
        var assetModelHierarchies: List<AssetModelHierarchyDefinition>?
        /**
         * A unique, friendly name for the asset model.
         */
        var assetModelName: String?
        /**
         * The property definitions of the asset model. For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties in the IoT SiteWise User Guide.
         * You can specify up to 200 properties per asset model. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
         */
        var assetModelProperties: List<AssetModelPropertyDefinition>?
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        var clientToken: String?
        /**
         * A list of key-value pairs that contain metadata for the asset model. For more information,
         * see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources in the IoT SiteWise User Guide.
         */
        var tags: Map<String, String>?

        fun build(): CreateAssetModelRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assetModelCompositeModels: List<AssetModelCompositeModelDefinition>? = null
        override var assetModelDescription: String? = null
        override var assetModelHierarchies: List<AssetModelHierarchyDefinition>? = null
        override var assetModelName: String? = null
        override var assetModelProperties: List<AssetModelPropertyDefinition>? = null
        override var clientToken: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateAssetModelRequest) : this() {
            this.assetModelCompositeModels = x.assetModelCompositeModels
            this.assetModelDescription = x.assetModelDescription
            this.assetModelHierarchies = x.assetModelHierarchies
            this.assetModelName = x.assetModelName
            this.assetModelProperties = x.assetModelProperties
            this.clientToken = x.clientToken
            this.tags = x.tags
        }

        override fun build(): CreateAssetModelRequest = CreateAssetModelRequest(this)
        override fun assetModelCompositeModels(assetModelCompositeModels: List<AssetModelCompositeModelDefinition>): FluentBuilder = apply { this.assetModelCompositeModels = assetModelCompositeModels }
        override fun assetModelDescription(assetModelDescription: String): FluentBuilder = apply { this.assetModelDescription = assetModelDescription }
        override fun assetModelHierarchies(assetModelHierarchies: List<AssetModelHierarchyDefinition>): FluentBuilder = apply { this.assetModelHierarchies = assetModelHierarchies }
        override fun assetModelName(assetModelName: String): FluentBuilder = apply { this.assetModelName = assetModelName }
        override fun assetModelProperties(assetModelProperties: List<AssetModelPropertyDefinition>): FluentBuilder = apply { this.assetModelProperties = assetModelProperties }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
