// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class CreateAccessPolicyRequest private constructor(builder: BuilderImpl) {
    /**
     * The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.
     */
    val accessPolicyIdentity: Identity? = builder.accessPolicyIdentity
    /**
     * The permission level for this access policy. Note that a project ADMINISTRATOR is also known as a project owner.
     */
    val accessPolicyPermission: Permission? = builder.accessPolicyPermission
    /**
     * The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
     */
    val accessPolicyResource: Resource? = builder.accessPolicyResource
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    val clientToken: String? = builder.clientToken
    /**
     * A list of key-value pairs that contain metadata for the access policy. For more
     * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your
     * IoT SiteWise resources in the IoT SiteWise User Guide.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateAccessPolicyRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccessPolicyRequest(")
        append("accessPolicyIdentity=$accessPolicyIdentity,")
        append("accessPolicyPermission=$accessPolicyPermission,")
        append("accessPolicyResource=$accessPolicyResource,")
        append("clientToken=$clientToken,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPolicyIdentity?.hashCode() ?: 0
        result = 31 * result + (accessPolicyPermission?.hashCode() ?: 0)
        result = 31 * result + (accessPolicyResource?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateAccessPolicyRequest

        if (accessPolicyIdentity != other.accessPolicyIdentity) return false
        if (accessPolicyPermission != other.accessPolicyPermission) return false
        if (accessPolicyResource != other.accessPolicyResource) return false
        if (clientToken != other.clientToken) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateAccessPolicyRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateAccessPolicyRequest
        /**
         * The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.
         */
        fun accessPolicyIdentity(accessPolicyIdentity: Identity): FluentBuilder
        /**
         * The permission level for this access policy. Note that a project ADMINISTRATOR is also known as a project owner.
         */
        fun accessPolicyPermission(accessPolicyPermission: Permission): FluentBuilder
        /**
         * The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
         */
        fun accessPolicyResource(accessPolicyResource: Resource): FluentBuilder
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * A list of key-value pairs that contain metadata for the access policy. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your
         * IoT SiteWise resources in the IoT SiteWise User Guide.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.
         */
        var accessPolicyIdentity: Identity?
        /**
         * The permission level for this access policy. Note that a project ADMINISTRATOR is also known as a project owner.
         */
        var accessPolicyPermission: Permission?
        /**
         * The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
         */
        var accessPolicyResource: Resource?
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        var clientToken: String?
        /**
         * A list of key-value pairs that contain metadata for the access policy. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your
         * IoT SiteWise resources in the IoT SiteWise User Guide.
         */
        var tags: Map<String, String>?

        fun build(): CreateAccessPolicyRequest
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Identity] inside the given [block]
         */
        fun accessPolicyIdentity(block: Identity.DslBuilder.() -> kotlin.Unit) {
            this.accessPolicyIdentity = Identity.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Resource] inside the given [block]
         */
        fun accessPolicyResource(block: Resource.DslBuilder.() -> kotlin.Unit) {
            this.accessPolicyResource = Resource.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accessPolicyIdentity: Identity? = null
        override var accessPolicyPermission: Permission? = null
        override var accessPolicyResource: Resource? = null
        override var clientToken: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateAccessPolicyRequest) : this() {
            this.accessPolicyIdentity = x.accessPolicyIdentity
            this.accessPolicyPermission = x.accessPolicyPermission
            this.accessPolicyResource = x.accessPolicyResource
            this.clientToken = x.clientToken
            this.tags = x.tags
        }

        override fun build(): CreateAccessPolicyRequest = CreateAccessPolicyRequest(this)
        override fun accessPolicyIdentity(accessPolicyIdentity: Identity): FluentBuilder = apply { this.accessPolicyIdentity = accessPolicyIdentity }
        override fun accessPolicyPermission(accessPolicyPermission: Permission): FluentBuilder = apply { this.accessPolicyPermission = accessPolicyPermission }
        override fun accessPolicyResource(accessPolicyResource: Resource): FluentBuilder = apply { this.accessPolicyResource = accessPolicyResource }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
