// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class AssociateAssetsRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the parent asset.
     */
    val assetId: String? = builder.assetId
    /**
     * The ID of the child asset to be associated.
     */
    val childAssetId: String? = builder.childAssetId
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
     * of assets to be formed that all come from the same asset model. For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies in the IoT SiteWise User Guide.
     */
    val hierarchyId: String? = builder.hierarchyId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssociateAssetsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateAssetsRequest(")
        append("assetId=$assetId,")
        append("childAssetId=$childAssetId,")
        append("clientToken=$clientToken,")
        append("hierarchyId=$hierarchyId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (childAssetId?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (hierarchyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssociateAssetsRequest

        if (assetId != other.assetId) return false
        if (childAssetId != other.childAssetId) return false
        if (clientToken != other.clientToken) return false
        if (hierarchyId != other.hierarchyId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssociateAssetsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssociateAssetsRequest
        /**
         * The ID of the parent asset.
         */
        fun assetId(assetId: String): FluentBuilder
        /**
         * The ID of the child asset to be associated.
         */
        fun childAssetId(childAssetId: String): FluentBuilder
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
         * of assets to be formed that all come from the same asset model. For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies in the IoT SiteWise User Guide.
         */
        fun hierarchyId(hierarchyId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the parent asset.
         */
        var assetId: String?
        /**
         * The ID of the child asset to be associated.
         */
        var childAssetId: String?
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        var clientToken: String?
        /**
         * The ID of a hierarchy in the parent asset's model. Hierarchies allow different groupings
         * of assets to be formed that all come from the same asset model. For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies in the IoT SiteWise User Guide.
         */
        var hierarchyId: String?

        fun build(): AssociateAssetsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assetId: String? = null
        override var childAssetId: String? = null
        override var clientToken: String? = null
        override var hierarchyId: String? = null

        constructor(x: AssociateAssetsRequest) : this() {
            this.assetId = x.assetId
            this.childAssetId = x.childAssetId
            this.clientToken = x.clientToken
            this.hierarchyId = x.hierarchyId
        }

        override fun build(): AssociateAssetsRequest = AssociateAssetsRequest(this)
        override fun assetId(assetId: String): FluentBuilder = apply { this.assetId = assetId }
        override fun childAssetId(childAssetId: String): FluentBuilder = apply { this.childAssetId = childAssetId }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun hierarchyId(hierarchyId: String): FluentBuilder = apply { this.hierarchyId = hierarchyId }
    }
}
