// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a summary of an asset.
 */
class AssetSummary private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the asset, which has the following format.
     * arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
     */
    val arn: String? = builder.arn
    /**
     * The ID of the asset model used to create this asset.
     */
    val assetModelId: String? = builder.assetModelId
    /**
     * The date the asset was created, in Unix epoch time.
     */
    val creationDate: Instant? = builder.creationDate
    /**
     * A list of asset hierarchies that each contain a hierarchyId. A hierarchy specifies allowed parent/child asset relationships.
     */
    val hierarchies: List<AssetHierarchy>? = builder.hierarchies
    /**
     * The ID of the asset.
     */
    val id: String? = builder.id
    /**
     * The date the asset was last updated, in Unix epoch time.
     */
    val lastUpdateDate: Instant? = builder.lastUpdateDate
    /**
     * The name of the asset.
     */
    val name: String? = builder.name
    /**
     * The current status of the asset.
     */
    val status: AssetStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssetSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssetSummary(")
        append("arn=$arn,")
        append("assetModelId=$assetModelId,")
        append("creationDate=$creationDate,")
        append("hierarchies=$hierarchies,")
        append("id=$id,")
        append("lastUpdateDate=$lastUpdateDate,")
        append("name=$name,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (assetModelId?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (hierarchies?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssetSummary

        if (arn != other.arn) return false
        if (assetModelId != other.assetModelId) return false
        if (creationDate != other.creationDate) return false
        if (hierarchies != other.hierarchies) return false
        if (id != other.id) return false
        if (lastUpdateDate != other.lastUpdateDate) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssetSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssetSummary
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the asset, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The ID of the asset model used to create this asset.
         */
        fun assetModelId(assetModelId: String): FluentBuilder
        /**
         * The date the asset was created, in Unix epoch time.
         */
        fun creationDate(creationDate: Instant): FluentBuilder
        /**
         * A list of asset hierarchies that each contain a hierarchyId. A hierarchy specifies allowed parent/child asset relationships.
         */
        fun hierarchies(hierarchies: List<AssetHierarchy>): FluentBuilder
        /**
         * The ID of the asset.
         */
        fun id(id: String): FluentBuilder
        /**
         * The date the asset was last updated, in Unix epoch time.
         */
        fun lastUpdateDate(lastUpdateDate: Instant): FluentBuilder
        /**
         * The name of the asset.
         */
        fun name(name: String): FluentBuilder
        /**
         * The current status of the asset.
         */
        fun status(status: AssetStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the asset, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
         */
        var arn: String?
        /**
         * The ID of the asset model used to create this asset.
         */
        var assetModelId: String?
        /**
         * The date the asset was created, in Unix epoch time.
         */
        var creationDate: Instant?
        /**
         * A list of asset hierarchies that each contain a hierarchyId. A hierarchy specifies allowed parent/child asset relationships.
         */
        var hierarchies: List<AssetHierarchy>?
        /**
         * The ID of the asset.
         */
        var id: String?
        /**
         * The date the asset was last updated, in Unix epoch time.
         */
        var lastUpdateDate: Instant?
        /**
         * The name of the asset.
         */
        var name: String?
        /**
         * The current status of the asset.
         */
        var status: AssetStatus?

        fun build(): AssetSummary
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.AssetStatus] inside the given [block]
         */
        fun status(block: AssetStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = AssetStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var assetModelId: String? = null
        override var creationDate: Instant? = null
        override var hierarchies: List<AssetHierarchy>? = null
        override var id: String? = null
        override var lastUpdateDate: Instant? = null
        override var name: String? = null
        override var status: AssetStatus? = null

        constructor(x: AssetSummary) : this() {
            this.arn = x.arn
            this.assetModelId = x.assetModelId
            this.creationDate = x.creationDate
            this.hierarchies = x.hierarchies
            this.id = x.id
            this.lastUpdateDate = x.lastUpdateDate
            this.name = x.name
            this.status = x.status
        }

        override fun build(): AssetSummary = AssetSummary(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun assetModelId(assetModelId: String): FluentBuilder = apply { this.assetModelId = assetModelId }
        override fun creationDate(creationDate: Instant): FluentBuilder = apply { this.creationDate = creationDate }
        override fun hierarchies(hierarchies: List<AssetHierarchy>): FluentBuilder = apply { this.hierarchies = hierarchies }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastUpdateDate(lastUpdateDate: Instant): FluentBuilder = apply { this.lastUpdateDate = lastUpdateDate }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun status(status: AssetStatus): FluentBuilder = apply { this.status = status }
    }
}
