// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains asset property information.
 */
class AssetProperty private constructor(builder: BuilderImpl) {
    /**
     * The alias that identifies the property, such as an OPC-UA server data stream path
     * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
     * IoT SiteWise User Guide.
     */
    val alias: String? = builder.alias
    /**
     * The data type of the asset property.
     */
    val dataType: PropertyDataType? = builder.dataType
    /**
     * The data type of the structure for this property. This parameter exists on properties that
     * have the STRUCT data type.
     */
    val dataTypeSpec: String? = builder.dataTypeSpec
    /**
     * The ID of the asset property.
     */
    val id: String? = builder.id
    /**
     * The name of the property.
     */
    val name: String? = builder.name
    /**
     * The asset property's notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     */
    val notification: PropertyNotification? = builder.notification
    /**
     * The unit (such as Newtons or RPM) of the asset property.
     */
    val unit: String? = builder.unit

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssetProperty = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssetProperty(")
        append("alias=$alias,")
        append("dataType=$dataType,")
        append("dataTypeSpec=$dataTypeSpec,")
        append("id=$id,")
        append("name=$name,")
        append("notification=$notification,")
        append("unit=$unit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (dataTypeSpec?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notification?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssetProperty

        if (alias != other.alias) return false
        if (dataType != other.dataType) return false
        if (dataTypeSpec != other.dataTypeSpec) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (notification != other.notification) return false
        if (unit != other.unit) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssetProperty = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssetProperty
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path
         * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
         * IoT SiteWise User Guide.
         */
        fun alias(alias: String): FluentBuilder
        /**
         * The data type of the asset property.
         */
        fun dataType(dataType: PropertyDataType): FluentBuilder
        /**
         * The data type of the structure for this property. This parameter exists on properties that
         * have the STRUCT data type.
         */
        fun dataTypeSpec(dataTypeSpec: String): FluentBuilder
        /**
         * The ID of the asset property.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name of the property.
         */
        fun name(name: String): FluentBuilder
        /**
         * The asset property's notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
         */
        fun notification(notification: PropertyNotification): FluentBuilder
        /**
         * The unit (such as Newtons or RPM) of the asset property.
         */
        fun unit(unit: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path
         * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
         * IoT SiteWise User Guide.
         */
        var alias: String?
        /**
         * The data type of the asset property.
         */
        var dataType: PropertyDataType?
        /**
         * The data type of the structure for this property. This parameter exists on properties that
         * have the STRUCT data type.
         */
        var dataTypeSpec: String?
        /**
         * The ID of the asset property.
         */
        var id: String?
        /**
         * The name of the property.
         */
        var name: String?
        /**
         * The asset property's notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
         */
        var notification: PropertyNotification?
        /**
         * The unit (such as Newtons or RPM) of the asset property.
         */
        var unit: String?

        fun build(): AssetProperty
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification] inside the given [block]
         */
        fun notification(block: PropertyNotification.DslBuilder.() -> kotlin.Unit) {
            this.notification = PropertyNotification.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var alias: String? = null
        override var dataType: PropertyDataType? = null
        override var dataTypeSpec: String? = null
        override var id: String? = null
        override var name: String? = null
        override var notification: PropertyNotification? = null
        override var unit: String? = null

        constructor(x: AssetProperty) : this() {
            this.alias = x.alias
            this.dataType = x.dataType
            this.dataTypeSpec = x.dataTypeSpec
            this.id = x.id
            this.name = x.name
            this.notification = x.notification
            this.unit = x.unit
        }

        override fun build(): AssetProperty = AssetProperty(this)
        override fun alias(alias: String): FluentBuilder = apply { this.alias = alias }
        override fun dataType(dataType: PropertyDataType): FluentBuilder = apply { this.dataType = dataType }
        override fun dataTypeSpec(dataTypeSpec: String): FluentBuilder = apply { this.dataTypeSpec = dataTypeSpec }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun notification(notification: PropertyNotification): FluentBuilder = apply { this.notification = notification }
        override fun unit(unit: String): FluentBuilder = apply { this.unit = unit }
    }
}
