// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a summary of an asset model.
 */
class AssetModelSummary private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the asset model, which has the following format.
     * arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
     */
    val arn: String? = builder.arn
    /**
     * The date the asset model was created, in Unix epoch time.
     */
    val creationDate: Instant? = builder.creationDate
    /**
     * The asset model description.
     */
    val description: String? = builder.description
    /**
     * The ID of the asset model (used with IoT SiteWise APIs).
     */
    val id: String? = builder.id
    /**
     * The date the asset model was last updated, in Unix epoch time.
     */
    val lastUpdateDate: Instant? = builder.lastUpdateDate
    /**
     * The name of the asset model.
     */
    val name: String? = builder.name
    /**
     * The current status of the asset model.
     */
    val status: AssetModelStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssetModelSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssetModelSummary(")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("id=$id,")
        append("lastUpdateDate=$lastUpdateDate,")
        append("name=$name,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssetModelSummary

        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdateDate != other.lastUpdateDate) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssetModelSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssetModelSummary
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the asset model, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date the asset model was created, in Unix epoch time.
         */
        fun creationDate(creationDate: Instant): FluentBuilder
        /**
         * The asset model description.
         */
        fun description(description: String): FluentBuilder
        /**
         * The ID of the asset model (used with IoT SiteWise APIs).
         */
        fun id(id: String): FluentBuilder
        /**
         * The date the asset model was last updated, in Unix epoch time.
         */
        fun lastUpdateDate(lastUpdateDate: Instant): FluentBuilder
        /**
         * The name of the asset model.
         */
        fun name(name: String): FluentBuilder
        /**
         * The current status of the asset model.
         */
        fun status(status: AssetModelStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the asset model, which has the following format.
         * arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
         */
        var arn: String?
        /**
         * The date the asset model was created, in Unix epoch time.
         */
        var creationDate: Instant?
        /**
         * The asset model description.
         */
        var description: String?
        /**
         * The ID of the asset model (used with IoT SiteWise APIs).
         */
        var id: String?
        /**
         * The date the asset model was last updated, in Unix epoch time.
         */
        var lastUpdateDate: Instant?
        /**
         * The name of the asset model.
         */
        var name: String?
        /**
         * The current status of the asset model.
         */
        var status: AssetModelStatus?

        fun build(): AssetModelSummary
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus] inside the given [block]
         */
        fun status(block: AssetModelStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = AssetModelStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var creationDate: Instant? = null
        override var description: String? = null
        override var id: String? = null
        override var lastUpdateDate: Instant? = null
        override var name: String? = null
        override var status: AssetModelStatus? = null

        constructor(x: AssetModelSummary) : this() {
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.description = x.description
            this.id = x.id
            this.lastUpdateDate = x.lastUpdateDate
            this.name = x.name
            this.status = x.status
        }

        override fun build(): AssetModelSummary = AssetModelSummary(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun creationDate(creationDate: Instant): FluentBuilder = apply { this.creationDate = creationDate }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastUpdateDate(lastUpdateDate: Instant): FluentBuilder = apply { this.lastUpdateDate = lastUpdateDate }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun status(status: AssetModelStatus): FluentBuilder = apply { this.status = status }
    }
}
