// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains information about an asset model property.
 */
class AssetModelProperty private constructor(builder: BuilderImpl) {
    /**
     * The data type of the asset model property.
     */
    val dataType: PropertyDataType? = builder.dataType
    /**
     * The data type of the structure for this property. This parameter exists on properties that
     * have the STRUCT data type.
     */
    val dataTypeSpec: String? = builder.dataTypeSpec
    /**
     * The ID of the asset model property.
     */
    val id: String? = builder.id
    /**
     * The name of the asset model property.
     */
    val name: String? = builder.name
    /**
     * The property type (see PropertyType).
     */
    val type: PropertyType? = builder.type
    /**
     * The unit of the asset model property, such as Newtons or
     * RPM.
     */
    val unit: String? = builder.unit

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssetModelProperty = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssetModelProperty(")
        append("dataType=$dataType,")
        append("dataTypeSpec=$dataTypeSpec,")
        append("id=$id,")
        append("name=$name,")
        append("type=$type,")
        append("unit=$unit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataType?.hashCode() ?: 0
        result = 31 * result + (dataTypeSpec?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssetModelProperty

        if (dataType != other.dataType) return false
        if (dataTypeSpec != other.dataTypeSpec) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (type != other.type) return false
        if (unit != other.unit) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssetModelProperty = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssetModelProperty
        /**
         * The data type of the asset model property.
         */
        fun dataType(dataType: PropertyDataType): FluentBuilder
        /**
         * The data type of the structure for this property. This parameter exists on properties that
         * have the STRUCT data type.
         */
        fun dataTypeSpec(dataTypeSpec: String): FluentBuilder
        /**
         * The ID of the asset model property.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name of the asset model property.
         */
        fun name(name: String): FluentBuilder
        /**
         * The property type (see PropertyType).
         */
        fun type(type: PropertyType): FluentBuilder
        /**
         * The unit of the asset model property, such as Newtons or
         * RPM.
         */
        fun unit(unit: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The data type of the asset model property.
         */
        var dataType: PropertyDataType?
        /**
         * The data type of the structure for this property. This parameter exists on properties that
         * have the STRUCT data type.
         */
        var dataTypeSpec: String?
        /**
         * The ID of the asset model property.
         */
        var id: String?
        /**
         * The name of the asset model property.
         */
        var name: String?
        /**
         * The property type (see PropertyType).
         */
        var type: PropertyType?
        /**
         * The unit of the asset model property, such as Newtons or
         * RPM.
         */
        var unit: String?

        fun build(): AssetModelProperty
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.PropertyType] inside the given [block]
         */
        fun type(block: PropertyType.DslBuilder.() -> kotlin.Unit) {
            this.type = PropertyType.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dataType: PropertyDataType? = null
        override var dataTypeSpec: String? = null
        override var id: String? = null
        override var name: String? = null
        override var type: PropertyType? = null
        override var unit: String? = null

        constructor(x: AssetModelProperty) : this() {
            this.dataType = x.dataType
            this.dataTypeSpec = x.dataTypeSpec
            this.id = x.id
            this.name = x.name
            this.type = x.type
            this.unit = x.unit
        }

        override fun build(): AssetModelProperty = AssetModelProperty(this)
        override fun dataType(dataType: PropertyDataType): FluentBuilder = apply { this.dataType = dataType }
        override fun dataTypeSpec(dataTypeSpec: String): FluentBuilder = apply { this.dataTypeSpec = dataTypeSpec }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun type(type: PropertyType): FluentBuilder = apply { this.type = type }
        override fun unit(unit: String): FluentBuilder = apply { this.unit = unit }
    }
}
