// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains an asset model hierarchy used in asset model creation. An asset model hierarchy
 * determines the kind (or type) of asset that can belong to a hierarchy.
 */
class AssetModelHierarchyDefinition private constructor(builder: BuilderImpl) {
    /**
     * The ID of an asset model for this hierarchy.
     */
    val childAssetModelId: String? = builder.childAssetModelId
    /**
     * The name of the asset model hierarchy definition (as specified in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel or
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel API operation).
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssetModelHierarchyDefinition = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssetModelHierarchyDefinition(")
        append("childAssetModelId=$childAssetModelId,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = childAssetModelId?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssetModelHierarchyDefinition

        if (childAssetModelId != other.childAssetModelId) return false
        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssetModelHierarchyDefinition = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssetModelHierarchyDefinition
        /**
         * The ID of an asset model for this hierarchy.
         */
        fun childAssetModelId(childAssetModelId: String): FluentBuilder
        /**
         * The name of the asset model hierarchy definition (as specified in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel or
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel API operation).
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of an asset model for this hierarchy.
         */
        var childAssetModelId: String?
        /**
         * The name of the asset model hierarchy definition (as specified in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel or
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel API operation).
         */
        var name: String?

        fun build(): AssetModelHierarchyDefinition
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var childAssetModelId: String? = null
        override var name: String? = null

        constructor(x: AssetModelHierarchyDefinition) : this() {
            this.childAssetModelId = x.childAssetModelId
            this.name = x.name
        }

        override fun build(): AssetModelHierarchyDefinition = AssetModelHierarchyDefinition(this)
        override fun childAssetModelId(childAssetModelId: String): FluentBuilder = apply { this.childAssetModelId = childAssetModelId }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
