// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Describes an asset hierarchy that contains a hierarchy's name, ID, and child asset model
 * ID that specifies the type of asset that can be in this hierarchy.
 */
class AssetModelHierarchy private constructor(builder: BuilderImpl) {
    /**
     * The ID of the asset model. All assets in this hierarchy must be instances of the
     * childAssetModelId asset model.
     */
    val childAssetModelId: String? = builder.childAssetModelId
    /**
     * The ID of the asset model hierarchy. This ID is a hierarchyId.
     */
    val id: String? = builder.id
    /**
     * The name of the asset model hierarchy that you specify by using the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel or
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel API operation.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssetModelHierarchy = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssetModelHierarchy(")
        append("childAssetModelId=$childAssetModelId,")
        append("id=$id,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = childAssetModelId?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssetModelHierarchy

        if (childAssetModelId != other.childAssetModelId) return false
        if (id != other.id) return false
        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssetModelHierarchy = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssetModelHierarchy
        /**
         * The ID of the asset model. All assets in this hierarchy must be instances of the
         * childAssetModelId asset model.
         */
        fun childAssetModelId(childAssetModelId: String): FluentBuilder
        /**
         * The ID of the asset model hierarchy. This ID is a hierarchyId.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name of the asset model hierarchy that you specify by using the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel or
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel API operation.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the asset model. All assets in this hierarchy must be instances of the
         * childAssetModelId asset model.
         */
        var childAssetModelId: String?
        /**
         * The ID of the asset model hierarchy. This ID is a hierarchyId.
         */
        var id: String?
        /**
         * The name of the asset model hierarchy that you specify by using the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel or
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel API operation.
         */
        var name: String?

        fun build(): AssetModelHierarchy
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var childAssetModelId: String? = null
        override var id: String? = null
        override var name: String? = null

        constructor(x: AssetModelHierarchy) : this() {
            this.childAssetModelId = x.childAssetModelId
            this.id = x.id
            this.name = x.name
        }

        override fun build(): AssetModelHierarchy = AssetModelHierarchy(this)
        override fun childAssetModelId(childAssetModelId: String): FluentBuilder = apply { this.childAssetModelId = childAssetModelId }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
