// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
 * You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
 * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms in the IoT SiteWise Application Guide.
 */
class Alarms private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the IAM role that allows the alarm to perform actions and access Amazon Web Services
     * resources and services, such as IoT Events.
     */
    val alarmRoleArn: String? = builder.alarmRoleArn
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Lambda function that manages alarm notifications. For more
     * information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">Managing alarm
     * notifications in the IoT Events Developer Guide.
     */
    val notificationLambdaArn: String? = builder.notificationLambdaArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Alarms = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Alarms(")
        append("alarmRoleArn=$alarmRoleArn,")
        append("notificationLambdaArn=$notificationLambdaArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmRoleArn?.hashCode() ?: 0
        result = 31 * result + (notificationLambdaArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Alarms

        if (alarmRoleArn != other.alarmRoleArn) return false
        if (notificationLambdaArn != other.notificationLambdaArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Alarms = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Alarms
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the IAM role that allows the alarm to perform actions and access Amazon Web Services
         * resources and services, such as IoT Events.
         */
        fun alarmRoleArn(alarmRoleArn: String): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Lambda function that manages alarm notifications. For more
         * information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">Managing alarm
         * notifications in the IoT Events Developer Guide.
         */
        fun notificationLambdaArn(notificationLambdaArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the IAM role that allows the alarm to perform actions and access Amazon Web Services
         * resources and services, such as IoT Events.
         */
        var alarmRoleArn: String?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the Lambda function that manages alarm notifications. For more
         * information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">Managing alarm
         * notifications in the IoT Events Developer Guide.
         */
        var notificationLambdaArn: String?

        fun build(): Alarms
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var alarmRoleArn: String? = null
        override var notificationLambdaArn: String? = null

        constructor(x: Alarms) : this() {
            this.alarmRoleArn = x.alarmRoleArn
            this.notificationLambdaArn = x.notificationLambdaArn
        }

        override fun build(): Alarms = Alarms(this)
        override fun alarmRoleArn(alarmRoleArn: String): FluentBuilder = apply { this.alarmRoleArn = alarmRoleArn }
        override fun notificationLambdaArn(notificationLambdaArn: String): FluentBuilder = apply { this.notificationLambdaArn = notificationLambdaArn }
    }
}
