// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains an access policy that defines an identity's access to an IoT SiteWise Monitor
 * resource.
 */
class AccessPolicySummary private constructor(builder: BuilderImpl) {
    /**
     * The date the access policy was created, in Unix epoch time.
     */
    val creationDate: Instant? = builder.creationDate
    /**
     * The ID of the access policy.
     */
    val id: String? = builder.id
    /**
     * The identity (an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user).
     */
    val identity: Identity? = builder.identity
    /**
     * The date the access policy was last updated, in Unix epoch time.
     */
    val lastUpdateDate: Instant? = builder.lastUpdateDate
    /**
     * The permissions for the access policy. Note that a project ADMINISTRATOR is
     * also known as a project owner.
     */
    val permission: Permission? = builder.permission
    /**
     * The IoT SiteWise Monitor resource (a portal or project).
     */
    val resource: Resource? = builder.resource

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AccessPolicySummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AccessPolicySummary(")
        append("creationDate=$creationDate,")
        append("id=$id,")
        append("identity=$identity,")
        append("lastUpdateDate=$lastUpdateDate,")
        append("permission=$permission,")
        append("resource=$resource)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (identity?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateDate?.hashCode() ?: 0)
        result = 31 * result + (permission?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AccessPolicySummary

        if (creationDate != other.creationDate) return false
        if (id != other.id) return false
        if (identity != other.identity) return false
        if (lastUpdateDate != other.lastUpdateDate) return false
        if (permission != other.permission) return false
        if (resource != other.resource) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AccessPolicySummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AccessPolicySummary
        /**
         * The date the access policy was created, in Unix epoch time.
         */
        fun creationDate(creationDate: Instant): FluentBuilder
        /**
         * The ID of the access policy.
         */
        fun id(id: String): FluentBuilder
        /**
         * The identity (an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user).
         */
        fun identity(identity: Identity): FluentBuilder
        /**
         * The date the access policy was last updated, in Unix epoch time.
         */
        fun lastUpdateDate(lastUpdateDate: Instant): FluentBuilder
        /**
         * The permissions for the access policy. Note that a project ADMINISTRATOR is
         * also known as a project owner.
         */
        fun permission(permission: Permission): FluentBuilder
        /**
         * The IoT SiteWise Monitor resource (a portal or project).
         */
        fun resource(resource: Resource): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date the access policy was created, in Unix epoch time.
         */
        var creationDate: Instant?
        /**
         * The ID of the access policy.
         */
        var id: String?
        /**
         * The identity (an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user).
         */
        var identity: Identity?
        /**
         * The date the access policy was last updated, in Unix epoch time.
         */
        var lastUpdateDate: Instant?
        /**
         * The permissions for the access policy. Note that a project ADMINISTRATOR is
         * also known as a project owner.
         */
        var permission: Permission?
        /**
         * The IoT SiteWise Monitor resource (a portal or project).
         */
        var resource: Resource?

        fun build(): AccessPolicySummary
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Identity] inside the given [block]
         */
        fun identity(block: Identity.DslBuilder.() -> kotlin.Unit) {
            this.identity = Identity.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Resource] inside the given [block]
         */
        fun resource(block: Resource.DslBuilder.() -> kotlin.Unit) {
            this.resource = Resource.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationDate: Instant? = null
        override var id: String? = null
        override var identity: Identity? = null
        override var lastUpdateDate: Instant? = null
        override var permission: Permission? = null
        override var resource: Resource? = null

        constructor(x: AccessPolicySummary) : this() {
            this.creationDate = x.creationDate
            this.id = x.id
            this.identity = x.identity
            this.lastUpdateDate = x.lastUpdateDate
            this.permission = x.permission
            this.resource = x.resource
        }

        override fun build(): AccessPolicySummary = AccessPolicySummary(this)
        override fun creationDate(creationDate: Instant): FluentBuilder = apply { this.creationDate = creationDate }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun identity(identity: Identity): FluentBuilder = apply { this.identity = identity }
        override fun lastUpdateDate(lastUpdateDate: Instant): FluentBuilder = apply { this.lastUpdateDate = lastUpdateDate }
        override fun permission(permission: Permission): FluentBuilder = apply { this.permission = permission }
        override fun resource(resource: Resource): FluentBuilder = apply { this.resource = resource }
    }
}
