// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.iotsitewise.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iotsitewise.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * Welcome to the IoT SiteWise API Reference. IoT SiteWise is an Amazon Web Services service that connects <a href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">Industrial Internet of Things (IIoT) devices to the power of the Amazon Web Services Cloud. For more information, see the
 * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/">IoT SiteWise User Guide. For information about IoT SiteWise quotas, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
 */
interface IoTSiteWiseClient : SdkClient {

    override val serviceName: String
        get() = "IoTSiteWise"
    /**
     * IoTSiteWiseClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): IoTSiteWiseClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultIoTSiteWiseClient(config)
        }

        operator fun invoke(config: Config): IoTSiteWiseClient = DefaultIoTSiteWiseClient(config)

        /**
         * Construct a [IoTSiteWiseClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): IoTSiteWiseClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return IoTSiteWiseClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Associates a child asset with the given parent asset through a hierarchy defined in the
     * parent asset's model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html">Associating assets in the
     * IoT SiteWise User Guide.
     */
    suspend fun associateAssets(input: AssociateAssetsRequest): AssociateAssetsResponse

    /**
     * Associates a child asset with the given parent asset through a hierarchy defined in the
     * parent asset's model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html">Associating assets in the
     * IoT SiteWise User Guide.
     */
    suspend fun associateAssets(block: AssociateAssetsRequest.DslBuilder.() -> Unit) = associateAssets(AssociateAssetsRequest.builder().apply(block).build())

    /**
     * Associates a group (batch) of assets with an IoT SiteWise Monitor project.
     */
    suspend fun batchAssociateProjectAssets(input: BatchAssociateProjectAssetsRequest): BatchAssociateProjectAssetsResponse

    /**
     * Associates a group (batch) of assets with an IoT SiteWise Monitor project.
     */
    suspend fun batchAssociateProjectAssets(block: BatchAssociateProjectAssetsRequest.DslBuilder.() -> Unit) = batchAssociateProjectAssets(BatchAssociateProjectAssetsRequest.builder().apply(block).build())

    /**
     * Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.
     */
    suspend fun batchDisassociateProjectAssets(input: BatchDisassociateProjectAssetsRequest): BatchDisassociateProjectAssetsResponse

    /**
     * Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.
     */
    suspend fun batchDisassociateProjectAssets(block: BatchDisassociateProjectAssetsRequest.DslBuilder.() -> Unit) = batchDisassociateProjectAssets(BatchDisassociateProjectAssetsRequest.builder().apply(block).build())

    /**
     * Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value
     * (TQV) data point. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html">Ingesting data using the API in the
     * IoT SiteWise User Guide.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     * With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more
     * than 7 days in the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps
     * outside of the inclusive range of &#91;-7 days, +10 minutes&#93; and returns a
     * TimestampOutOfRangeException error.
     * For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer
     * TQV has a different quality. For example, if you store a TQV {T1, GOOD, V1},
     * then storing {T1, GOOD, V2} replaces the existing TQV.
     * IoT SiteWise authorizes access to each BatchPutAssetPropertyValue entry individually.
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action">BatchPutAssetPropertyValue authorization in the
     * IoT SiteWise User Guide.
     */
    suspend fun batchPutAssetPropertyValue(input: BatchPutAssetPropertyValueRequest): BatchPutAssetPropertyValueResponse

    /**
     * Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value
     * (TQV) data point. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html">Ingesting data using the API in the
     * IoT SiteWise User Guide.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     * With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more
     * than 7 days in the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps
     * outside of the inclusive range of &#91;-7 days, +10 minutes&#93; and returns a
     * TimestampOutOfRangeException error.
     * For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer
     * TQV has a different quality. For example, if you store a TQV {T1, GOOD, V1},
     * then storing {T1, GOOD, V2} replaces the existing TQV.
     * IoT SiteWise authorizes access to each BatchPutAssetPropertyValue entry individually.
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action">BatchPutAssetPropertyValue authorization in the
     * IoT SiteWise User Guide.
     */
    suspend fun batchPutAssetPropertyValue(block: BatchPutAssetPropertyValueRequest.DslBuilder.() -> Unit) = batchPutAssetPropertyValue(BatchPutAssetPropertyValueRequest.builder().apply(block).build())

    /**
     * Creates an access policy that grants the specified identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or
     * IAM user) access to the specified IoT SiteWise Monitor portal or project resource.
     */
    suspend fun createAccessPolicy(input: CreateAccessPolicyRequest): CreateAccessPolicyResponse

    /**
     * Creates an access policy that grants the specified identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or
     * IAM user) access to the specified IoT SiteWise Monitor portal or project resource.
     */
    suspend fun createAccessPolicy(block: CreateAccessPolicyRequest.DslBuilder.() -> Unit) = createAccessPolicy(CreateAccessPolicyRequest.builder().apply(block).build())

    /**
     * Creates an asset from an existing asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets in the
     * IoT SiteWise User Guide.
     */
    suspend fun createAsset(input: CreateAssetRequest): CreateAssetResponse

    /**
     * Creates an asset from an existing asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets in the
     * IoT SiteWise User Guide.
     */
    suspend fun createAsset(block: CreateAssetRequest.DslBuilder.() -> Unit) = createAsset(CreateAssetRequest.builder().apply(block).build())

    /**
     * Creates an asset model from specified property and hierarchy definitions. You create
     * assets from asset models. With asset models, you can easily create assets of the same type
     * that have standardized definitions. Each asset created from a model inherits the asset model's
     * property and hierarchy definitions. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html">Defining asset models in the
     * IoT SiteWise User Guide.
     */
    suspend fun createAssetModel(input: CreateAssetModelRequest): CreateAssetModelResponse

    /**
     * Creates an asset model from specified property and hierarchy definitions. You create
     * assets from asset models. With asset models, you can easily create assets of the same type
     * that have standardized definitions. Each asset created from a model inherits the asset model's
     * property and hierarchy definitions. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html">Defining asset models in the
     * IoT SiteWise User Guide.
     */
    suspend fun createAssetModel(block: CreateAssetModelRequest.DslBuilder.() -> Unit) = createAssetModel(CreateAssetModelRequest.builder().apply(block).build())

    /**
     * Creates a dashboard in an IoT SiteWise Monitor project.
     */
    suspend fun createDashboard(input: CreateDashboardRequest): CreateDashboardResponse

    /**
     * Creates a dashboard in an IoT SiteWise Monitor project.
     */
    suspend fun createDashboard(block: CreateDashboardRequest.DslBuilder.() -> Unit) = createDashboard(CreateDashboardRequest.builder().apply(block).build())

    /**
     * Creates a gateway, which is a virtual or edge device that delivers industrial data streams
     * from local servers to IoT SiteWise. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a gateway in the
     * IoT SiteWise User Guide.
     */
    suspend fun createGateway(input: CreateGatewayRequest): CreateGatewayResponse

    /**
     * Creates a gateway, which is a virtual or edge device that delivers industrial data streams
     * from local servers to IoT SiteWise. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a gateway in the
     * IoT SiteWise User Guide.
     */
    suspend fun createGateway(block: CreateGatewayRequest.DslBuilder.() -> Unit) = createGateway(CreateGatewayRequest.builder().apply(block).build())

    /**
     * Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses Amazon Web Services SSO or IAM
     * to authenticate portal users and manage user permissions.
     * Before you can sign in to a new portal, you must add at least one identity to that
     * portal. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins">Adding or removing portal
     * administrators in the IoT SiteWise User Guide.
     */
    suspend fun createPortal(input: CreatePortalRequest): CreatePortalResponse

    /**
     * Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses Amazon Web Services SSO or IAM
     * to authenticate portal users and manage user permissions.
     * Before you can sign in to a new portal, you must add at least one identity to that
     * portal. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins">Adding or removing portal
     * administrators in the IoT SiteWise User Guide.
     */
    suspend fun createPortal(block: CreatePortalRequest.DslBuilder.() -> Unit) = createPortal(CreatePortalRequest.builder().apply(block).build())

    /**
     * Creates a project in the specified portal.
     */
    suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Creates a project in the specified portal.
     */
    suspend fun createProject(block: CreateProjectRequest.DslBuilder.() -> Unit) = createProject(CreateProjectRequest.builder().apply(block).build())

    /**
     * Deletes an access policy that grants the specified identity access to the specified
     * IoT SiteWise Monitor resource. You can use this operation to revoke access to an IoT SiteWise Monitor
     * resource.
     */
    suspend fun deleteAccessPolicy(input: DeleteAccessPolicyRequest): DeleteAccessPolicyResponse

    /**
     * Deletes an access policy that grants the specified identity access to the specified
     * IoT SiteWise Monitor resource. You can use this operation to revoke access to an IoT SiteWise Monitor
     * resource.
     */
    suspend fun deleteAccessPolicy(block: DeleteAccessPolicyRequest.DslBuilder.() -> Unit) = deleteAccessPolicy(DeleteAccessPolicyRequest.builder().apply(block).build())

    /**
     * Deletes an asset. This action can't be undone. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets and
     * models in the IoT SiteWise User Guide.
     * You can't delete an asset that's associated to another asset. For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html">DisassociateAssets.
     */
    suspend fun deleteAsset(input: DeleteAssetRequest): DeleteAssetResponse

    /**
     * Deletes an asset. This action can't be undone. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets and
     * models in the IoT SiteWise User Guide.
     * You can't delete an asset that's associated to another asset. For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html">DisassociateAssets.
     */
    suspend fun deleteAsset(block: DeleteAssetRequest.DslBuilder.() -> Unit) = deleteAsset(DeleteAssetRequest.builder().apply(block).build())

    /**
     * Deletes an asset model. This action can't be undone. You must delete all assets created
     * from an asset model before you can delete the model. Also, you can't delete an asset model if
     * a parent asset model exists that contains a property formula expression that depends on the
     * asset model that you want to delete. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets and models in the
     * IoT SiteWise User Guide.
     */
    suspend fun deleteAssetModel(input: DeleteAssetModelRequest): DeleteAssetModelResponse

    /**
     * Deletes an asset model. This action can't be undone. You must delete all assets created
     * from an asset model before you can delete the model. Also, you can't delete an asset model if
     * a parent asset model exists that contains a property formula expression that depends on the
     * asset model that you want to delete. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets and models in the
     * IoT SiteWise User Guide.
     */
    suspend fun deleteAssetModel(block: DeleteAssetModelRequest.DslBuilder.() -> Unit) = deleteAssetModel(DeleteAssetModelRequest.builder().apply(block).build())

    /**
     * Deletes a dashboard from IoT SiteWise Monitor.
     */
    suspend fun deleteDashboard(input: DeleteDashboardRequest): DeleteDashboardResponse

    /**
     * Deletes a dashboard from IoT SiteWise Monitor.
     */
    suspend fun deleteDashboard(block: DeleteDashboardRequest.DslBuilder.() -> Unit) = deleteDashboard(DeleteDashboardRequest.builder().apply(block).build())

    /**
     * Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain
     * in your gateway's file system.
     */
    suspend fun deleteGateway(input: DeleteGatewayRequest): DeleteGatewayResponse

    /**
     * Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain
     * in your gateway's file system.
     */
    suspend fun deleteGateway(block: DeleteGatewayRequest.DslBuilder.() -> Unit) = deleteGateway(DeleteGatewayRequest.builder().apply(block).build())

    /**
     * Deletes a portal from IoT SiteWise Monitor.
     */
    suspend fun deletePortal(input: DeletePortalRequest): DeletePortalResponse

    /**
     * Deletes a portal from IoT SiteWise Monitor.
     */
    suspend fun deletePortal(block: DeletePortalRequest.DslBuilder.() -> Unit) = deletePortal(DeletePortalRequest.builder().apply(block).build())

    /**
     * Deletes a project from IoT SiteWise Monitor.
     */
    suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Deletes a project from IoT SiteWise Monitor.
     */
    suspend fun deleteProject(block: DeleteProjectRequest.DslBuilder.() -> Unit) = deleteProject(DeleteProjectRequest.builder().apply(block).build())

    /**
     * Describes an access policy, which specifies an identity's access to an IoT SiteWise Monitor portal or
     * project.
     */
    suspend fun describeAccessPolicy(input: DescribeAccessPolicyRequest): DescribeAccessPolicyResponse

    /**
     * Describes an access policy, which specifies an identity's access to an IoT SiteWise Monitor portal or
     * project.
     */
    suspend fun describeAccessPolicy(block: DescribeAccessPolicyRequest.DslBuilder.() -> Unit) = describeAccessPolicy(DescribeAccessPolicyRequest.builder().apply(block).build())

    /**
     * Retrieves information about an asset.
     */
    suspend fun describeAsset(input: DescribeAssetRequest): DescribeAssetResponse

    /**
     * Retrieves information about an asset.
     */
    suspend fun describeAsset(block: DescribeAssetRequest.DslBuilder.() -> Unit) = describeAsset(DescribeAssetRequest.builder().apply(block).build())

    /**
     * Retrieves information about an asset model.
     */
    suspend fun describeAssetModel(input: DescribeAssetModelRequest): DescribeAssetModelResponse

    /**
     * Retrieves information about an asset model.
     */
    suspend fun describeAssetModel(block: DescribeAssetModelRequest.DslBuilder.() -> Unit) = describeAssetModel(DescribeAssetModelRequest.builder().apply(block).build())

    /**
     * Retrieves information about an asset property.
     * When you call this operation for an attribute property, this response includes the
     * default attribute value that you define in the asset model. If you update the default value
     * in the model, this operation's response includes the new default value.
     * This operation doesn't return the value of the asset property. To get the value of an
     * asset property, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html">GetAssetPropertyValue.
     */
    suspend fun describeAssetProperty(input: DescribeAssetPropertyRequest): DescribeAssetPropertyResponse

    /**
     * Retrieves information about an asset property.
     * When you call this operation for an attribute property, this response includes the
     * default attribute value that you define in the asset model. If you update the default value
     * in the model, this operation's response includes the new default value.
     * This operation doesn't return the value of the asset property. To get the value of an
     * asset property, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html">GetAssetPropertyValue.
     */
    suspend fun describeAssetProperty(block: DescribeAssetPropertyRequest.DslBuilder.() -> Unit) = describeAssetProperty(DescribeAssetPropertyRequest.builder().apply(block).build())

    /**
     * Retrieves information about a dashboard.
     */
    suspend fun describeDashboard(input: DescribeDashboardRequest): DescribeDashboardResponse

    /**
     * Retrieves information about a dashboard.
     */
    suspend fun describeDashboard(block: DescribeDashboardRequest.DslBuilder.() -> Unit) = describeDashboard(DescribeDashboardRequest.builder().apply(block).build())

    /**
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in
     * the default or specified Region. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management in the
     * IoT SiteWise User Guide.
     */
    suspend fun describeDefaultEncryptionConfiguration(input: DescribeDefaultEncryptionConfigurationRequest): DescribeDefaultEncryptionConfigurationResponse

    /**
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in
     * the default or specified Region. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management in the
     * IoT SiteWise User Guide.
     */
    suspend fun describeDefaultEncryptionConfiguration(block: DescribeDefaultEncryptionConfigurationRequest.DslBuilder.() -> Unit) = describeDefaultEncryptionConfiguration(DescribeDefaultEncryptionConfigurationRequest.builder().apply(block).build())

    /**
     * Retrieves information about a gateway.
     */
    suspend fun describeGateway(input: DescribeGatewayRequest): DescribeGatewayResponse

    /**
     * Retrieves information about a gateway.
     */
    suspend fun describeGateway(block: DescribeGatewayRequest.DslBuilder.() -> Unit) = describeGateway(DescribeGatewayRequest.builder().apply(block).build())

    /**
     * Retrieves information about a gateway capability configuration.
     * Each gateway capability defines data sources for a gateway. A capability configuration
     * can contain multiple data source configurations. If you define OPC-UA sources for a gateway in
     * the IoT SiteWise console, all of your OPC-UA sources are stored in one capability configuration. To
     * list all capability configurations for a gateway, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway.
     */
    suspend fun describeGatewayCapabilityConfiguration(input: DescribeGatewayCapabilityConfigurationRequest): DescribeGatewayCapabilityConfigurationResponse

    /**
     * Retrieves information about a gateway capability configuration.
     * Each gateway capability defines data sources for a gateway. A capability configuration
     * can contain multiple data source configurations. If you define OPC-UA sources for a gateway in
     * the IoT SiteWise console, all of your OPC-UA sources are stored in one capability configuration. To
     * list all capability configurations for a gateway, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway.
     */
    suspend fun describeGatewayCapabilityConfiguration(block: DescribeGatewayCapabilityConfigurationRequest.DslBuilder.() -> Unit) = describeGatewayCapabilityConfiguration(DescribeGatewayCapabilityConfigurationRequest.builder().apply(block).build())

    /**
     * Retrieves the current IoT SiteWise logging options.
     */
    suspend fun describeLoggingOptions(input: DescribeLoggingOptionsRequest): DescribeLoggingOptionsResponse

    /**
     * Retrieves the current IoT SiteWise logging options.
     */
    suspend fun describeLoggingOptions(block: DescribeLoggingOptionsRequest.DslBuilder.() -> Unit) = describeLoggingOptions(DescribeLoggingOptionsRequest.builder().apply(block).build())

    /**
     * Retrieves information about a portal.
     */
    suspend fun describePortal(input: DescribePortalRequest): DescribePortalResponse

    /**
     * Retrieves information about a portal.
     */
    suspend fun describePortal(block: DescribePortalRequest.DslBuilder.() -> Unit) = describePortal(DescribePortalRequest.builder().apply(block).build())

    /**
     * Retrieves information about a project.
     */
    suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse

    /**
     * Retrieves information about a project.
     */
    suspend fun describeProject(block: DescribeProjectRequest.DslBuilder.() -> Unit) = describeProject(DescribeProjectRequest.builder().apply(block).build())

    /**
     * Retrieves information about the storage configuration for IoT SiteWise.
     */
    suspend fun describeStorageConfiguration(input: DescribeStorageConfigurationRequest): DescribeStorageConfigurationResponse

    /**
     * Retrieves information about the storage configuration for IoT SiteWise.
     */
    suspend fun describeStorageConfiguration(block: DescribeStorageConfigurationRequest.DslBuilder.() -> Unit) = describeStorageConfiguration(DescribeStorageConfigurationRequest.builder().apply(block).build())

    /**
     * Disassociates a child asset from the given parent asset through a hierarchy defined in the
     * parent asset's model.
     */
    suspend fun disassociateAssets(input: DisassociateAssetsRequest): DisassociateAssetsResponse

    /**
     * Disassociates a child asset from the given parent asset through a hierarchy defined in the
     * parent asset's model.
     */
    suspend fun disassociateAssets(block: DisassociateAssetsRequest.DslBuilder.() -> Unit) = disassociateAssets(DisassociateAssetsRequest.builder().apply(block).build())

    /**
     * Gets aggregated values for an asset property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates in the IoT SiteWise User Guide.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     */
    suspend fun getAssetPropertyAggregates(input: GetAssetPropertyAggregatesRequest): GetAssetPropertyAggregatesResponse

    /**
     * Gets aggregated values for an asset property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates in the IoT SiteWise User Guide.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     */
    suspend fun getAssetPropertyAggregates(block: GetAssetPropertyAggregatesRequest.DslBuilder.() -> Unit) = getAssetPropertyAggregates(GetAssetPropertyAggregatesRequest.builder().apply(block).build())

    /**
     * Gets an asset property's current value. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values">Querying
     * current values in the IoT SiteWise User Guide.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     */
    suspend fun getAssetPropertyValue(input: GetAssetPropertyValueRequest): GetAssetPropertyValueResponse

    /**
     * Gets an asset property's current value. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values">Querying
     * current values in the IoT SiteWise User Guide.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     */
    suspend fun getAssetPropertyValue(block: GetAssetPropertyValueRequest.DslBuilder.() -> Unit) = getAssetPropertyValue(GetAssetPropertyValueRequest.builder().apply(block).build())

    /**
     * Gets the history of an asset property's values. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values">Querying
     * historical values in the IoT SiteWise User Guide.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     */
    suspend fun getAssetPropertyValueHistory(input: GetAssetPropertyValueHistoryRequest): GetAssetPropertyValueHistoryResponse

    /**
     * Gets the history of an asset property's values. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values">Querying
     * historical values in the IoT SiteWise User Guide.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     */
    suspend fun getAssetPropertyValueHistory(block: GetAssetPropertyValueHistoryRequest.DslBuilder.() -> Unit) = getAssetPropertyValueHistory(GetAssetPropertyValueHistoryRequest.builder().apply(block).build())

    /**
     * Get interpolated values for an asset property for a specified time interval, during a
     * period of time. If your time series is missing data points during the specified time interval,
     * you can use interpolation to estimate the missing data.
     * For example, you can use this operation to return the interpolated
     * temperature values for a wind turbine every 24 hours over a duration of 7 days.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     */
    suspend fun getInterpolatedAssetPropertyValues(input: GetInterpolatedAssetPropertyValuesRequest): GetInterpolatedAssetPropertyValuesResponse

    /**
     * Get interpolated values for an asset property for a specified time interval, during a
     * period of time. If your time series is missing data points during the specified time interval,
     * you can use interpolation to estimate the missing data.
     * For example, you can use this operation to return the interpolated
     * temperature values for a wind turbine every 24 hours over a duration of 7 days.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     */
    suspend fun getInterpolatedAssetPropertyValues(block: GetInterpolatedAssetPropertyValuesRequest.DslBuilder.() -> Unit) = getInterpolatedAssetPropertyValues(GetInterpolatedAssetPropertyValuesRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of access policies for an identity (an Amazon Web Services SSO user, an Amazon Web Services SSO
     * group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).
     */
    suspend fun listAccessPolicies(input: ListAccessPoliciesRequest): ListAccessPoliciesResponse

    /**
     * Retrieves a paginated list of access policies for an identity (an Amazon Web Services SSO user, an Amazon Web Services SSO
     * group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).
     */
    suspend fun listAccessPolicies(block: ListAccessPoliciesRequest.DslBuilder.() -> Unit) = listAccessPolicies(ListAccessPoliciesRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of summaries of all asset models.
     */
    suspend fun listAssetModels(input: ListAssetModelsRequest): ListAssetModelsResponse

    /**
     * Retrieves a paginated list of summaries of all asset models.
     */
    suspend fun listAssetModels(block: ListAssetModelsRequest.DslBuilder.() -> Unit) = listAssetModels(ListAssetModelsRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of asset relationships for an asset. You can use this operation
     * to identify an asset's root asset and all associated assets between that asset and its
     * root.
     */
    suspend fun listAssetRelationships(input: ListAssetRelationshipsRequest): ListAssetRelationshipsResponse

    /**
     * Retrieves a paginated list of asset relationships for an asset. You can use this operation
     * to identify an asset's root asset and all associated assets between that asset and its
     * root.
     */
    suspend fun listAssetRelationships(block: ListAssetRelationshipsRequest.DslBuilder.() -> Unit) = listAssetRelationships(ListAssetRelationshipsRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of asset summaries.
     * You can use this operation to do the following:
     * List assets based on a specific asset model.
     * List top-level assets.
     * You can't use this operation to list all assets. To retrieve summaries for all of your
     * assets, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels to get all of your asset model IDs. Then, use ListAssets to get all
     * assets for each asset model.
     */
    suspend fun listAssets(input: ListAssetsRequest): ListAssetsResponse

    /**
     * Retrieves a paginated list of asset summaries.
     * You can use this operation to do the following:
     * List assets based on a specific asset model.
     * List top-level assets.
     * You can't use this operation to list all assets. To retrieve summaries for all of your
     * assets, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels to get all of your asset model IDs. Then, use ListAssets to get all
     * assets for each asset model.
     */
    suspend fun listAssets(block: ListAssetsRequest.DslBuilder.() -> Unit) = listAssets(ListAssetsRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of associated assets.
     * You can use this operation to do the following:
     * List child assets associated to a parent asset by a hierarchy that you specify.
     * List an asset's parent asset.
     */
    suspend fun listAssociatedAssets(input: ListAssociatedAssetsRequest): ListAssociatedAssetsResponse

    /**
     * Retrieves a paginated list of associated assets.
     * You can use this operation to do the following:
     * List child assets associated to a parent asset by a hierarchy that you specify.
     * List an asset's parent asset.
     */
    suspend fun listAssociatedAssets(block: ListAssociatedAssetsRequest.DslBuilder.() -> Unit) = listAssociatedAssets(ListAssociatedAssetsRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
     */
    suspend fun listDashboards(input: ListDashboardsRequest): ListDashboardsResponse

    /**
     * Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
     */
    suspend fun listDashboards(block: ListDashboardsRequest.DslBuilder.() -> Unit) = listDashboards(ListDashboardsRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of gateways.
     */
    suspend fun listGateways(input: ListGatewaysRequest): ListGatewaysResponse

    /**
     * Retrieves a paginated list of gateways.
     */
    suspend fun listGateways(block: ListGatewaysRequest.DslBuilder.() -> Unit) = listGateways(ListGatewaysRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of IoT SiteWise Monitor portals.
     */
    suspend fun listPortals(input: ListPortalsRequest): ListPortalsResponse

    /**
     * Retrieves a paginated list of IoT SiteWise Monitor portals.
     */
    suspend fun listPortals(block: ListPortalsRequest.DslBuilder.() -> Unit) = listPortals(ListPortalsRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.
     */
    suspend fun listProjectAssets(input: ListProjectAssetsRequest): ListProjectAssetsResponse

    /**
     * Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.
     */
    suspend fun listProjectAssets(block: ListProjectAssetsRequest.DslBuilder.() -> Unit) = listProjectAssets(ListProjectAssetsRequest.builder().apply(block).build())

    /**
     * Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
     */
    suspend fun listProjects(input: ListProjectsRequest): ListProjectsResponse

    /**
     * Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
     */
    suspend fun listProjects(block: ListProjectsRequest.DslBuilder.() -> Unit) = listProjects(ListProjectsRequest.builder().apply(block).build())

    /**
     * Retrieves the list of tags for an IoT SiteWise resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves the list of tags for an IoT SiteWise resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management in
     * the IoT SiteWise User Guide.
     */
    suspend fun putDefaultEncryptionConfiguration(input: PutDefaultEncryptionConfigurationRequest): PutDefaultEncryptionConfigurationResponse

    /**
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management in
     * the IoT SiteWise User Guide.
     */
    suspend fun putDefaultEncryptionConfiguration(block: PutDefaultEncryptionConfigurationRequest.DslBuilder.() -> Unit) = putDefaultEncryptionConfiguration(PutDefaultEncryptionConfigurationRequest.builder().apply(block).build())

    /**
     * Sets logging options for IoT SiteWise.
     */
    suspend fun putLoggingOptions(input: PutLoggingOptionsRequest): PutLoggingOptionsResponse

    /**
     * Sets logging options for IoT SiteWise.
     */
    suspend fun putLoggingOptions(block: PutLoggingOptionsRequest.DslBuilder.() -> Unit) = putLoggingOptions(PutLoggingOptionsRequest.builder().apply(block).build())

    /**
     * Configures storage settings for IoT SiteWise.
     */
    suspend fun putStorageConfiguration(input: PutStorageConfigurationRequest): PutStorageConfigurationResponse

    /**
     * Configures storage settings for IoT SiteWise.
     */
    suspend fun putStorageConfiguration(block: PutStorageConfigurationRequest.DslBuilder.() -> Unit) = putStorageConfiguration(PutStorageConfigurationRequest.builder().apply(block).build())

    /**
     * Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation
     * updates the tag's value.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation
     * updates the tag's value.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes a tag from an IoT SiteWise resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes a tag from an IoT SiteWise resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates an existing access policy that specifies an identity's access to an IoT SiteWise Monitor
     * portal or project resource.
     */
    suspend fun updateAccessPolicy(input: UpdateAccessPolicyRequest): UpdateAccessPolicyResponse

    /**
     * Updates an existing access policy that specifies an identity's access to an IoT SiteWise Monitor
     * portal or project resource.
     */
    suspend fun updateAccessPolicy(block: UpdateAccessPolicyRequest.DslBuilder.() -> Unit) = updateAccessPolicy(UpdateAccessPolicyRequest.builder().apply(block).build())

    /**
     * Updates an asset's name. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets and models in the
     * IoT SiteWise User Guide.
     */
    suspend fun updateAsset(input: UpdateAssetRequest): UpdateAssetResponse

    /**
     * Updates an asset's name. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets and models in the
     * IoT SiteWise User Guide.
     */
    suspend fun updateAsset(block: UpdateAssetRequest.DslBuilder.() -> Unit) = updateAsset(UpdateAssetRequest.builder().apply(block).build())

    /**
     * Updates an asset model and all of the assets that were created from the model. Each asset
     * created from the model inherits the updated asset model's property and hierarchy definitions.
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets and models in the
     * IoT SiteWise User Guide.
     * This operation overwrites the existing model with the provided model. To avoid deleting
     * your asset model's properties or hierarchies, you must include their IDs and definitions in
     * the updated asset model payload. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel.
     * If you remove a property from an asset model, IoT SiteWise deletes all previous data for that
     * property. If you remove a hierarchy definition from an asset model, IoT SiteWise disassociates every
     * asset associated with that hierarchy. You can't change the type or data type of an existing
     * property.
     */
    suspend fun updateAssetModel(input: UpdateAssetModelRequest): UpdateAssetModelResponse

    /**
     * Updates an asset model and all of the assets that were created from the model. Each asset
     * created from the model inherits the updated asset model's property and hierarchy definitions.
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets and models in the
     * IoT SiteWise User Guide.
     * This operation overwrites the existing model with the provided model. To avoid deleting
     * your asset model's properties or hierarchies, you must include their IDs and definitions in
     * the updated asset model payload. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel.
     * If you remove a property from an asset model, IoT SiteWise deletes all previous data for that
     * property. If you remove a hierarchy definition from an asset model, IoT SiteWise disassociates every
     * asset associated with that hierarchy. You can't change the type or data type of an existing
     * property.
     */
    suspend fun updateAssetModel(block: UpdateAssetModelRequest.DslBuilder.() -> Unit) = updateAssetModel(UpdateAssetModelRequest.builder().apply(block).build())

    /**
     * Updates an asset property's alias and notification state.
     * This operation overwrites the property's existing alias and notification state. To keep
     * your existing property's alias or notification state, you must include the existing values
     * in the UpdateAssetProperty request. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html">DescribeAssetProperty.
     */
    suspend fun updateAssetProperty(input: UpdateAssetPropertyRequest): UpdateAssetPropertyResponse

    /**
     * Updates an asset property's alias and notification state.
     * This operation overwrites the property's existing alias and notification state. To keep
     * your existing property's alias or notification state, you must include the existing values
     * in the UpdateAssetProperty request. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html">DescribeAssetProperty.
     */
    suspend fun updateAssetProperty(block: UpdateAssetPropertyRequest.DslBuilder.() -> Unit) = updateAssetProperty(UpdateAssetPropertyRequest.builder().apply(block).build())

    /**
     * Updates an IoT SiteWise Monitor dashboard.
     */
    suspend fun updateDashboard(input: UpdateDashboardRequest): UpdateDashboardResponse

    /**
     * Updates an IoT SiteWise Monitor dashboard.
     */
    suspend fun updateDashboard(block: UpdateDashboardRequest.DslBuilder.() -> Unit) = updateDashboard(UpdateDashboardRequest.builder().apply(block).build())

    /**
     * Updates a gateway's name.
     */
    suspend fun updateGateway(input: UpdateGatewayRequest): UpdateGatewayResponse

    /**
     * Updates a gateway's name.
     */
    suspend fun updateGateway(block: UpdateGatewayRequest.DslBuilder.() -> Unit) = updateGateway(UpdateGatewayRequest.builder().apply(block).build())

    /**
     * Updates a gateway capability configuration or defines a new capability configuration.
     * Each gateway capability defines data sources for a gateway. A capability configuration
     * can contain multiple data source configurations. If you define OPC-UA sources for a gateway in
     * the IoT SiteWise console, all of your OPC-UA sources are stored in one capability configuration. To
     * list all capability configurations for a gateway, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway.
     */
    suspend fun updateGatewayCapabilityConfiguration(input: UpdateGatewayCapabilityConfigurationRequest): UpdateGatewayCapabilityConfigurationResponse

    /**
     * Updates a gateway capability configuration or defines a new capability configuration.
     * Each gateway capability defines data sources for a gateway. A capability configuration
     * can contain multiple data source configurations. If you define OPC-UA sources for a gateway in
     * the IoT SiteWise console, all of your OPC-UA sources are stored in one capability configuration. To
     * list all capability configurations for a gateway, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway.
     */
    suspend fun updateGatewayCapabilityConfiguration(block: UpdateGatewayCapabilityConfigurationRequest.DslBuilder.() -> Unit) = updateGatewayCapabilityConfiguration(UpdateGatewayCapabilityConfigurationRequest.builder().apply(block).build())

    /**
     * Updates an IoT SiteWise Monitor portal.
     */
    suspend fun updatePortal(input: UpdatePortalRequest): UpdatePortalResponse

    /**
     * Updates an IoT SiteWise Monitor portal.
     */
    suspend fun updatePortal(block: UpdatePortalRequest.DslBuilder.() -> Unit) = updatePortal(UpdatePortalRequest.builder().apply(block).build())

    /**
     * Updates an IoT SiteWise Monitor project.
     */
    suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse

    /**
     * Updates an IoT SiteWise Monitor project.
     */
    suspend fun updateProject(block: UpdateProjectRequest.DslBuilder.() -> Unit) = updateProject(UpdateProjectRequest.builder().apply(block).build())
}
