// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.iotsitewise.model.*
import aws.sdk.kotlin.services.iotsitewise.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "IoTSiteWise"
const val ServiceApiVersion: String = "2019-12-02"
const val SdkVersion: String = "0.9.0-alpha"

internal class DefaultIoTSiteWiseClient(override val config: IoTSiteWiseClient.Config) : IoTSiteWiseClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Associates a child asset with the given parent asset through a hierarchy defined in the
     * parent asset's model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html">Associating assets in the
     * IoT SiteWise User Guide.
     */
    override suspend fun associateAssets(input: AssociateAssetsRequest): AssociateAssetsResponse {
        val op = SdkHttpOperation.build<AssociateAssetsRequest, AssociateAssetsResponse> {
            serializer = AssociateAssetsOperationSerializer()
            deserializer = AssociateAssetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateAssets"
                hostPrefix = "api."
            }
        }
        registerAssociateAssetsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a group (batch) of assets with an IoT SiteWise Monitor project.
     */
    override suspend fun batchAssociateProjectAssets(input: BatchAssociateProjectAssetsRequest): BatchAssociateProjectAssetsResponse {
        val op = SdkHttpOperation.build<BatchAssociateProjectAssetsRequest, BatchAssociateProjectAssetsResponse> {
            serializer = BatchAssociateProjectAssetsOperationSerializer()
            deserializer = BatchAssociateProjectAssetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchAssociateProjectAssets"
                hostPrefix = "monitor."
            }
        }
        registerBatchAssociateProjectAssetsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.
     */
    override suspend fun batchDisassociateProjectAssets(input: BatchDisassociateProjectAssetsRequest): BatchDisassociateProjectAssetsResponse {
        val op = SdkHttpOperation.build<BatchDisassociateProjectAssetsRequest, BatchDisassociateProjectAssetsResponse> {
            serializer = BatchDisassociateProjectAssetsOperationSerializer()
            deserializer = BatchDisassociateProjectAssetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDisassociateProjectAssets"
                hostPrefix = "monitor."
            }
        }
        registerBatchDisassociateProjectAssetsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value
     * (TQV) data point. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html">Ingesting data using the API in the
     * IoT SiteWise User Guide.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     * With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more
     * than 7 days in the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps
     * outside of the inclusive range of &#91;-7 days, +10 minutes&#93; and returns a
     * TimestampOutOfRangeException error.
     * For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer
     * TQV has a different quality. For example, if you store a TQV {T1, GOOD, V1},
     * then storing {T1, GOOD, V2} replaces the existing TQV.
     * IoT SiteWise authorizes access to each BatchPutAssetPropertyValue entry individually.
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action">BatchPutAssetPropertyValue authorization in the
     * IoT SiteWise User Guide.
     */
    override suspend fun batchPutAssetPropertyValue(input: BatchPutAssetPropertyValueRequest): BatchPutAssetPropertyValueResponse {
        val op = SdkHttpOperation.build<BatchPutAssetPropertyValueRequest, BatchPutAssetPropertyValueResponse> {
            serializer = BatchPutAssetPropertyValueOperationSerializer()
            deserializer = BatchPutAssetPropertyValueOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchPutAssetPropertyValue"
                hostPrefix = "data."
            }
        }
        registerBatchPutAssetPropertyValueMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an access policy that grants the specified identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or
     * IAM user) access to the specified IoT SiteWise Monitor portal or project resource.
     */
    override suspend fun createAccessPolicy(input: CreateAccessPolicyRequest): CreateAccessPolicyResponse {
        val op = SdkHttpOperation.build<CreateAccessPolicyRequest, CreateAccessPolicyResponse> {
            serializer = CreateAccessPolicyOperationSerializer()
            deserializer = CreateAccessPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateAccessPolicy"
                hostPrefix = "monitor."
            }
        }
        registerCreateAccessPolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an asset from an existing asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets in the
     * IoT SiteWise User Guide.
     */
    override suspend fun createAsset(input: CreateAssetRequest): CreateAssetResponse {
        val op = SdkHttpOperation.build<CreateAssetRequest, CreateAssetResponse> {
            serializer = CreateAssetOperationSerializer()
            deserializer = CreateAssetOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "CreateAsset"
                hostPrefix = "api."
            }
        }
        registerCreateAssetMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an asset model from specified property and hierarchy definitions. You create
     * assets from asset models. With asset models, you can easily create assets of the same type
     * that have standardized definitions. Each asset created from a model inherits the asset model's
     * property and hierarchy definitions. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html">Defining asset models in the
     * IoT SiteWise User Guide.
     */
    override suspend fun createAssetModel(input: CreateAssetModelRequest): CreateAssetModelResponse {
        val op = SdkHttpOperation.build<CreateAssetModelRequest, CreateAssetModelResponse> {
            serializer = CreateAssetModelOperationSerializer()
            deserializer = CreateAssetModelOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "CreateAssetModel"
                hostPrefix = "api."
            }
        }
        registerCreateAssetModelMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a dashboard in an IoT SiteWise Monitor project.
     */
    override suspend fun createDashboard(input: CreateDashboardRequest): CreateDashboardResponse {
        val op = SdkHttpOperation.build<CreateDashboardRequest, CreateDashboardResponse> {
            serializer = CreateDashboardOperationSerializer()
            deserializer = CreateDashboardOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateDashboard"
                hostPrefix = "monitor."
            }
        }
        registerCreateDashboardMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a gateway, which is a virtual or edge device that delivers industrial data streams
     * from local servers to IoT SiteWise. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a gateway in the
     * IoT SiteWise User Guide.
     */
    override suspend fun createGateway(input: CreateGatewayRequest): CreateGatewayResponse {
        val op = SdkHttpOperation.build<CreateGatewayRequest, CreateGatewayResponse> {
            serializer = CreateGatewayOperationSerializer()
            deserializer = CreateGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateGateway"
                hostPrefix = "api."
            }
        }
        registerCreateGatewayMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses Amazon Web Services SSO or IAM
     * to authenticate portal users and manage user permissions.
     * Before you can sign in to a new portal, you must add at least one identity to that
     * portal. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins">Adding or removing portal
     * administrators in the IoT SiteWise User Guide.
     */
    override suspend fun createPortal(input: CreatePortalRequest): CreatePortalResponse {
        val op = SdkHttpOperation.build<CreatePortalRequest, CreatePortalResponse> {
            serializer = CreatePortalOperationSerializer()
            deserializer = CreatePortalOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "CreatePortal"
                hostPrefix = "monitor."
            }
        }
        registerCreatePortalMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a project in the specified portal.
     */
    override suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse {
        val op = SdkHttpOperation.build<CreateProjectRequest, CreateProjectResponse> {
            serializer = CreateProjectOperationSerializer()
            deserializer = CreateProjectOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateProject"
                hostPrefix = "monitor."
            }
        }
        registerCreateProjectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an access policy that grants the specified identity access to the specified
     * IoT SiteWise Monitor resource. You can use this operation to revoke access to an IoT SiteWise Monitor
     * resource.
     */
    override suspend fun deleteAccessPolicy(input: DeleteAccessPolicyRequest): DeleteAccessPolicyResponse {
        val op = SdkHttpOperation.build<DeleteAccessPolicyRequest, DeleteAccessPolicyResponse> {
            serializer = DeleteAccessPolicyOperationSerializer()
            deserializer = DeleteAccessPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteAccessPolicy"
                hostPrefix = "monitor."
            }
        }
        registerDeleteAccessPolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an asset. This action can't be undone. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets and
     * models in the IoT SiteWise User Guide.
     * You can't delete an asset that's associated to another asset. For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html">DisassociateAssets.
     */
    override suspend fun deleteAsset(input: DeleteAssetRequest): DeleteAssetResponse {
        val op = SdkHttpOperation.build<DeleteAssetRequest, DeleteAssetResponse> {
            serializer = DeleteAssetOperationSerializer()
            deserializer = DeleteAssetOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteAsset"
                hostPrefix = "api."
            }
        }
        registerDeleteAssetMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an asset model. This action can't be undone. You must delete all assets created
     * from an asset model before you can delete the model. Also, you can't delete an asset model if
     * a parent asset model exists that contains a property formula expression that depends on the
     * asset model that you want to delete. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets and models in the
     * IoT SiteWise User Guide.
     */
    override suspend fun deleteAssetModel(input: DeleteAssetModelRequest): DeleteAssetModelResponse {
        val op = SdkHttpOperation.build<DeleteAssetModelRequest, DeleteAssetModelResponse> {
            serializer = DeleteAssetModelOperationSerializer()
            deserializer = DeleteAssetModelOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteAssetModel"
                hostPrefix = "api."
            }
        }
        registerDeleteAssetModelMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a dashboard from IoT SiteWise Monitor.
     */
    override suspend fun deleteDashboard(input: DeleteDashboardRequest): DeleteDashboardResponse {
        val op = SdkHttpOperation.build<DeleteDashboardRequest, DeleteDashboardResponse> {
            serializer = DeleteDashboardOperationSerializer()
            deserializer = DeleteDashboardOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteDashboard"
                hostPrefix = "monitor."
            }
        }
        registerDeleteDashboardMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain
     * in your gateway's file system.
     */
    override suspend fun deleteGateway(input: DeleteGatewayRequest): DeleteGatewayResponse {
        val op = SdkHttpOperation.build<DeleteGatewayRequest, DeleteGatewayResponse> {
            serializer = DeleteGatewayOperationSerializer()
            deserializer = DeleteGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGateway"
                hostPrefix = "api."
            }
        }
        registerDeleteGatewayMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a portal from IoT SiteWise Monitor.
     */
    override suspend fun deletePortal(input: DeletePortalRequest): DeletePortalResponse {
        val op = SdkHttpOperation.build<DeletePortalRequest, DeletePortalResponse> {
            serializer = DeletePortalOperationSerializer()
            deserializer = DeletePortalOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeletePortal"
                hostPrefix = "monitor."
            }
        }
        registerDeletePortalMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a project from IoT SiteWise Monitor.
     */
    override suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse {
        val op = SdkHttpOperation.build<DeleteProjectRequest, DeleteProjectResponse> {
            serializer = DeleteProjectOperationSerializer()
            deserializer = DeleteProjectOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteProject"
                hostPrefix = "monitor."
            }
        }
        registerDeleteProjectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describes an access policy, which specifies an identity's access to an IoT SiteWise Monitor portal or
     * project.
     */
    override suspend fun describeAccessPolicy(input: DescribeAccessPolicyRequest): DescribeAccessPolicyResponse {
        val op = SdkHttpOperation.build<DescribeAccessPolicyRequest, DescribeAccessPolicyResponse> {
            serializer = DescribeAccessPolicyOperationSerializer()
            deserializer = DescribeAccessPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccessPolicy"
                hostPrefix = "monitor."
            }
        }
        registerDescribeAccessPolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about an asset.
     */
    override suspend fun describeAsset(input: DescribeAssetRequest): DescribeAssetResponse {
        val op = SdkHttpOperation.build<DescribeAssetRequest, DescribeAssetResponse> {
            serializer = DescribeAssetOperationSerializer()
            deserializer = DescribeAssetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAsset"
                hostPrefix = "api."
            }
        }
        registerDescribeAssetMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about an asset model.
     */
    override suspend fun describeAssetModel(input: DescribeAssetModelRequest): DescribeAssetModelResponse {
        val op = SdkHttpOperation.build<DescribeAssetModelRequest, DescribeAssetModelResponse> {
            serializer = DescribeAssetModelOperationSerializer()
            deserializer = DescribeAssetModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAssetModel"
                hostPrefix = "api."
            }
        }
        registerDescribeAssetModelMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about an asset property.
     * When you call this operation for an attribute property, this response includes the
     * default attribute value that you define in the asset model. If you update the default value
     * in the model, this operation's response includes the new default value.
     * This operation doesn't return the value of the asset property. To get the value of an
     * asset property, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html">GetAssetPropertyValue.
     */
    override suspend fun describeAssetProperty(input: DescribeAssetPropertyRequest): DescribeAssetPropertyResponse {
        val op = SdkHttpOperation.build<DescribeAssetPropertyRequest, DescribeAssetPropertyResponse> {
            serializer = DescribeAssetPropertyOperationSerializer()
            deserializer = DescribeAssetPropertyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAssetProperty"
                hostPrefix = "api."
            }
        }
        registerDescribeAssetPropertyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a dashboard.
     */
    override suspend fun describeDashboard(input: DescribeDashboardRequest): DescribeDashboardResponse {
        val op = SdkHttpOperation.build<DescribeDashboardRequest, DescribeDashboardResponse> {
            serializer = DescribeDashboardOperationSerializer()
            deserializer = DescribeDashboardOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDashboard"
                hostPrefix = "monitor."
            }
        }
        registerDescribeDashboardMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in
     * the default or specified Region. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management in the
     * IoT SiteWise User Guide.
     */
    override suspend fun describeDefaultEncryptionConfiguration(input: DescribeDefaultEncryptionConfigurationRequest): DescribeDefaultEncryptionConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeDefaultEncryptionConfigurationRequest, DescribeDefaultEncryptionConfigurationResponse> {
            serializer = DescribeDefaultEncryptionConfigurationOperationSerializer()
            deserializer = DescribeDefaultEncryptionConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDefaultEncryptionConfiguration"
                hostPrefix = "api."
            }
        }
        registerDescribeDefaultEncryptionConfigurationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a gateway.
     */
    override suspend fun describeGateway(input: DescribeGatewayRequest): DescribeGatewayResponse {
        val op = SdkHttpOperation.build<DescribeGatewayRequest, DescribeGatewayResponse> {
            serializer = DescribeGatewayOperationSerializer()
            deserializer = DescribeGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeGateway"
                hostPrefix = "api."
            }
        }
        registerDescribeGatewayMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a gateway capability configuration.
     * Each gateway capability defines data sources for a gateway. A capability configuration
     * can contain multiple data source configurations. If you define OPC-UA sources for a gateway in
     * the IoT SiteWise console, all of your OPC-UA sources are stored in one capability configuration. To
     * list all capability configurations for a gateway, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway.
     */
    override suspend fun describeGatewayCapabilityConfiguration(input: DescribeGatewayCapabilityConfigurationRequest): DescribeGatewayCapabilityConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeGatewayCapabilityConfigurationRequest, DescribeGatewayCapabilityConfigurationResponse> {
            serializer = DescribeGatewayCapabilityConfigurationOperationSerializer()
            deserializer = DescribeGatewayCapabilityConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeGatewayCapabilityConfiguration"
                hostPrefix = "api."
            }
        }
        registerDescribeGatewayCapabilityConfigurationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the current IoT SiteWise logging options.
     */
    override suspend fun describeLoggingOptions(input: DescribeLoggingOptionsRequest): DescribeLoggingOptionsResponse {
        val op = SdkHttpOperation.build<DescribeLoggingOptionsRequest, DescribeLoggingOptionsResponse> {
            serializer = DescribeLoggingOptionsOperationSerializer()
            deserializer = DescribeLoggingOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLoggingOptions"
                hostPrefix = "api."
            }
        }
        registerDescribeLoggingOptionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a portal.
     */
    override suspend fun describePortal(input: DescribePortalRequest): DescribePortalResponse {
        val op = SdkHttpOperation.build<DescribePortalRequest, DescribePortalResponse> {
            serializer = DescribePortalOperationSerializer()
            deserializer = DescribePortalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePortal"
                hostPrefix = "monitor."
            }
        }
        registerDescribePortalMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a project.
     */
    override suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse {
        val op = SdkHttpOperation.build<DescribeProjectRequest, DescribeProjectResponse> {
            serializer = DescribeProjectOperationSerializer()
            deserializer = DescribeProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProject"
                hostPrefix = "monitor."
            }
        }
        registerDescribeProjectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the storage configuration for IoT SiteWise.
     */
    override suspend fun describeStorageConfiguration(input: DescribeStorageConfigurationRequest): DescribeStorageConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeStorageConfigurationRequest, DescribeStorageConfigurationResponse> {
            serializer = DescribeStorageConfigurationOperationSerializer()
            deserializer = DescribeStorageConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStorageConfiguration"
                hostPrefix = "api."
            }
        }
        registerDescribeStorageConfigurationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a child asset from the given parent asset through a hierarchy defined in the
     * parent asset's model.
     */
    override suspend fun disassociateAssets(input: DisassociateAssetsRequest): DisassociateAssetsResponse {
        val op = SdkHttpOperation.build<DisassociateAssetsRequest, DisassociateAssetsResponse> {
            serializer = DisassociateAssetsOperationSerializer()
            deserializer = DisassociateAssetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateAssets"
                hostPrefix = "api."
            }
        }
        registerDisassociateAssetsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets aggregated values for an asset property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates in the IoT SiteWise User Guide.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     */
    override suspend fun getAssetPropertyAggregates(input: GetAssetPropertyAggregatesRequest): GetAssetPropertyAggregatesResponse {
        val op = SdkHttpOperation.build<GetAssetPropertyAggregatesRequest, GetAssetPropertyAggregatesResponse> {
            serializer = GetAssetPropertyAggregatesOperationSerializer()
            deserializer = GetAssetPropertyAggregatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAssetPropertyAggregates"
                hostPrefix = "data."
            }
        }
        registerGetAssetPropertyAggregatesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets an asset property's current value. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values">Querying
     * current values in the IoT SiteWise User Guide.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     */
    override suspend fun getAssetPropertyValue(input: GetAssetPropertyValueRequest): GetAssetPropertyValueResponse {
        val op = SdkHttpOperation.build<GetAssetPropertyValueRequest, GetAssetPropertyValueResponse> {
            serializer = GetAssetPropertyValueOperationSerializer()
            deserializer = GetAssetPropertyValueOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAssetPropertyValue"
                hostPrefix = "data."
            }
        }
        registerGetAssetPropertyValueMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the history of an asset property's values. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values">Querying
     * historical values in the IoT SiteWise User Guide.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     */
    override suspend fun getAssetPropertyValueHistory(input: GetAssetPropertyValueHistoryRequest): GetAssetPropertyValueHistoryResponse {
        val op = SdkHttpOperation.build<GetAssetPropertyValueHistoryRequest, GetAssetPropertyValueHistoryResponse> {
            serializer = GetAssetPropertyValueHistoryOperationSerializer()
            deserializer = GetAssetPropertyValueHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAssetPropertyValueHistory"
                hostPrefix = "data."
            }
        }
        registerGetAssetPropertyValueHistoryMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Get interpolated values for an asset property for a specified time interval, during a
     * period of time. If your time series is missing data points during the specified time interval,
     * you can use interpolation to estimate the missing data.
     * For example, you can use this operation to return the interpolated
     * temperature values for a wind turbine every 24 hours over a duration of 7 days.
     * To identify an asset property, you must specify one of the following:
     * The assetId and propertyId of an asset property.
     * A propertyAlias, which is a data stream alias (for example,
     * /company/windfarm/3/turbine/7/temperature). To define an asset property's alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     */
    override suspend fun getInterpolatedAssetPropertyValues(input: GetInterpolatedAssetPropertyValuesRequest): GetInterpolatedAssetPropertyValuesResponse {
        val op = SdkHttpOperation.build<GetInterpolatedAssetPropertyValuesRequest, GetInterpolatedAssetPropertyValuesResponse> {
            serializer = GetInterpolatedAssetPropertyValuesOperationSerializer()
            deserializer = GetInterpolatedAssetPropertyValuesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInterpolatedAssetPropertyValues"
                hostPrefix = "data."
            }
        }
        registerGetInterpolatedAssetPropertyValuesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of access policies for an identity (an Amazon Web Services SSO user, an Amazon Web Services SSO
     * group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).
     */
    override suspend fun listAccessPolicies(input: ListAccessPoliciesRequest): ListAccessPoliciesResponse {
        val op = SdkHttpOperation.build<ListAccessPoliciesRequest, ListAccessPoliciesResponse> {
            serializer = ListAccessPoliciesOperationSerializer()
            deserializer = ListAccessPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccessPolicies"
                hostPrefix = "monitor."
            }
        }
        registerListAccessPoliciesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of summaries of all asset models.
     */
    override suspend fun listAssetModels(input: ListAssetModelsRequest): ListAssetModelsResponse {
        val op = SdkHttpOperation.build<ListAssetModelsRequest, ListAssetModelsResponse> {
            serializer = ListAssetModelsOperationSerializer()
            deserializer = ListAssetModelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssetModels"
                hostPrefix = "api."
            }
        }
        registerListAssetModelsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of asset relationships for an asset. You can use this operation
     * to identify an asset's root asset and all associated assets between that asset and its
     * root.
     */
    override suspend fun listAssetRelationships(input: ListAssetRelationshipsRequest): ListAssetRelationshipsResponse {
        val op = SdkHttpOperation.build<ListAssetRelationshipsRequest, ListAssetRelationshipsResponse> {
            serializer = ListAssetRelationshipsOperationSerializer()
            deserializer = ListAssetRelationshipsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssetRelationships"
                hostPrefix = "api."
            }
        }
        registerListAssetRelationshipsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of asset summaries.
     * You can use this operation to do the following:
     * List assets based on a specific asset model.
     * List top-level assets.
     * You can't use this operation to list all assets. To retrieve summaries for all of your
     * assets, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels to get all of your asset model IDs. Then, use ListAssets to get all
     * assets for each asset model.
     */
    override suspend fun listAssets(input: ListAssetsRequest): ListAssetsResponse {
        val op = SdkHttpOperation.build<ListAssetsRequest, ListAssetsResponse> {
            serializer = ListAssetsOperationSerializer()
            deserializer = ListAssetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssets"
                hostPrefix = "api."
            }
        }
        registerListAssetsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of associated assets.
     * You can use this operation to do the following:
     * List child assets associated to a parent asset by a hierarchy that you specify.
     * List an asset's parent asset.
     */
    override suspend fun listAssociatedAssets(input: ListAssociatedAssetsRequest): ListAssociatedAssetsResponse {
        val op = SdkHttpOperation.build<ListAssociatedAssetsRequest, ListAssociatedAssetsResponse> {
            serializer = ListAssociatedAssetsOperationSerializer()
            deserializer = ListAssociatedAssetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssociatedAssets"
                hostPrefix = "api."
            }
        }
        registerListAssociatedAssetsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
     */
    override suspend fun listDashboards(input: ListDashboardsRequest): ListDashboardsResponse {
        val op = SdkHttpOperation.build<ListDashboardsRequest, ListDashboardsResponse> {
            serializer = ListDashboardsOperationSerializer()
            deserializer = ListDashboardsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDashboards"
                hostPrefix = "monitor."
            }
        }
        registerListDashboardsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of gateways.
     */
    override suspend fun listGateways(input: ListGatewaysRequest): ListGatewaysResponse {
        val op = SdkHttpOperation.build<ListGatewaysRequest, ListGatewaysResponse> {
            serializer = ListGatewaysOperationSerializer()
            deserializer = ListGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGateways"
                hostPrefix = "api."
            }
        }
        registerListGatewaysMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of IoT SiteWise Monitor portals.
     */
    override suspend fun listPortals(input: ListPortalsRequest): ListPortalsResponse {
        val op = SdkHttpOperation.build<ListPortalsRequest, ListPortalsResponse> {
            serializer = ListPortalsOperationSerializer()
            deserializer = ListPortalsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPortals"
                hostPrefix = "monitor."
            }
        }
        registerListPortalsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.
     */
    override suspend fun listProjectAssets(input: ListProjectAssetsRequest): ListProjectAssetsResponse {
        val op = SdkHttpOperation.build<ListProjectAssetsRequest, ListProjectAssetsResponse> {
            serializer = ListProjectAssetsOperationSerializer()
            deserializer = ListProjectAssetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProjectAssets"
                hostPrefix = "monitor."
            }
        }
        registerListProjectAssetsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
     */
    override suspend fun listProjects(input: ListProjectsRequest): ListProjectsResponse {
        val op = SdkHttpOperation.build<ListProjectsRequest, ListProjectsResponse> {
            serializer = ListProjectsOperationSerializer()
            deserializer = ListProjectsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProjects"
                hostPrefix = "monitor."
            }
        }
        registerListProjectsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the list of tags for an IoT SiteWise resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
                hostPrefix = "api."
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management in
     * the IoT SiteWise User Guide.
     */
    override suspend fun putDefaultEncryptionConfiguration(input: PutDefaultEncryptionConfigurationRequest): PutDefaultEncryptionConfigurationResponse {
        val op = SdkHttpOperation.build<PutDefaultEncryptionConfigurationRequest, PutDefaultEncryptionConfigurationResponse> {
            serializer = PutDefaultEncryptionConfigurationOperationSerializer()
            deserializer = PutDefaultEncryptionConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutDefaultEncryptionConfiguration"
                hostPrefix = "api."
            }
        }
        registerPutDefaultEncryptionConfigurationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Sets logging options for IoT SiteWise.
     */
    override suspend fun putLoggingOptions(input: PutLoggingOptionsRequest): PutLoggingOptionsResponse {
        val op = SdkHttpOperation.build<PutLoggingOptionsRequest, PutLoggingOptionsResponse> {
            serializer = PutLoggingOptionsOperationSerializer()
            deserializer = PutLoggingOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutLoggingOptions"
                hostPrefix = "api."
            }
        }
        registerPutLoggingOptionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Configures storage settings for IoT SiteWise.
     */
    override suspend fun putStorageConfiguration(input: PutStorageConfigurationRequest): PutStorageConfigurationResponse {
        val op = SdkHttpOperation.build<PutStorageConfigurationRequest, PutStorageConfigurationResponse> {
            serializer = PutStorageConfigurationOperationSerializer()
            deserializer = PutStorageConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutStorageConfiguration"
                hostPrefix = "api."
            }
        }
        registerPutStorageConfigurationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation
     * updates the tag's value.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
                hostPrefix = "api."
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from an IoT SiteWise resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
                hostPrefix = "api."
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing access policy that specifies an identity's access to an IoT SiteWise Monitor
     * portal or project resource.
     */
    override suspend fun updateAccessPolicy(input: UpdateAccessPolicyRequest): UpdateAccessPolicyResponse {
        val op = SdkHttpOperation.build<UpdateAccessPolicyRequest, UpdateAccessPolicyResponse> {
            serializer = UpdateAccessPolicyOperationSerializer()
            deserializer = UpdateAccessPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAccessPolicy"
                hostPrefix = "monitor."
            }
        }
        registerUpdateAccessPolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an asset's name. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets and models in the
     * IoT SiteWise User Guide.
     */
    override suspend fun updateAsset(input: UpdateAssetRequest): UpdateAssetResponse {
        val op = SdkHttpOperation.build<UpdateAssetRequest, UpdateAssetResponse> {
            serializer = UpdateAssetOperationSerializer()
            deserializer = UpdateAssetOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateAsset"
                hostPrefix = "api."
            }
        }
        registerUpdateAssetMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an asset model and all of the assets that were created from the model. Each asset
     * created from the model inherits the updated asset model's property and hierarchy definitions.
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets and models in the
     * IoT SiteWise User Guide.
     * This operation overwrites the existing model with the provided model. To avoid deleting
     * your asset model's properties or hierarchies, you must include their IDs and definitions in
     * the updated asset model payload. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel.
     * If you remove a property from an asset model, IoT SiteWise deletes all previous data for that
     * property. If you remove a hierarchy definition from an asset model, IoT SiteWise disassociates every
     * asset associated with that hierarchy. You can't change the type or data type of an existing
     * property.
     */
    override suspend fun updateAssetModel(input: UpdateAssetModelRequest): UpdateAssetModelResponse {
        val op = SdkHttpOperation.build<UpdateAssetModelRequest, UpdateAssetModelResponse> {
            serializer = UpdateAssetModelOperationSerializer()
            deserializer = UpdateAssetModelOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateAssetModel"
                hostPrefix = "api."
            }
        }
        registerUpdateAssetModelMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an asset property's alias and notification state.
     * This operation overwrites the property's existing alias and notification state. To keep
     * your existing property's alias or notification state, you must include the existing values
     * in the UpdateAssetProperty request. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html">DescribeAssetProperty.
     */
    override suspend fun updateAssetProperty(input: UpdateAssetPropertyRequest): UpdateAssetPropertyResponse {
        val op = SdkHttpOperation.build<UpdateAssetPropertyRequest, UpdateAssetPropertyResponse> {
            serializer = UpdateAssetPropertyOperationSerializer()
            deserializer = UpdateAssetPropertyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAssetProperty"
                hostPrefix = "api."
            }
        }
        registerUpdateAssetPropertyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an IoT SiteWise Monitor dashboard.
     */
    override suspend fun updateDashboard(input: UpdateDashboardRequest): UpdateDashboardResponse {
        val op = SdkHttpOperation.build<UpdateDashboardRequest, UpdateDashboardResponse> {
            serializer = UpdateDashboardOperationSerializer()
            deserializer = UpdateDashboardOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDashboard"
                hostPrefix = "monitor."
            }
        }
        registerUpdateDashboardMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a gateway's name.
     */
    override suspend fun updateGateway(input: UpdateGatewayRequest): UpdateGatewayResponse {
        val op = SdkHttpOperation.build<UpdateGatewayRequest, UpdateGatewayResponse> {
            serializer = UpdateGatewayOperationSerializer()
            deserializer = UpdateGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGateway"
                hostPrefix = "api."
            }
        }
        registerUpdateGatewayMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a gateway capability configuration or defines a new capability configuration.
     * Each gateway capability defines data sources for a gateway. A capability configuration
     * can contain multiple data source configurations. If you define OPC-UA sources for a gateway in
     * the IoT SiteWise console, all of your OPC-UA sources are stored in one capability configuration. To
     * list all capability configurations for a gateway, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway.
     */
    override suspend fun updateGatewayCapabilityConfiguration(input: UpdateGatewayCapabilityConfigurationRequest): UpdateGatewayCapabilityConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateGatewayCapabilityConfigurationRequest, UpdateGatewayCapabilityConfigurationResponse> {
            serializer = UpdateGatewayCapabilityConfigurationOperationSerializer()
            deserializer = UpdateGatewayCapabilityConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "UpdateGatewayCapabilityConfiguration"
                hostPrefix = "api."
            }
        }
        registerUpdateGatewayCapabilityConfigurationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an IoT SiteWise Monitor portal.
     */
    override suspend fun updatePortal(input: UpdatePortalRequest): UpdatePortalResponse {
        val op = SdkHttpOperation.build<UpdatePortalRequest, UpdatePortalResponse> {
            serializer = UpdatePortalOperationSerializer()
            deserializer = UpdatePortalOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdatePortal"
                hostPrefix = "monitor."
            }
        }
        registerUpdatePortalMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an IoT SiteWise Monitor project.
     */
    override suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse {
        val op = SdkHttpOperation.build<UpdateProjectRequest, UpdateProjectResponse> {
            serializer = UpdateProjectOperationSerializer()
            deserializer = UpdateProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateProject"
                hostPrefix = "monitor."
            }
        }
        registerUpdateProjectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
