// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.DatasetSource
import aws.sdk.kotlin.services.iotsitewise.model.UpdateDatasetRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateDatasetOperationSerializer: HttpSerializer.NonStreaming<UpdateDatasetRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateDatasetRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.datasetId) { "datasetId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("datasets"))
                add(PercentEncoding.SmithyLabel.encode(input.datasetId))
            }
        }

        val payload = serializeUpdateDatasetOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateDatasetOperationBody(context: ExecutionContext, input: UpdateDatasetRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DATASETDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("datasetDescription"))
    val DATASETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("datasetName"))
    val DATASETSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("datasetSource"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DATASETDESCRIPTION_DESCRIPTOR)
        field(DATASETNAME_DESCRIPTOR)
        field(DATASETSOURCE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.datasetDescription?.let { field(DATASETDESCRIPTION_DESCRIPTOR, it) }
        input.datasetName?.let { field(DATASETNAME_DESCRIPTOR, it) }
        input.datasetSource?.let { field(DATASETSOURCE_DESCRIPTOR, it, ::serializeDatasetSourceDocument) }
    }
    return serializer.toByteArray()
}
