// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.PropertyNotificationState
import aws.sdk.kotlin.services.iotsitewise.model.UpdateAssetPropertyRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateAssetPropertyOperationSerializer: HttpSerializer.NonStreaming<UpdateAssetPropertyRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateAssetPropertyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.assetId) { "assetId is bound to the URI and must not be null" }
            requireNotNull(input.propertyId) { "propertyId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("assets"))
                add(PercentEncoding.SmithyLabel.encode(input.assetId))
                add(PercentEncoding.Path.encode("properties"))
                add(PercentEncoding.SmithyLabel.encode(input.propertyId))
            }
        }

        val payload = serializeUpdateAssetPropertyOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAssetPropertyOperationBody(context: ExecutionContext, input: UpdateAssetPropertyRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val PROPERTYALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("propertyAlias"))
    val PROPERTYNOTIFICATIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("propertyNotificationState"))
    val PROPERTYUNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("propertyUnit"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(PROPERTYALIAS_DESCRIPTOR)
        field(PROPERTYNOTIFICATIONSTATE_DESCRIPTOR)
        field(PROPERTYUNIT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.propertyAlias?.let { field(PROPERTYALIAS_DESCRIPTOR, it) }
        input.propertyNotificationState?.let { field(PROPERTYNOTIFICATIONSTATE_DESCRIPTOR, it.value) }
        input.propertyUnit?.let { field(PROPERTYUNIT_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
