// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.Identity
import aws.sdk.kotlin.services.iotsitewise.model.Permission
import aws.sdk.kotlin.services.iotsitewise.model.Resource
import aws.sdk.kotlin.services.iotsitewise.model.UpdateAccessPolicyRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateAccessPolicyOperationSerializer: HttpSerializer.NonStreaming<UpdateAccessPolicyRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateAccessPolicyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.accessPolicyId) { "accessPolicyId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("access-policies"))
                add(PercentEncoding.SmithyLabel.encode(input.accessPolicyId))
            }
        }

        val payload = serializeUpdateAccessPolicyOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAccessPolicyOperationBody(context: ExecutionContext, input: UpdateAccessPolicyRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCESSPOLICYIDENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessPolicyIdentity"))
    val ACCESSPOLICYPERMISSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("accessPolicyPermission"))
    val ACCESSPOLICYRESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessPolicyResource"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSPOLICYIDENTITY_DESCRIPTOR)
        field(ACCESSPOLICYPERMISSION_DESCRIPTOR)
        field(ACCESSPOLICYRESOURCE_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accessPolicyIdentity?.let { field(ACCESSPOLICYIDENTITY_DESCRIPTOR, it, ::serializeIdentityDocument) }
        input.accessPolicyPermission?.let { field(ACCESSPOLICYPERMISSION_DESCRIPTOR, it.value) }
        input.accessPolicyResource?.let { field(ACCESSPOLICYRESOURCE_DESCRIPTOR, it, ::serializeResourceDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
    }
    return serializer.toByteArray()
}
