// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.ConfigurationStatus
import aws.sdk.kotlin.services.iotsitewise.model.DisassociatedDataStorageState
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.sdk.kotlin.services.iotsitewise.model.MultiLayerStorage
import aws.sdk.kotlin.services.iotsitewise.model.PutStorageConfigurationResponse
import aws.sdk.kotlin.services.iotsitewise.model.RetentionPeriod
import aws.sdk.kotlin.services.iotsitewise.model.StorageType
import aws.sdk.kotlin.services.iotsitewise.model.WarmTierRetentionPeriod
import aws.sdk.kotlin.services.iotsitewise.model.WarmTierState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutStorageConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<PutStorageConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutStorageConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutStorageConfigurationError(context, call, payload)
        }
        val builder = PutStorageConfigurationResponse.Builder()

        if (payload != null) {
            deserializePutStorageConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutStorageConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictingOperationException" -> ConflictingOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutStorageConfigurationOperationBody(builder: PutStorageConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFIGURATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("configurationStatus"))
    val DISALLOWINGESTNULLNAN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("disallowIngestNullNaN"))
    val DISASSOCIATEDDATASTORAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("disassociatedDataStorage"))
    val MULTILAYERSTORAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("multiLayerStorage"))
    val RETENTIONPERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("retentionPeriod"))
    val STORAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("storageType"))
    val WARMTIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("warmTier"))
    val WARMTIERRETENTIONPERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("warmTierRetentionPeriod"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGURATIONSTATUS_DESCRIPTOR)
        field(DISALLOWINGESTNULLNAN_DESCRIPTOR)
        field(DISASSOCIATEDDATASTORAGE_DESCRIPTOR)
        field(MULTILAYERSTORAGE_DESCRIPTOR)
        field(RETENTIONPERIOD_DESCRIPTOR)
        field(STORAGETYPE_DESCRIPTOR)
        field(WARMTIER_DESCRIPTOR)
        field(WARMTIERRETENTIONPERIOD_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFIGURATIONSTATUS_DESCRIPTOR.index -> builder.configurationStatus = deserializeConfigurationStatusDocument(deserializer)
                DISALLOWINGESTNULLNAN_DESCRIPTOR.index -> builder.disallowIngestNullNaN = deserializeBoolean()
                DISASSOCIATEDDATASTORAGE_DESCRIPTOR.index -> builder.disassociatedDataStorage = deserializeString().let { DisassociatedDataStorageState.fromValue(it) }
                MULTILAYERSTORAGE_DESCRIPTOR.index -> builder.multiLayerStorage = deserializeMultiLayerStorageDocument(deserializer)
                RETENTIONPERIOD_DESCRIPTOR.index -> builder.retentionPeriod = deserializeRetentionPeriodDocument(deserializer)
                STORAGETYPE_DESCRIPTOR.index -> builder.storageType = deserializeString().let { StorageType.fromValue(it) }
                WARMTIER_DESCRIPTOR.index -> builder.warmTier = deserializeString().let { WarmTierState.fromValue(it) }
                WARMTIERRETENTIONPERIOD_DESCRIPTOR.index -> builder.warmTierRetentionPeriod = deserializeWarmTierRetentionPeriodDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
