// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.ConfigurationStatus
import aws.sdk.kotlin.services.iotsitewise.model.EncryptionType
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.sdk.kotlin.services.iotsitewise.model.PutDefaultEncryptionConfigurationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutDefaultEncryptionConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<PutDefaultEncryptionConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutDefaultEncryptionConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutDefaultEncryptionConfigurationError(context, call, payload)
        }
        val builder = PutDefaultEncryptionConfigurationResponse.Builder()

        if (payload != null) {
            deserializePutDefaultEncryptionConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutDefaultEncryptionConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictingOperationException" -> ConflictingOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutDefaultEncryptionConfigurationOperationBody(builder: PutDefaultEncryptionConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFIGURATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("configurationStatus"))
    val ENCRYPTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("encryptionType"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGURATIONSTATUS_DESCRIPTOR)
        field(ENCRYPTIONTYPE_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFIGURATIONSTATUS_DESCRIPTOR.index -> builder.configurationStatus = deserializeConfigurationStatusDocument(deserializer)
                ENCRYPTIONTYPE_DESCRIPTOR.index -> builder.encryptionType = deserializeString().let { EncryptionType.fromValue(it) }
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
