// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.DescribeTimeSeriesResponse
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.sdk.kotlin.services.iotsitewise.model.PropertyDataType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeTimeSeriesOperationDeserializer: HttpDeserializer.NonStreaming<DescribeTimeSeriesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeTimeSeriesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeTimeSeriesError(context, call, payload)
        }
        val builder = DescribeTimeSeriesResponse.Builder()

        if (payload != null) {
            deserializeDescribeTimeSeriesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeTimeSeriesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTimeSeriesOperationBody(builder: DescribeTimeSeriesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alias"))
    val ASSETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetId"))
    val DATATYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("dataType"))
    val DATATYPESPEC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dataTypeSpec"))
    val PROPERTYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("propertyId"))
    val TIMESERIESARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("timeSeriesArn"))
    val TIMESERIESCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("timeSeriesCreationDate"))
    val TIMESERIESID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("timeSeriesId"))
    val TIMESERIESLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("timeSeriesLastUpdateDate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALIAS_DESCRIPTOR)
        field(ASSETID_DESCRIPTOR)
        field(DATATYPE_DESCRIPTOR)
        field(DATATYPESPEC_DESCRIPTOR)
        field(PROPERTYID_DESCRIPTOR)
        field(TIMESERIESARN_DESCRIPTOR)
        field(TIMESERIESCREATIONDATE_DESCRIPTOR)
        field(TIMESERIESID_DESCRIPTOR)
        field(TIMESERIESLASTUPDATEDATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALIAS_DESCRIPTOR.index -> builder.alias = deserializeString()
                ASSETID_DESCRIPTOR.index -> builder.assetId = deserializeString()
                DATATYPE_DESCRIPTOR.index -> builder.dataType = deserializeString().let { PropertyDataType.fromValue(it) }
                DATATYPESPEC_DESCRIPTOR.index -> builder.dataTypeSpec = deserializeString()
                PROPERTYID_DESCRIPTOR.index -> builder.propertyId = deserializeString()
                TIMESERIESARN_DESCRIPTOR.index -> builder.timeSeriesArn = deserializeString()
                TIMESERIESCREATIONDATE_DESCRIPTOR.index -> builder.timeSeriesCreationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                TIMESERIESID_DESCRIPTOR.index -> builder.timeSeriesId = deserializeString()
                TIMESERIESLASTUPDATEDATE_DESCRIPTOR.index -> builder.timeSeriesLastUpdateDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
