// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.Alarms
import aws.sdk.kotlin.services.iotsitewise.model.AuthMode
import aws.sdk.kotlin.services.iotsitewise.model.DescribePortalResponse
import aws.sdk.kotlin.services.iotsitewise.model.ImageLocation
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.sdk.kotlin.services.iotsitewise.model.PortalStatus
import aws.sdk.kotlin.services.iotsitewise.model.PortalType
import aws.sdk.kotlin.services.iotsitewise.model.PortalTypeEntry
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class DescribePortalOperationDeserializer: HttpDeserializer.NonStreaming<DescribePortalResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribePortalResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribePortalError(context, call, payload)
        }
        val builder = DescribePortalResponse.Builder()

        if (payload != null) {
            deserializeDescribePortalOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribePortalError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePortalOperationBody(builder: DescribePortalResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALARMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarms"))
    val NOTIFICATIONSENDEREMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("notificationSenderEmail"))
    val PORTALARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalArn"))
    val PORTALAUTHMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("portalAuthMode"))
    val PORTALCLIENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalClientId"))
    val PORTALCONTACTEMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalContactEmail"))
    val PORTALCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("portalCreationDate"))
    val PORTALDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalDescription"))
    val PORTALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalId"))
    val PORTALLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("portalLastUpdateDate"))
    val PORTALLOGOIMAGELOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("portalLogoImageLocation"))
    val PORTALNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalName"))
    val PORTALSTARTURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalStartUrl"))
    val PORTALSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("portalStatus"))
    val PORTALTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("portalType"))
    val PORTALTYPECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("portalTypeConfiguration"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALARMS_DESCRIPTOR)
        field(NOTIFICATIONSENDEREMAIL_DESCRIPTOR)
        field(PORTALARN_DESCRIPTOR)
        field(PORTALAUTHMODE_DESCRIPTOR)
        field(PORTALCLIENTID_DESCRIPTOR)
        field(PORTALCONTACTEMAIL_DESCRIPTOR)
        field(PORTALCREATIONDATE_DESCRIPTOR)
        field(PORTALDESCRIPTION_DESCRIPTOR)
        field(PORTALID_DESCRIPTOR)
        field(PORTALLASTUPDATEDATE_DESCRIPTOR)
        field(PORTALLOGOIMAGELOCATION_DESCRIPTOR)
        field(PORTALNAME_DESCRIPTOR)
        field(PORTALSTARTURL_DESCRIPTOR)
        field(PORTALSTATUS_DESCRIPTOR)
        field(PORTALTYPE_DESCRIPTOR)
        field(PORTALTYPECONFIGURATION_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALARMS_DESCRIPTOR.index -> builder.alarms = deserializeAlarmsDocument(deserializer)
                NOTIFICATIONSENDEREMAIL_DESCRIPTOR.index -> builder.notificationSenderEmail = deserializeString()
                PORTALARN_DESCRIPTOR.index -> builder.portalArn = deserializeString()
                PORTALAUTHMODE_DESCRIPTOR.index -> builder.portalAuthMode = deserializeString().let { AuthMode.fromValue(it) }
                PORTALCLIENTID_DESCRIPTOR.index -> builder.portalClientId = deserializeString()
                PORTALCONTACTEMAIL_DESCRIPTOR.index -> builder.portalContactEmail = deserializeString()
                PORTALCREATIONDATE_DESCRIPTOR.index -> builder.portalCreationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                PORTALDESCRIPTION_DESCRIPTOR.index -> builder.portalDescription = deserializeString()
                PORTALID_DESCRIPTOR.index -> builder.portalId = deserializeString()
                PORTALLASTUPDATEDATE_DESCRIPTOR.index -> builder.portalLastUpdateDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                PORTALLOGOIMAGELOCATION_DESCRIPTOR.index -> builder.portalLogoImageLocation = deserializeImageLocationDocument(deserializer)
                PORTALNAME_DESCRIPTOR.index -> builder.portalName = deserializeString()
                PORTALSTARTURL_DESCRIPTOR.index -> builder.portalStartUrl = deserializeString()
                PORTALSTATUS_DESCRIPTOR.index -> builder.portalStatus = deserializePortalStatusDocument(deserializer)
                PORTALTYPE_DESCRIPTOR.index -> builder.portalType = deserializeString().let { PortalType.fromValue(it) }
                PORTALTYPECONFIGURATION_DESCRIPTOR.index -> builder.portalTypeConfiguration =
                    deserializer.deserializeMap(PORTALTYPECONFIGURATION_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, PortalTypeEntry>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializePortalTypeEntryDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
