// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.DescribeExecutionResponse
import aws.sdk.kotlin.services.iotsitewise.model.ExecutionStatus
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.sdk.kotlin.services.iotsitewise.model.ResolveTo
import aws.sdk.kotlin.services.iotsitewise.model.TargetResource
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class DescribeExecutionOperationDeserializer: HttpDeserializer.NonStreaming<DescribeExecutionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeExecutionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeExecutionError(context, call, payload)
        }
        val builder = DescribeExecutionResponse.Builder()

        if (payload != null) {
            deserializeDescribeExecutionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeExecutionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeExecutionOperationBody(builder: DescribeExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("actionType"))
    val EXECUTIONDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("executionDetails"))
    val EXECUTIONENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("executionEndTime"))
    val EXECUTIONENTITYVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("executionEntityVersion"))
    val EXECUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("executionId"))
    val EXECUTIONRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("executionResult"))
    val EXECUTIONSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("executionStartTime"))
    val EXECUTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("executionStatus"))
    val RESOLVETO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resolveTo"))
    val TARGETRESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("targetResource"))
    val TARGETRESOURCEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetResourceVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONTYPE_DESCRIPTOR)
        field(EXECUTIONDETAILS_DESCRIPTOR)
        field(EXECUTIONENDTIME_DESCRIPTOR)
        field(EXECUTIONENTITYVERSION_DESCRIPTOR)
        field(EXECUTIONID_DESCRIPTOR)
        field(EXECUTIONRESULT_DESCRIPTOR)
        field(EXECUTIONSTARTTIME_DESCRIPTOR)
        field(EXECUTIONSTATUS_DESCRIPTOR)
        field(RESOLVETO_DESCRIPTOR)
        field(TARGETRESOURCE_DESCRIPTOR)
        field(TARGETRESOURCEVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIONTYPE_DESCRIPTOR.index -> builder.actionType = deserializeString()
                EXECUTIONDETAILS_DESCRIPTOR.index -> builder.executionDetails =
                    deserializer.deserializeMap(EXECUTIONDETAILS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                EXECUTIONENDTIME_DESCRIPTOR.index -> builder.executionEndTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                EXECUTIONENTITYVERSION_DESCRIPTOR.index -> builder.executionEntityVersion = deserializeString()
                EXECUTIONID_DESCRIPTOR.index -> builder.executionId = deserializeString()
                EXECUTIONRESULT_DESCRIPTOR.index -> builder.executionResult =
                    deserializer.deserializeMap(EXECUTIONRESULT_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                EXECUTIONSTARTTIME_DESCRIPTOR.index -> builder.executionStartTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                EXECUTIONSTATUS_DESCRIPTOR.index -> builder.executionStatus = deserializeExecutionStatusDocument(deserializer)
                RESOLVETO_DESCRIPTOR.index -> builder.resolveTo = deserializeResolveToDocument(deserializer)
                TARGETRESOURCE_DESCRIPTOR.index -> builder.targetResource = deserializeTargetResourceDocument(deserializer)
                TARGETRESOURCEVERSION_DESCRIPTOR.index -> builder.targetResourceVersion = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
