// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.DatasetSource
import aws.sdk.kotlin.services.iotsitewise.model.DatasetStatus
import aws.sdk.kotlin.services.iotsitewise.model.DescribeDatasetResponse
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeDatasetOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDatasetResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDatasetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDatasetError(context, call, payload)
        }
        val builder = DescribeDatasetResponse.Builder()

        if (payload != null) {
            deserializeDescribeDatasetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDatasetError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDatasetOperationBody(builder: DescribeDatasetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATASETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("datasetArn"))
    val DATASETCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("datasetCreationDate"))
    val DATASETDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("datasetDescription"))
    val DATASETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("datasetId"))
    val DATASETLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("datasetLastUpdateDate"))
    val DATASETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("datasetName"))
    val DATASETSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("datasetSource"))
    val DATASETSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("datasetStatus"))
    val DATASETVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("datasetVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATASETARN_DESCRIPTOR)
        field(DATASETCREATIONDATE_DESCRIPTOR)
        field(DATASETDESCRIPTION_DESCRIPTOR)
        field(DATASETID_DESCRIPTOR)
        field(DATASETLASTUPDATEDATE_DESCRIPTOR)
        field(DATASETNAME_DESCRIPTOR)
        field(DATASETSOURCE_DESCRIPTOR)
        field(DATASETSTATUS_DESCRIPTOR)
        field(DATASETVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATASETARN_DESCRIPTOR.index -> builder.datasetArn = deserializeString()
                DATASETCREATIONDATE_DESCRIPTOR.index -> builder.datasetCreationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATASETDESCRIPTION_DESCRIPTOR.index -> builder.datasetDescription = deserializeString()
                DATASETID_DESCRIPTOR.index -> builder.datasetId = deserializeString()
                DATASETLASTUPDATEDATE_DESCRIPTOR.index -> builder.datasetLastUpdateDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATASETNAME_DESCRIPTOR.index -> builder.datasetName = deserializeString()
                DATASETSOURCE_DESCRIPTOR.index -> builder.datasetSource = deserializeDatasetSourceDocument(deserializer)
                DATASETSTATUS_DESCRIPTOR.index -> builder.datasetStatus = deserializeDatasetStatusDocument(deserializer)
                DATASETVERSION_DESCRIPTOR.index -> builder.datasetVersion = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
