// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.DescribeDashboardResponse
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeDashboardOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDashboardResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDashboardResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDashboardError(context, call, payload)
        }
        val builder = DescribeDashboardResponse.Builder()

        if (payload != null) {
            deserializeDescribeDashboardOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDashboardError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDashboardOperationBody(builder: DescribeDashboardResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DASHBOARDARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dashboardArn"))
    val DASHBOARDCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("dashboardCreationDate"))
    val DASHBOARDDEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dashboardDefinition"))
    val DASHBOARDDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dashboardDescription"))
    val DASHBOARDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dashboardId"))
    val DASHBOARDLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("dashboardLastUpdateDate"))
    val DASHBOARDNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dashboardName"))
    val PROJECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DASHBOARDARN_DESCRIPTOR)
        field(DASHBOARDCREATIONDATE_DESCRIPTOR)
        field(DASHBOARDDEFINITION_DESCRIPTOR)
        field(DASHBOARDDESCRIPTION_DESCRIPTOR)
        field(DASHBOARDID_DESCRIPTOR)
        field(DASHBOARDLASTUPDATEDATE_DESCRIPTOR)
        field(DASHBOARDNAME_DESCRIPTOR)
        field(PROJECTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DASHBOARDARN_DESCRIPTOR.index -> builder.dashboardArn = deserializeString()
                DASHBOARDCREATIONDATE_DESCRIPTOR.index -> builder.dashboardCreationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DASHBOARDDEFINITION_DESCRIPTOR.index -> builder.dashboardDefinition = deserializeString()
                DASHBOARDDESCRIPTION_DESCRIPTOR.index -> builder.dashboardDescription = deserializeString()
                DASHBOARDID_DESCRIPTOR.index -> builder.dashboardId = deserializeString()
                DASHBOARDLASTUPDATEDATE_DESCRIPTOR.index -> builder.dashboardLastUpdateDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DASHBOARDNAME_DESCRIPTOR.index -> builder.dashboardName = deserializeString()
                PROJECTID_DESCRIPTOR.index -> builder.projectId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
