// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.ActionDefinition
import aws.sdk.kotlin.services.iotsitewise.model.ComputationModelConfiguration
import aws.sdk.kotlin.services.iotsitewise.model.ComputationModelDataBindingValue
import aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus
import aws.sdk.kotlin.services.iotsitewise.model.DescribeComputationModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeComputationModelOperationDeserializer: HttpDeserializer.NonStreaming<DescribeComputationModelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeComputationModelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeComputationModelError(context, call, payload)
        }
        val builder = DescribeComputationModelResponse.Builder()

        if (payload != null) {
            deserializeDescribeComputationModelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeComputationModelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeComputationModelOperationBody(builder: DescribeComputationModelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIONDEFINITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("actionDefinitions"))
    val COMPUTATIONMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("computationModelArn"))
    val COMPUTATIONMODELCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("computationModelConfiguration"))
    val COMPUTATIONMODELCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("computationModelCreationDate"))
    val COMPUTATIONMODELDATABINDING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("computationModelDataBinding"))
    val COMPUTATIONMODELDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("computationModelDescription"))
    val COMPUTATIONMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("computationModelId"))
    val COMPUTATIONMODELLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("computationModelLastUpdateDate"))
    val COMPUTATIONMODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("computationModelName"))
    val COMPUTATIONMODELSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("computationModelStatus"))
    val COMPUTATIONMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("computationModelVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONDEFINITIONS_DESCRIPTOR)
        field(COMPUTATIONMODELARN_DESCRIPTOR)
        field(COMPUTATIONMODELCONFIGURATION_DESCRIPTOR)
        field(COMPUTATIONMODELCREATIONDATE_DESCRIPTOR)
        field(COMPUTATIONMODELDATABINDING_DESCRIPTOR)
        field(COMPUTATIONMODELDESCRIPTION_DESCRIPTOR)
        field(COMPUTATIONMODELID_DESCRIPTOR)
        field(COMPUTATIONMODELLASTUPDATEDATE_DESCRIPTOR)
        field(COMPUTATIONMODELNAME_DESCRIPTOR)
        field(COMPUTATIONMODELSTATUS_DESCRIPTOR)
        field(COMPUTATIONMODELVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIONDEFINITIONS_DESCRIPTOR.index -> builder.actionDefinitions =
                    deserializer.deserializeList(ACTIONDEFINITIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ActionDefinition>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeActionDefinitionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                COMPUTATIONMODELARN_DESCRIPTOR.index -> builder.computationModelArn = deserializeString()
                COMPUTATIONMODELCONFIGURATION_DESCRIPTOR.index -> builder.computationModelConfiguration = deserializeComputationModelConfigurationDocument(deserializer)
                COMPUTATIONMODELCREATIONDATE_DESCRIPTOR.index -> builder.computationModelCreationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                COMPUTATIONMODELDATABINDING_DESCRIPTOR.index -> builder.computationModelDataBinding =
                    deserializer.deserializeMap(COMPUTATIONMODELDATABINDING_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, ComputationModelDataBindingValue>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeComputationModelDataBindingValueDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                COMPUTATIONMODELDESCRIPTION_DESCRIPTOR.index -> builder.computationModelDescription = deserializeString()
                COMPUTATIONMODELID_DESCRIPTOR.index -> builder.computationModelId = deserializeString()
                COMPUTATIONMODELLASTUPDATEDATE_DESCRIPTOR.index -> builder.computationModelLastUpdateDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                COMPUTATIONMODELNAME_DESCRIPTOR.index -> builder.computationModelName = deserializeString()
                COMPUTATIONMODELSTATUS_DESCRIPTOR.index -> builder.computationModelStatus = deserializeComputationModelStatusDocument(deserializer)
                COMPUTATIONMODELVERSION_DESCRIPTOR.index -> builder.computationModelVersion = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
