// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.serde

import aws.sdk.kotlin.services.iotsitewise.model.DescribeBulkImportJobResponse
import aws.sdk.kotlin.services.iotsitewise.model.ErrorReportLocation
import aws.sdk.kotlin.services.iotsitewise.model.File
import aws.sdk.kotlin.services.iotsitewise.model.IotSiteWiseException
import aws.sdk.kotlin.services.iotsitewise.model.JobConfiguration
import aws.sdk.kotlin.services.iotsitewise.model.JobStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeBulkImportJobOperationDeserializer: HttpDeserializer.NonStreaming<DescribeBulkImportJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeBulkImportJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeBulkImportJobError(context, call, payload)
        }
        val builder = DescribeBulkImportJobResponse.Builder()

        if (payload != null) {
            deserializeDescribeBulkImportJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeBulkImportJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotSiteWiseException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotSiteWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBulkImportJobOperationBody(builder: DescribeBulkImportJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADAPTIVEINGESTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("adaptiveIngestion"))
    val DELETEFILESAFTERIMPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("deleteFilesAfterImport"))
    val ERRORREPORTLOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("errorReportLocation"))
    val FILES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("files"))
    val JOBCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jobConfiguration"))
    val JOBCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("jobCreationDate"))
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobId"))
    val JOBLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("jobLastUpdateDate"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobName"))
    val JOBROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobRoleArn"))
    val JOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("jobStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADAPTIVEINGESTION_DESCRIPTOR)
        field(DELETEFILESAFTERIMPORT_DESCRIPTOR)
        field(ERRORREPORTLOCATION_DESCRIPTOR)
        field(FILES_DESCRIPTOR)
        field(JOBCONFIGURATION_DESCRIPTOR)
        field(JOBCREATIONDATE_DESCRIPTOR)
        field(JOBID_DESCRIPTOR)
        field(JOBLASTUPDATEDATE_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(JOBROLEARN_DESCRIPTOR)
        field(JOBSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADAPTIVEINGESTION_DESCRIPTOR.index -> builder.adaptiveIngestion = deserializeBoolean()
                DELETEFILESAFTERIMPORT_DESCRIPTOR.index -> builder.deleteFilesAfterImport = deserializeBoolean()
                ERRORREPORTLOCATION_DESCRIPTOR.index -> builder.errorReportLocation = deserializeErrorReportLocationDocument(deserializer)
                FILES_DESCRIPTOR.index -> builder.files =
                    deserializer.deserializeList(FILES_DESCRIPTOR) {
                        val col0 = mutableListOf<File>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFileDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                JOBCONFIGURATION_DESCRIPTOR.index -> builder.jobConfiguration = deserializeJobConfigurationDocument(deserializer)
                JOBCREATIONDATE_DESCRIPTOR.index -> builder.jobCreationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                JOBLASTUPDATEDATE_DESCRIPTOR.index -> builder.jobLastUpdateDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                JOBNAME_DESCRIPTOR.index -> builder.jobName = deserializeString()
                JOBROLEARN_DESCRIPTOR.index -> builder.jobRoleArn = deserializeString()
                JOBSTATUS_DESCRIPTOR.index -> builder.jobStatus = deserializeString().let { JobStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
